<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 6.7
 */
use \Directorist\Helper;

if (!defined('ABSPATH')) exit;

$id = get_the_ID();

$loop_fields = $listings->loop['card_fields']['template_data']['grid_view_with_thumbnail'];

if (class_exists('ReduxFramework')) {
    $piller_listing_archive = piller_opt('piller_listing_archive');
} else {
    $piller_listing_archive = '0';
}
  

if( $piller_listing_archive == 'default' ){
    ?>

    <article class="directorist-listing-single directorist-listing-single--bg directorist-listing-card directorist-listing-has-thumb <?php echo esc_attr($listings->loop_wrapper_class()); ?>">

        <div class="directorist-listing-single__thumb">

            <?php
            $listings->loop_thumb_card_template();
            $listings->render_loop_fields($loop_fields['thumbnail']['avatar']);
            ?>

            <div class="directorist-thumb-top-left"><?php $listings->render_loop_fields($loop_fields['thumbnail']['top_left']); ?></div>
            <div class="directorist-thumb-top-right"><?php $listings->render_loop_fields($loop_fields['thumbnail']['top_right']); ?></div>
            <div class="directorist-thumb-bottom-left"><?php $listings->render_loop_fields($loop_fields['thumbnail']['bottom_left']); ?></div>
            <div class="directorist-thumb-bottom-right"><?php $listings->render_loop_fields($loop_fields['thumbnail']['bottom_right']); ?></div>

        </div>

        <div class="directorist-listing-single__content">
            <section class="directorist-listing-single__info">
                <header class="directorist-listing-single__info__top">
                    <?php $listings->render_loop_fields($loop_fields['body']['top'], 'div', 'div'); ?>
                </header>

                <ul class="directorist-listing-single__info__list">
                    <?php $listings->render_loop_fields($loop_fields['body']['bottom'], 'li', 'li'); ?>
                </ul>

                <?php if (!empty($loop_fields['body']['excerpt'])) : ?>
                    <?php $listings->render_loop_fields($loop_fields['body']['excerpt']); ?>
                <?php endif; ?>
            </section>

            <footer class="directorist-listing-single__meta">
                <div class="directorist-listing-single__meta__left"><?php $listings->render_loop_fields($loop_fields['footer']['left']); ?></div>
                <div class="directorist-listing-single__meta__right"><?php $listings->render_loop_fields($loop_fields['footer']['right']); ?></div>
            </footer>
        </div>

    </article>
<?php
} else { 

    $bed =  piller_meta('piller_bed_count') ? piller_meta('piller_bed_count') : ' --';
	$bed_label = piller_opt('piller_listing_bed_text') ? piller_opt('piller_listing_bed_text') : 'Bed ';

	$bath =  piller_meta('piller_bath_count') ? piller_meta('piller_bath_count') : ' --';
	$bath_label = piller_opt('piller_listing_bath_text') ? piller_opt('piller_listing_bath_text') : 'Bath ';

	$sqft =  piller_meta('piller_room_size') ? piller_meta('piller_room_size') : ' --';
	$sqft_label2 =  piller_opt('piller_listing_sqft_text') ? piller_opt('piller_listing_sqft_text') : '';

    $button_text = piller_opt('piller_listing_readmore') ? piller_opt('piller_listing_readmore') : 'View More';
    
    ?>
    <div class="directorist-listing-single__thumb">
        <?php 
        $listings->loop_thumb_card_template(); 
        $listings->render_loop_fields($loop_fields['thumbnail']['avatar']);
        ?> 
        <div class="directorist-thumb-top-left"><?php $listings->render_loop_fields($loop_fields['thumbnail']['top_left']); ?></div>
        <div class="directorist-thumb-top-right"><?php $listings->render_loop_fields($loop_fields['thumbnail']['top_right']); ?></div>
        <div class="directorist-thumb-bottom-left"><?php $listings->render_loop_fields($loop_fields['thumbnail']['bottom_left']); ?></div>
        <div class="directorist-thumb-bottom-right"><?php $listings->render_loop_fields($loop_fields['thumbnail']['bottom_right']); ?></div>
    </div>

    <div class="property-content">
        <div class="media-body">
            <h3 class="box-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
            <div class="box-text">
                <?php 
                    if(!empty(piller_opt('piller_listing_location_icon', 'url' ) )){
                        echo '<div class="icon">';
                            echo '<img src="'.esc_url( piller_opt('piller_listing_location_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                        echo '</div>';
                    }

                     if (!empty(piller_meta('piller_address'))) {
                        echo esc_html(piller_meta('piller_address'));
                    } else {
                        echo '<p class="property-card-location">' .directorist_the_locations() . '</p>';
                    }
                ?>
            </div>
        </div>

        <ul class="property-featured">
            <?php
                echo '<li>';
                    if(!empty(piller_opt('piller_listing_bed_icon', 'url' ) )){
                        echo '<div class="icon">';
                            echo '<img src="'.esc_url( piller_opt('piller_listing_bed_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                        echo '</div>';
                    }
                    echo esc_html( $bed_label.' '.$bed );
                echo '</li>';

                echo '<li>';
                    if(!empty(piller_opt('piller_listing_bath_icon', 'url' ) )){
                        echo '<div class="icon">';
                            echo '<img src="'.esc_url( piller_opt('piller_listing_bath_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                        echo '</div>';
                    }
                    echo esc_html( $bath_label.' '.$bath );
                echo '</li>';

                echo '<li>';
                    if(!empty(piller_opt('piller_listing_sqft_icon', 'url' ) )){
                        echo '<div class="icon">';
                            echo '<img src="'.esc_url( piller_opt('piller_listing_sqft_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                        echo '</div>';
                    }
                    echo esc_html( $sqft.' '.$sqft_label2 );
                echo '</li>'; 
            ?>
        </ul>
        <div class="property-bottom">
            <h6 class="box-title">
                <?php
                    if ('range' === Helper::pricing_type($id)) {
                        Helper::price_range_template($id);
                    } elseif (!$listings->is_disable_price) {
                        Helper::price_template($id);
                    }
                ?>
            </h6>
            <a href="<?php the_permalink(); ?>" class="th-btn sm style3 pill"><?php echo esc_html($button_text); ?></a>
        </div>
    </div>

    <?php

}

?>
