<?php
/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    piller_setPostViews( get_the_ID() );

    ?>
    <div <?php post_class(); ?>>
    <?php
        if( class_exists('ReduxFramework') ) {
            $piller_post_details_title_position = piller_opt('piller_post_details_title_position');
        } else {
            $piller_post_details_title_position = 'header';
        }

        $allowhtml = array(
            'p'         => array(
                'class'     => array()
            ),
            'span'      => array(),
            'a'         => array(
                'href'      => array(),
                'title'     => array()
            ),
            'br'        => array(),
            'em'        => array(),
            'strong'    => array(),
            'b'         => array(),
        );
        // Blog Post Thumbnail
        do_action( 'piller_blog_post_thumb' );
        
        echo '<div class="blog-content">';
            // Blog Post Meta 
            do_action( 'piller_blog_post_meta' );

            if( $piller_post_details_title_position != 'header' ) {
                echo '<h2 class="blog-title">'.wp_kses( get_the_title(), $allowhtml ).'</h2>';
            }

            if( get_the_content() ){

                the_content();
                // Link Pages
                piller_link_pages();
            }  

            if( class_exists('ReduxFramework') ) {
                $piller_post_details_share_options = piller_opt('piller_post_details_share_options');
                $piller_display_post_tags = piller_opt('piller_display_post_tags');
                $piller_author_options = piller_opt('piller_post_details_author_desc_trigger');
            } else {
                $piller_post_details_share_options = false;
                $piller_display_post_tags = false;
                $piller_author_options = false;
            }
            
            $piller_post_tag = get_the_tags();
            
            if( ! empty( $piller_display_post_tags ) || ( ! empty($piller_post_details_share_options )) ){
                echo '<div class="share-links clearfix">';
                    echo '<div class="row justify-content-between">';
                        if( is_array( $piller_post_tag ) && ! empty( $piller_post_tag ) ){
                            if( count( $piller_post_tag ) > 1 ){
                                $tag_text = __( 'Tags:', 'piller' );
                            }else{
                                $tag_text = __( 'Tag:', 'piller' );
                            } 
                            if($piller_display_post_tags){ 
                                echo '<div class="col-sm-auto">';
                                    echo '<span class="share-links-title">'.esc_html($tag_text).'</span>';
                                    echo '<div class="tagcloud">';
                                        foreach( $piller_post_tag as $tags ){
                                            echo '<a href="'.esc_url( get_tag_link( $tags->term_id ) ).'">'.esc_html( $tags->name ).'</a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            }
                        }
    
                        /**
                        *
                        * Hook for Blog Details Share Options
                        *
                        * Hook piller_blog_details_share_options
                        *
                        * @Hooked piller_blog_details_share_options_cb 10
                        *
                        */
                        do_action( 'piller_blog_details_share_options' );
    
                    echo '</div>';
    
                echo '</div>';    
            }  
        
        echo '</div>';

    echo '</div>'; 

        /**
        *
        * Hook for Post Navigation
        *
        * Hook piller_blog_details_post_navigation
        *
        * @Hooked piller_blog_details_post_navigation_cb 10
        *
        */
        do_action( 'piller_blog_details_post_navigation' );

        /**
        *
        * Hook for Blog Authro Bio
        *
        * Hook piller_blog_details_author_bio
        *
        * @Hooked piller_blog_details_author_bio_cb 10
        *
        */
        do_action( 'piller_blog_details_author_bio' );

        /**
        *
        * Hook for Blog Details Comments
        *
        * Hook piller_blog_details_comments
        *
        * @Hooked piller_blog_details_comments_cb 10
        *
        */
        do_action( 'piller_blog_details_comments' );
