<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget . 
 *
 */
class Piller_Header extends Widget_Base {

	public function get_name() {
		return 'pillerheader';
	}
	public function get_title() {
		return __( 'Header', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' 	=> __( 'Header', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', ['Style One', 'Style Two'] );

		$this->add_control(
			'show_top_bar',
			[
				'label' 		=> __( 'Show Top Bar?', 'piller' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'piller' ),
				'label_off' 	=> __( 'Hide', 'piller' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$repeater = new Repeater();

		piller_general_fields($repeater, 'content', 'Content', 'TEXTAREA', 'Content here');
		
		$this->add_control(
			'contact_info',
			[
				'label' 		=> __( 'Contact Info', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
		);	
		
		piller_switcher_fields($this, 'show_social_icon', 'Show Social Icon?', ['1', '2']);
		piller_social_fields($this, 'social_icon_list', 'Social List', ['1', '2']);
				
		piller_switcher_fields($this, 'show_lang_btn', 'Show Language Button?', ['1', '2']);

		$this->add_control(
			'logo_image',
			[
				'label' 		=> __( 'Upload Logo', 'piller' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);				

		$menus = $this->piller_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'piller_menu_select',
				[
					'label'     	=> __( 'Select piller Menu', 'piller' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'piller' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'piller' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'piller' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

		piller_switcher_fields($this, 'show_search_btn', 'Show Search Button?', ['1']);

		piller_general_fields( $this, 'button_text', 'Button Text', 'TEXT', ' Add Listing', ['1', '2'] );
		piller_url_fields( $this, 'button_url', 'Button URL', ['1', '2'] );

		piller_switcher_fields($this, 'show_offcanvas_btn', 'Show Offcanvas Button?', ['2']);

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------General Style-------
		 $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'Background Styling', 'piller' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		piller_color_fields( $this, '01', 'Topbar Background', 'background', '{{WRAPPER}} .header-top', ['1', '2'] );
		piller_color_fields( $this, '02', 'Menu Background', 'background', '{{WRAPPER}} .menu-area', ['1', '2'] );                

		$this->end_controls_section();

		//------Menu Bar Style-------
        $this->start_controls_section(
			'menubar_styling2',
			[
				'label'     => __( 'Menu Styling', 'piller' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		piller_color_fields( $this, 'menu_color1', 'Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a', ['1'] );
		piller_color_fields( $this, 'menu_color2', 'Hover Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a:hover', ['1'] );
		piller_color_fields( $this, 'menu_color3', 'Dropdown Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a' );
		piller_color_fields( $this, 'menu_color4', 'Dropdown Hover Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:hover' );
		piller_color_fields( $this, 'menu_color5', 'Menu Icon Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:before, {{WRAPPER}} .main-menu ul li.menu-item-has-children > a:after' );

		piller_typography_fields( $this, 'menu_font', 'Menu Trpography', '{{WRAPPER}} .main-menu>ul>li>a, {{WRAPPER}} .main-menu ul.sub-menu li a' );

		piller_dimensions_fields( $this, 'menu_margin', 'Menu Margin', 'margin', '{{WRAPPER}} .main-menu>ul>li>a' );
		piller_dimensions_fields( $this, 'menu_padding', 'Menu Padding', 'padding', '{{WRAPPER}} .main-menu>ul>li>a' );

		$this->end_controls_section();

		//------Button Style-------
		piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn', ['1', '2'] );

    }

    public function piller_menu_select(){
	    $piller_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'piller' );
	    foreach( $piller_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		global $woocommerce;

        //Menu by menu select
        $piller_avaiable_menu   = $this->piller_menu_select();
		if( ! $piller_avaiable_menu ){
			return;
		}
		$args = [
			'menu' 			=> $settings['piller_menu_select'],
			'menu_class' 	=> 'piller-menu',
			'container' 	=> '',
		];

		//Mobile menu, Offcanvas, Search
        echo piller_mobile_menu();
		// echo piller_header_cart_offcanvas();
		if(!empty( $settings['show_offcanvas_btn'])){
			echo piller_header_offcanvas();
		}
		if(!empty( $settings['show_search_btn'])){
			echo piller_search_box();
		}
		// Header sub-menu icon
		if( class_exists( 'ReduxFramework' ) ){ 
			if(piller_opt('piller_header_sticky')){
                $sticky = '';
            }else{
                $sticky = '-no';
            }

			if(piller_opt('piller_menu_icon')){
				$menu_icon = '';
			}else{
				$menu_icon = 'hide-icon';
			}
		}

		if( $settings['layout_style'] == '1' ){
			echo '<header class="th-header header-default header-layout1">';
				if(!empty($settings['show_top_bar'])){
					echo '<div class="header-top">';
						echo '<div class="container">';
							echo '<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">';
								echo '<div class="col-auto d-none d-lg-block">';
									echo '<div class="header-links">';
										echo '<ul>';
											foreach ( $settings['contact_info'] as $index => $data ) {
												if(!empty($data['content'])){
													echo '<li>' . wp_kses_post( $data['content'] ) . '</li>';
												}
											}
										echo '</ul>';
									echo '</div>';
								echo '</div>';
			
								echo '<div class="col-auto">';
									echo '<div class="header-links">';
										echo '<ul>';
											if(!empty($settings['show_social_icon'])){
												echo '<li>';
													echo '<div class="th-social">';
														foreach( $settings['social_icon_list'] as $social_icon ){
															$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
															$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
										
															echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';
										
															\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
										
															echo '</a> ';
														}
													echo '</div>';
												echo '</li>'; 
											}
											if(!empty($settings['show_lang_btn'])){
												echo '<li class="lang-wrapper">';
													 echo '<div class="dropdown-link">';
                                                        echo do_shortcode('[gtranslate]');
                                                    echo '</div>';
												echo '</li>';
											}
										echo '</ul>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}

				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container">';
							echo '<div class="row align-items-center justify-content-between">';
								echo '<div class="col-auto">';
									echo '<div class="header-logo">';
										echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo piller_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
									echo '</div>';
								echo '</div>';
								echo '<div class="col-auto">';
									echo '<nav class="main-menu d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
										if( ! empty( $settings['piller_menu_select'] ) ){
											wp_nav_menu( $args );
										}else{
											wp_nav_menu( array(
												"theme_location"    => 'primary-menu',
												"container"         => '',
												"menu_class"        => ''
											) );
										}
									echo '</nav>';
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								echo '<div class="col-auto d-none d-xl-block">';
									echo '<div class="header-button">';
										if(!empty( $settings['button_text'])){
											echo '<a href="'.esc_attr($settings['button_url']['url']).'" class="th-btn outline pill">'.wp_kses_post($settings['button_text']).'</a>';
										}
										if(!empty($settings['show_search_btn'])){
											echo '<button type="button" class="icon-btn searchBoxToggler text-white"><i class="far fa-search"></i></button>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
			
		}elseif( $settings['layout_style'] == '2' ){
			echo '<header class="th-header header-default">';
				if(!empty($settings['show_top_bar'])){
					echo '<div class="header-top">';
						echo '<div class="container th-container3">';
							echo '<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">';
								echo '<div class="col-auto d-none d-lg-block">';
									echo '<div class="header-links">';
										echo '<ul>';
											foreach ( $settings['contact_info'] as $index => $data ) {
												if(!empty($data['content'])){
													echo '<li>' . wp_kses_post( $data['content'] ) . '</li>';
												}
											}
										echo '</ul>';
									echo '</div>';
								echo '</div>';
			
								echo '<div class="col-auto">';
									echo '<div class="header-links">';
										echo '<ul>';
											if(!empty($settings['show_social_icon'])){
												echo '<li>';
													echo '<div class="th-social">';
														foreach( $settings['social_icon_list'] as $social_icon ){
															$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
															$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
										
															echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';
										
															\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
										
															echo '</a> ';
														}
													echo '</div>';
												echo '</li>'; 
											}
											if(!empty($settings['show_lang_btn'])){
												echo '<li class="lang-wrapper">';
													 echo '<div class="dropdown-link">';
                                                        echo do_shortcode('[gtranslate]');
                                                    echo '</div>';
												echo '</li>';
											}
										echo '</ul>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}

				echo '<div class="sticky-wrapper'.esc_attr($sticky).'">';
					echo '<!-- Main Menu Area -->';
					echo '<div class="menu-area">';
						echo '<div class="container th-container3">';
							echo '<div class="row align-items-center justify-content-between">';
								echo '<div class="col-auto">';
									echo '<div class="header-logo">';
										echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo piller_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
									echo '</div>';
								echo '</div>';
								echo '<div class="col-auto">';
									echo '<nav class="main-menu d-none d-lg-inline-block '.esc_attr($menu_icon).'">';
										if( ! empty( $settings['piller_menu_select'] ) ){
											wp_nav_menu( $args );
										}else{
											wp_nav_menu( array(
												"theme_location"    => 'primary-menu',
												"container"         => '',
												"menu_class"        => ''
											) );
										}
									echo '</nav>';
									echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
								echo '</div>';
								echo '<div class="col-auto d-none d-xl-block">';
									echo '<div class="header-button">';
										if(!empty( $settings['button_text'])){
											echo '<a href="'.esc_attr($settings['button_url']['url']).'" class="th-btn pill">'.wp_kses_post($settings['button_text']).'</a>';
										}
										if(!empty($settings['show_offcanvas_btn'])){
											echo '<button type="button" class="sidemenu-bar sideMenuInfo pill">
												<span></span>
												<span></span>
												<span></span>
											</button>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}


	}
}