<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Slider Widget.
 *
 */
class Piller_Banner1 extends Widget_Base {

	public function get_name() {
		return 'pillerbanner1';
	}
	public function get_title() {
		return __( 'Banner Slider', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'banner_section',
			[
				'label' 	=> __( 'Banner Slider', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', ['Style One', 'Style Two'] ); 

		$repeater = new Repeater();

		piller_media_fields($repeater, 'bg', 'Choose Background');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'Journey To Your Perfect Luxury Home');
		piller_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Explore Property');
		piller_url_fields($repeater, 'button_url', 'Button URL');
		piller_media_fields($repeater, 'icon', 'Choose Icon');
		piller_general_fields($repeater, 'content', 'Content', 'TEXTAREA2', 'Trustipilot');

		piller_media_fields($repeater, 'rating_img', 'Choose Rating Image');
		piller_general_fields($repeater, 'rating_star', 'Rating Star', 'TEXTAREA', '<i class="fa-solid fa-star"></i>');
		piller_general_fields($repeater, 'rating_content', 'Rating Contect', 'TEXTAREA', '19k clients');
		
		$this->add_control(
			'banner_slides',
			[
				'label' 		=> __( 'Banners', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Journey To Your Perfect Luxury Home', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		piller_general_fields($this, 'circle_text', 'Video Circle Text', 'TEXT', 'PILLAR REAL ESTATE HOME * REAL ESTATE' , ['1'] );
		piller_url_fields($this, 'video_url', 'Video URL' , ['1'] );

		$repeater = new Repeater();

		piller_general_fields($repeater, 'circle_text', 'Video Circle Text', 'TEXT', 'PILLAR REAL ESTATE HOME * REAL ESTATE' );
		piller_url_fields($repeater, 'video_url', 'Video URL' );

		piller_media_fields($repeater, 'bg', 'Choose Background');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'Journey To Your Perfect Luxury Home');
		
		$this->add_control(
			'banner_slides2',
			[
				'label' 		=> __( 'Banners', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Journey To Your Perfect Luxury Home', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		piller_switcher_fields($this, 'show_search_form', 'Show Search Form?', ['2']);
		piller_switcher_fields($this, 'show_social_icon', 'Show Social Icon?', ['2']);
		piller_social_fields($this, 'social_icon_list', 'Social List', ['2']);
		piller_general_fields($this, 'scroll_id', 'Scroll ID', 'TEXT', 'about-sec', ['2']);
		piller_general_fields($this, 'scroll_text', 'Scroll Text', 'TEXT', 'Scroll' , ['2'] );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start 
		//---------------------------------------

		piller_common_style_fields( $this, '02', 'Title', '{{WRAPPER}} .hero-title', ['1', '2'] );
		//------Button Style-------
		piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th_btn', ['1'] );

    }
 
	protected function render() {

    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="th-hero-wrapper hero-1" id="hero">';
				echo '<div class="hero-img-shape-1">';
					echo '<div class="logo-icon-wrap">';
						if(!empty( $settings['video_url']['url'] )){
							echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="logo-icon popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
						}
						if(!empty($settings['circle_text'])){
							echo '<div class="logo-icon-wrap__text">';
								echo '<span class="logo-animation">'.esc_html($settings['circle_text']).'</span>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
		
				echo '<div class="swiper th-slider " id="heroSlider1" data-slider-options=\'{"effect":"fade", "loop":true, "autoHeight": "true"}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['banner_slides'] as $key => $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="hero-inner hero-style1" data-bg-src="'.esc_url( $data['bg']['url'] ).'">';
									echo '<div class="container">';
										echo '<div class="row gy-50 gx-40 align-items-center">';
											echo '<div class="col-xxl-7 col-xl-7 col-lg-8">';
												echo '<div class="hero-1-content pe-xl-4">';
													if(!empty($data['title'])){
														echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.2s">'.wp_kses_post($data['title']).'</h1>';
													}
													if(!empty($data['button_text'])){
														echo '<div class="btn-group justify-content-center" data-ani="slideinup" data-ani-delay="0.4s">';
															echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2 pill th_btn">'.esc_html( $data['button_text'] ).'</a>';
														echo '</div>';
													}
													echo '<div class="trust-content" data-ani="slideinup" data-ani-delay="0.6s">';
														if($data['icon']['url'] ){
															echo '<div class="icon">';
																echo piller_img_tag( array(
																	'url'   => esc_url( $data['icon']['url'] ),
																)); 
															echo '</div>';
														}
														if(!empty($data['content'])){
															echo '<h4 class="box-title">'.wp_kses_post($data['content']).'</h4>';
														}
													echo '</div>';

													echo '<div class="bottom" data-ani="slideinup" data-ani-delay="0.8s">';
														if($data['rating_img']['url'] ){
															echo '<div class="avatar">';
																echo piller_img_tag( array(
																	'url'   => esc_url( $data['rating_img']['url'] ),
																)); 
															echo '</div>';
														}
														echo '<div class="content">';
															if(!empty($data['rating_star'])){
																echo '<div class="th-social">';
																	echo wp_kses_post($data['rating_star']);
																echo '</div>';
															}
															if(!empty($data['rating_content'])){
																echo '<h4 class="review-title">'.wp_kses_post($data['rating_content']).'</h4>';
															}
														echo '</div>';
													echo '</div>';
												echo '</div>';
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';

					echo '<div class="slider-pagination"></div>';
		
					echo '<div class="slider-pagination-wrapper">';
						echo '<button data-slider-prev="#heroSlider1" class="slider-arrow default slider-prev style-2">'.esc_html__('prev', 'piller').'</button>';
						echo '<div class="slider-pagination2"></div>';
						echo '<div class="line"></div>';
						echo '<button data-slider-next="#heroSlider1" class="slider-arrow default style-2">'.esc_html__('Next', 'piller').'</button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="th-hero-wrapper hero-2" id="hero">';
				if(!empty($settings['scroll_id'])){
				echo '<div class="slider-2-scroll-down scroll-down">';
					echo '<a href="#'.esc_html($settings['scroll_id']).'" class="scroll-wrap">';
						echo '<span></span>';
					echo '</a>';
					if(!empty($settings['scroll_text'])){
						echo '<span class="scroll-text">'.esc_html($settings['scroll_text']).'</span>';
					}
				echo '</div>';
				}
				if(!empty($settings['show_social_icon'])){
				echo '<div class="hero-2-social">';
					echo '<div class="th-social">';
						foreach( $settings['social_icon_list'] as $social_icon ){
							$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
							$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
		
							echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';
		
							\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
		
							echo '</a> ';
						}
					echo '</div>';
				echo '</div>';
				}
				echo '<div class="th-container22">';
					echo '<div class="swiper th-slider" id="heroSlider1" data-slider-options=\'{"effect":"fade", "loop":true, "autoHeight": "true", "autoplay": { "delay": 3000 }}\' onmouseenter="heroSlider1.swiper.autoplay.stop()" onmouseleave="heroSlider1.swiper.autoplay.start()">';
						echo '<div class="swiper-wrapper">';
						foreach( $settings['banner_slides2'] as $key => $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="hero-inner hero-style2">';
									echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['bg']['url'] ).'"></div>';
									echo '<div class="row justify-content-center gy-50 gx-40 align-items-center">';
										echo '<div class="col-xxl-8 col-xl-8 col-lg-10">';
											echo '<div class="hero-2-content text-center">';
												echo '<div class="hero-img-shape-2" data-ani="slideinup" data-ani-delay="0.2s">';
													echo '<div class="logo-icon-wrap">';
														if(!empty( $data['video_url']['url'] )){
															echo '<a href="'.esc_url( $data['video_url']['url'] ).'" class="logo-icon popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
														}
														if(!empty($data['circle_text'])){
															echo '<div class="logo-icon-wrap__text">';
																echo '<span class="logo-animation">'.esc_html($data['circle_text']).'</span>';
															echo '</div>';
														}
													echo '</div>';
												echo '</div>';
												if(!empty($data['title'])){
													echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">'.wp_kses_post($data['title']).'</h1>';
												}
												if(!empty($settings['show_search_form'])){
													echo '<div class="hero-search-wrapper style2" data-ani="slideinup" data-ani-delay="0.6s">';
														echo '<div class="hero-search-group-wrapper">';
															echo do_shortcode( '[directorist_search_listing]' );
														echo '</div>';
													echo '</div>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
						echo '</div>';
						echo '<div class="slider-pagination"></div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}

		
	}

} 