<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class piller_Banner2 extends Widget_Base {

	public function get_name() {
		return 'pillerbanner2';
	}
	public function get_title() {
		return __( 'Banner / Hero', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'banner_section',
			[
				'label' 	=> __( 'Banner', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two' ] );

		// piller_media_fields( $this, 'bg', 'Choose Background', ['1'] );

		// piller_url_fields($this, 'bg_video_url', 'Background Video URL' , ['2'] );
		$this->add_control(
			'bg_video_url',
			[
				'label' => __( 'Background Video', 'piller' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'media_type' => 'video',
				'description' => __( 'Only MP4 format is supported for best compatibility.', 'piller' ),
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);
		$this->add_control(
			'bg_video_fallback',
			[
				'label' => __( 'Fallback Video Image', 'piller' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'media_type' => 'image',
				'description' => __( 'Displayed if the video fails to load.', 'piller' ),
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);

		piller_general_fields($this, 'circle_text', 'Video Circle Text', 'TEXT', 'PILLAR REAL ESTATE HOME * REAL ESTATE' , ['2'] );
		piller_url_fields($this, 'video_url', 'Video URL' , ['2'] );

		piller_general_fields( $this, 'subtitle', 'Subtitle', 'TEXTAREA', 'Welcome To Pillar', ['1'] );
		piller_general_fields( $this, 'title', 'Title', 'TEXTAREA', 'Find Your Perfect Home' );

		piller_switcher_fields($this, 'show_search_form', 'Show Search Form?', ['1', '2']);
        
		$repeater = new Repeater();

		piller_general_fields($repeater, 'number', 'Number', 'TEXTAREA2', '100');
		piller_general_fields($repeater, 'after_prefix', 'After Prefix', 'TEXT2', 'k');
		piller_general_fields($repeater, 'description', 'Content', 'TEXTAREA2', 'Completed Projects'); 

		$this->add_control(
			'counter_lists',
			[
				'label' 		=> __( 'Counter List', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'number' 	=> __( '100', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		piller_switcher_fields($this, 'show_social_icon', 'Show Social Icon?', ['2']);
		piller_social_fields($this, 'social_icon_list', 'Social List', ['2']);
		piller_general_fields($this, 'scroll_id', 'Scroll ID', 'TEXT', 'about-sec', ['2']);
		piller_general_fields($this, 'scroll_text', 'Scroll Text', 'TEXT', 'Scroll' , ['2'] );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '01', 'Subtitle', '{{WRAPPER}} .sub-title', ['1'] );
		piller_common_style_fields( $this, '02', 'Title', '{{WRAPPER}} .hero-title', ['1', '2'] );

		piller_common_style_fields($this, '011', 'Number', '{{WRAPPER}} .counter .counter-number', ['1'] );
		piller_common_style_fields($this, '022', 'Number Prefix', '{{WRAPPER}} .counter', ['1'] );
		piller_common_style_fields($this, '033', 'Content', '{{WRAPPER}} .box-text', ['1'] );

    }

	protected function render() {

    $settings = $this->get_settings_for_display();
 
		if( $settings['layout_style'] == '1' ){
			// home 3
			echo '<div class="hero-style3 hero-3">';
				echo '<div class="title-area text-left mb-50">';
					if(!empty($settings['subtitle'])){
						echo '<p class="sub-title fadeinup wow" data-wow-delay="0.2s"><span class="double-line"></span> '.wp_kses_post($settings['subtitle']).'</p>';
					}
					if(!empty($settings['title'])){
						echo '<h1 class="hero-title fadeinup wow" data-wow-delay="0.3s">'.wp_kses_post($settings['title']).'</h1>';
					}
				echo '</div>';
				if(!empty($settings['show_search_form'])){
					echo '<div class="hero-3-search-wrap hero-style-3">';
						echo do_shortcode( '[directorist_search_listing]' );
					echo '</div>';
				}
				echo '<div class="hero-3-counter-wrap counter-wrap-3 fadeinup wow" data-wow-delay="0.7s">';
					foreach( $settings['counter_lists'] as $data ){
						echo '<div class="hero-3-counter-item">';
							echo '<h2 class="counter">';
								echo '<span class="counter-number">'.esc_html( $data['number'] ).'</span> '.esc_html( $data['after_prefix'] ).'';
							echo '</h2>';
							if(!empty($data['description'])){
								echo '<span class="box-text">'.esc_html( $data['description'] ).'</span>';
							}
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';
           
		}elseif( $settings['layout_style'] == '2' ){
			// home 2
			$video_url = esc_url( $settings['bg_video_url']['url'] );
			$fallback_img = esc_url( $settings['bg_video_fallback']['url'] ?? '' );

		    echo '<div class="th-hero-wrapper hero-2 hero-3-wp" id="hero">';
				if(!empty($settings['scroll_id'])){
					echo '<div class="slider-2-scroll-down scroll-down">';
						echo '<a href="#'.esc_html($settings['scroll_id']).'" class="scroll-wrap">';
							echo '<span></span>';
						echo '</a>';
						if(!empty($settings['scroll_text'])){
							echo '<span class="scroll-text">'.esc_html($settings['scroll_text']).'</span>';
						}
					echo '</div>';
				}
				if(!empty($settings['show_social_icon'])){
					echo '<div class="hero-2-social">';
						echo '<div class="th-social">';
							foreach( $settings['social_icon_list'] as $social_icon ){
								$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
								$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
			
								echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';
			
								\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
			
								echo '</a> ';
							}
						echo '</div>';
					echo '</div>';
				}
				echo '<div class="th-container22">';
					echo '<div class="hero-inner hero-style2" data-bg-src="'.esc_url( $fallback_img ).'" data-mask-src="'.PILLER_ASSETS.'img/hero-2-bg-mask.png">';
						if(!empty($video_url)){
							echo '<video class="hero-video" id="video" src="' . $video_url . '" loop="" muted="" autoplay=""></video>';
						}
						echo '<div class="row justify-content-center gy-50 gx-40 align-items-center">';
							echo '<div class="col-xxl-8 col-xl-9 col-lg-11">';
								echo '<div class="hero-2-content text-center">';
									echo '<div class="hero-img-shape-2 " >';
										echo '<div class="logo-icon-wrap">';
											if(!empty( $settings['video_url']['url'] )){
												echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="logo-icon popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
											}
											if(!empty($settings['circle_text'])){
												echo '<div class="logo-icon-wrap__text">';
													echo '<span class="logo-animation">'.esc_html($settings['circle_text']).'</span>';
												echo '</div>';
											}
										echo '</div>';
									echo '</div>';
									if(!empty($settings['title'])){
										echo '<h1 class="hero-title fadeinup wow" data-wow-duration="1.5s" data-wow-delay="0.3s">'.wp_kses_post($settings['title']).'</h1>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';

				if(!empty($settings['show_search_form'])){
					echo '<div class="hero-search-wrapper hero-style-3">';
						echo '<div class="hero-search-group-wrapper">';
							echo do_shortcode( '[directorist_search_listing]' );
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}

		
	}

}