<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Piller_Blog_Page extends Widget_Base {

	public function get_name() {
		return 'pillerblogpage'; 
	}
	public function get_title() {
		return __( 'Blog Post with Pagination', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' => __( 'Blog Post', 'piller' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style Grid' ] );

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'piller' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => count( get_posts( array('post_type' => 'post', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default'  	=> __( '3', 'piller' )
			]
        );

        piller_general_fields( $this, 'title_count', 'Title Length', 'TEXT2', '6' );
        piller_general_fields( $this, 'excerpt_count', 'Excerpt Length', 'TEXT2', '14' );

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'piller' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','piller'),
                    'DESC'   	=> __('DESC','piller'),
                ],
                'default'  	=> 'DESC'
			]
        );
        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'piller' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'piller' ),
                    'author'    => __( 'Author', 'piller' ),
                    'title'    	=> __( 'Title', 'piller' ),
                    'date'    	=> __( 'Date', 'piller' ),
                    'rand'    	=> __( 'Random', 'piller' ),
                ],
                'default'  	=> 'date'
			]
        );
        $this->add_control(
            'blog_post_cats',
            [
                'label'    => __( 'Select Categories (Show Category Posts)', 'piller' ),
                'type'     => Controls_Manager::SELECT2,
                'multiple' => true,
                'options'  => $this->piller_get_categories(),
                'default'  => [], // Default to no categories selected
                'label_block' => true,
            ]
        );

        piller_switcher_fields( $this, 'show_post_meta_icons', 'Display Post Meta Icons?' );
        piller_switcher_fields( $this, 'show_author', 'Display Post Author?' );
        piller_switcher_fields( $this, 'show_date', 'Display Post Date?' );
        piller_switcher_fields( $this, 'show_category', 'Display Post Category?' );
        piller_switcher_fields( $this, 'show_comment', 'Display Post Comment?' );
        piller_switcher_fields( $this, 'show_min_read', 'Display Read Minute?' );

        piller_general_fields( $this, 'button_text', 'Read More Text', 'TEXTAREA2', 'Read More' );

        piller_general_fields( $this, 'post_col', 'Bootstrap Column Class(col-md-6 col-lg-4 col-xl-3)', 'TEXTAREA2', '', ['1'] );

        $this->add_responsive_control(
			'section_align',
			[
				'label' 		=> __( 'Pagination Alignment', 'piller' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'piller' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'piller' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'piller' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> '',
				'toggle' 	=> true,
			]
		);
        
        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//--------------------------------------- 

		//-------Title Style-------
		piller_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a' );
		piller_common_style_fields( $this, '02', 'Content', '{{WRAPPER}} .box-text', ['1', '2', '4'] );

         //-------Meta Style-------
		 $this->start_controls_section(
			'meta_styling',
			[
				'label'     => __( 'Meta Styling', 'piller' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		piller_color_fields( $this, '002', 'Meta Icon Color', 'color', '{{WRAPPER}} .blog-meta a i' );
		piller_color_fields( $this, '003', 'Meta Color', 'color', '{{WRAPPER}} .blog-meta a' );
		piller_color_fields( $this, '004', 'Meta Hover Color', 'color', '{{WRAPPER}} .blog-meta a:hover' );        

		$this->end_controls_section();

		//------Button Style-------
		piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn', ['1'] );

    }

    public function piller_get_categories() {
        $cats = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));
        $cat = [];
        foreach( $cats as $singlecat ) {
            $cat[$singlecat->slug] = __($singlecat->name, 'piller');
        }
        return $cat;
    }    
   

	protected function render() {

        $settings = $this->get_settings_for_display();

        if (isset($settings['section_align'])) {
            if ($settings['section_align'] == 'left') {
                $wrap_align_class = 'text-left';
            } elseif ($settings['section_align'] == 'center') {
                $wrap_align_class = 'text-center';
            } elseif ($settings['section_align'] == 'right') {
                $wrap_align_class = 'text-end';
            } else {
                $wrap_align_class = '';
            }
        } else {
            // Default value if 'section_align' is not set
            $wrap_align_class = 'text-left';
        }

		if( $settings['layout_style'] == '1' || $settings['layout_style'] == '2' ){
            echo '<div class="row gy-30">';
                $blog_post_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $blog_post_query_args = array(
                    'post_type' => 'post',
                    'post_status' => 'publish',
                    'ignore_sticky_posts' => true,
                    'order'   => $settings['blog_post_order'],
                    'orderby' => $settings['blog_post_order_by'],
                    'posts_per_page' => $settings['blog_post_count'],
                    'paged'          => $blog_post_query_paged,
                );
                
                // Check if categories are selected in Elementor settings
                if ( !empty( $settings['blog_post_cats'] ) ) {
                    $blog_post_query_args['tax_query'] = array(
                        array(
                            'taxonomy' => 'category',
                            'field'    => 'slug',
                            'terms'    => $settings['blog_post_cats'], 
                            'operator' => 'IN',
                        )
                    );
                }

                // Run the query with the arguments
                $blog_post_query = new WP_Query( $blog_post_query_args );
                
                if($settings['layout_style'] == '2'){
                    $col = 'col-lg-12';
                    $item_class = 'th-blog blog-list-single has-post-thumbnail';
                }else{
                    $col = ($settings['post_col']) ? $settings['post_col'] : 'col-lg-4 col-md-6';
                    $item_class = 'blog-card';
                }

                while ($blog_post_query->have_posts()) {
                    $blog_post_query->the_post();
                    $categories = get_the_category(); 

                    echo '<div class="'.esc_attr($col).' wow fadeinup">'; 
                        echo '<div class="'.esc_attr($item_class).'">';
                            echo '<div class="blog-img">';
                                echo '<a href="'.esc_url( get_permalink() ).'">';
                                    the_post_thumbnail();  
                                echo '</a>';
                                if( !empty($settings['show_date']) ) {
                                    echo '<div class="date">';
                                        echo '<a href="' . esc_url( piller_blog_date_permalink() ) . '">' . get_the_date( 'd M' ) . '</a>';
                                    echo '</div>';
                                }                                
                            echo '</div>';
                            echo '<div class="blog-content">';
                                echo '<div class="blog-meta">';
                                    if(!empty($settings['show_author'])){
                                        echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'">';
                                            if(!empty($settings['show_post_meta_icons'])){
                                                echo '<i class="fa-solid fa-user"></i>';
                                            }
                                            echo esc_html__('By ', 'piller') . esc_html( ucwords( get_the_author() ) );
                                        echo '</a>';
                                    }
                                    if(!empty($settings['show_category'])){
                                        if(!empty($categories)){
                                            echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'">';
                                                if(!empty($settings['show_post_meta_icons'])){
                                                    echo '<i class="fa-solid fa-tag"></i>';
                                                }
                                                echo esc_html( $categories[0]->name );
                                            echo '</a>';
                                        }
                                    }
                                    if(!empty($settings['show_comment'])){
                                        $commnet = (get_comments_number() == 1) ? ' Comment ':' Comments ';
                                        echo '<a href="#">';
                                            if(!empty($settings['show_post_meta_icons'])){
                                                echo '<i class="fa-solid fa-comments"></i>';
                                            }
                                            echo get_comments_number() . esc_html__($commnet, 'piller');
                                        echo '</a>';
                                    }
                                    if(!empty($settings['show_min_read'])){
                                        if (function_exists('piller_get_reading_time')) {
                                            echo '<a href="#">';
                                                if(!empty($settings['show_post_meta_icons'])){
                                                    echo '<i class="fa-solid fa-clock"></i>';
                                                }
                                                echo piller_get_reading_time(get_the_ID());
                                            echo '</a>';
                                        }                                        
                                    }
                                echo '</div>';
                                echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';

                                $content = wp_trim_words( get_the_content(), $settings['excerpt_count'], '' );
                                if ( !empty( $content ) ) {
                                    echo '<p class="box-text mb-3">'. esc_html( $content ) .'</p>';
                                }
                                if(!empty($settings['button_text'])){
                                    echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn pill style3">'.wp_kses_post($settings['button_text']).'</a>';
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';

                }
                echo '<div class="'.esc_attr($wrap_align_class).'">';
                        piller_custom_query_pagination($blog_post_query_paged, $blog_post_query->max_num_pages);
                echo '</div>';

                wp_reset_postdata(); 

            echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
          

        }
	
      
	}
}