<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Choose Us Widget .
 *
 */
class piller_Choose_Us extends Widget_Base {

	public function get_name() {
		return 'pillerchooseus';
	}
	public function get_title() {
		return __( 'Choose Us', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Choose Us', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four' ] );

		piller_media_fields($this, 'choose_hover_icon', 'Choose Hover Image' , ['1', '2']);
		piller_media_fields($this, 'choose_shape', 'Choose Shape' , ['3']);

		$repeater = new Repeater();

		piller_media_fields($repeater, 'choose_icon', 'Choose Icon');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Find your home');
		piller_general_fields($repeater, 'description', 'Description', 'TEXTAREA', 'Tantillus certe patrocinor video adipisci valeo carus. Subseco vestrum taedium.'); 
		piller_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Find a Home');
		piller_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'feature_list',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Find your home', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2', '3', '4']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		piller_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a' );
		piller_common_style_fields( $this, '02', 'Description', '{{WRAPPER}} .box-text' );
		//------Button Style-------
		piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn', ['1', '2', '3', '4'] );


	}


	protected function render() {

        $settings = $this->get_settings_for_display();

			if( $settings['layout_style'] == '1' ){
				echo '<div class="row gy-30 align-items-center justify-content-center">';
					$delay = 0.2;
					$animations = ['fadeinleft', 'fadeinup', 'fadeinright'];

					foreach( $settings['feature_list'] as $key => $data ){
						$animation_class = $animations[$key % count($animations)];
						$current_delay = number_format($delay * ($key + 1), 1);

						echo '<div class="col-xl-4 col-lg-6 col-md-6 wow ' . esc_attr($animation_class) . '" data-wow-delay="' . esc_attr($current_delay) . 's">';
							echo '<div class="why-card-1">';
								if(!empty($settings['choose_hover_icon']['url'])){
									echo '<div class="hover-icon">';
										echo piller_img_tag( array(
											'url'   => esc_url( $settings['choose_hover_icon']['url'] ),
										));
									echo '</div>';
								}
								if(!empty($data['choose_icon']['url'])){
									echo '<div class="why-card-1__icon">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['choose_icon']['url'] ),
										));
									echo '</div>';
								}
								echo '<div class="why-card-1__content">';
									if(!empty($data['title'])){
										echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
									}
									if(!empty($data['description'])){
										echo '<p class="box-text">'.esc_html($data['description']).'</p>';
									}
								echo '</div>';
								echo '<div class="why-card-1__bottom">';
									if(!empty($data['button_text'])){
										echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style3 pill">'.esc_attr($data['button_text']).'</a>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';

				
			}elseif( $settings['layout_style'] == '2' ){
				echo '<div class="row gy-30 align-items-center justify-content-center">';
					$delay = 0.2;
					$animations = ['fadeinleft', 'fadeinup', 'fadeinright'];
					foreach( $settings['feature_list'] as $key => $data ){
						$animation_class = $animations[$key % count($animations)];
						$current_delay = number_format($delay * ($key + 1), 1);

						echo '<div class="col-xl-4 col-lg-6 col-md-6 wow '.esc_attr($animation_class).'" data-wow-delay="'.esc_attr($current_delay).'s">';
							echo '<div class="why-card-1 style-2">';
								if(!empty($settings['choose_hover_icon']['url'])){
									echo '<div class="hover-icon">';
										echo piller_img_tag( array(
											'url'   => esc_url( $settings['choose_hover_icon']['url'] ),
										));
									echo '</div>';
								}
								$number = str_pad( $key + 1, 2, '0', STR_PAD_LEFT );
								echo '<h4 class="count">'. esc_html($number) .'</h4>';
								if(!empty($data['choose_icon']['url'])){
									echo '<div class="why-card-1__icon">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['choose_icon']['url'] ),
										));
									echo '</div>';
								}
								echo '<div class="why-card-1__content">';
									if(!empty($data['title'])){
										echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
									}
									if(!empty($data['description'])){
										echo '<p class="box-text">'.esc_html($data['description']).'</p>';
									}
								echo '</div>';
								echo '<div class="why-card-1__bottom">';
									if(!empty($data['button_text'])){
										echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style3 pill w-100">'.esc_attr($data['button_text']).'</a>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
                echo '</div>';

			}elseif( $settings['layout_style'] == '3' ){
				echo '<div class="slider-area">';
					echo '<div class="swiper th-slider has-shadow" id="blogSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"4"}}, "autoHeight": "true"}\'>';
						echo '<div class="swiper-wrapper">';
						foreach( $settings['feature_list'] as $key => $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="why-card-1 style-2 style-3" data-bg-src="'.esc_url( $settings['choose_shape']['url'] ).'">';
									$number = str_pad( $key + 1, 2, '0', STR_PAD_LEFT );
									echo '<h4 class="count">'. esc_html($number) .'</h4>';
									if(!empty($data['choose_icon']['url'])){
										echo '<div class="why-card-1__icon">';
											echo piller_img_tag( array(
												'url'   => esc_url( $data['choose_icon']['url'] ),
											));
										echo '</div>';
									}
									echo '<div class="why-card-1__content">';
										if(!empty($data['title'])){
											echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
										}
										if(!empty($data['description'])){
											echo '<p class="box-text">'.esc_html($data['description']).'</p>';
										}
									echo '</div>';
									echo '<div class="why-card-1__bottom">';
										if(!empty($data['button_text'])){
											echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style3 radius">'.esc_attr($data['button_text']).'</a>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
						echo '</div>';
						echo '<div class="slider-pagination style-2 mt-5"></div>';
					echo '</div>';
				echo '</div>';

			}elseif( $settings['layout_style'] == '4' ){
				echo '<div class="row gy-30 justify-content-center">';
					foreach( $settings['feature_list'] as $key => $data ){
						$delay = number_format(0.1 + ($key * 0.2), 1);

						echo '<div class="col-xl-3 col-lg-4 col-md-6 wow fadeinup"  data-wow-delay="'.esc_attr($delay).'s">';
							echo '<div class="why-card-1 style-2 style-4">';
								$number = str_pad( $key + 1, 2, '0', STR_PAD_LEFT );
								echo '<h4 class="count">'. esc_html($number) .'</h4>';
								if(!empty($data['choose_icon']['url'])){
									echo '<div class="why-card-1__icon">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['choose_icon']['url'] ),
										));
									echo '</div>';
								}
								echo '<div class="why-card-1__content">';
									if(!empty($data['title'])){
										echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
									}
									if(!empty($data['description'])){
										echo '<p class="box-text">'.esc_html($data['description']).'</p>';
									}
								echo '</div>';
								echo '<div class="why-card-1__bottom">';
									if(!empty($data['button_text'])){
										echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style3 radius">'.esc_attr($data['button_text']).'</a>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
                echo '</div>';

			}


	}

}