<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Form Widget .
 *
 */
class piller_Contact_Form extends Widget_Base {

	public function get_name() {
		return 'pillercontactform';
	}
	public function get_title() {
		return __( 'Contact Form', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'piller' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'piller' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'contact_form_section',
			[
				'label' 	=> __( 'Contact Form', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] ); 

		piller_media_fields( $this, 'bg', 'Choose Background', ['1'] );
		piller_media_fields( $this, 'image1', 'Choose Image', ['2'] );
		piller_general_fields( $this, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Have Any Questions?', ['1'] );
		piller_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Get in Touch with Us', ['1', '2', '3'] );

		$this->add_control(
            'piller_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'piller' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );

		piller_media_fields( $this, 'image', 'Choose Image', ['1'] );
		piller_media_fields( $this, 'arrow', 'Choose Arrow', ['1'] );

		piller_general_fields( $this, 'text', 'Text', 'TEXTAREA2', 'Find Fast Our Latest Properties', ['1' ] );
		piller_url_fields( $this, 'img_url', 'Image URL', ['1'] );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '01', 'Subtitle', '{{WRAPPER}} .sub-title', ['1'] );
		piller_common_style_fields( $this, '02', 'Title', '{{WRAPPER}} .title', ['1', '2', '3'] );
		piller_common_style_fields( $this, '03', 'Text', '{{WRAPPER}} .box-title', ['1'] );

	}

	protected function render() {

	    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="download-3-bg-inner" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
				echo '<div class="container">';
					echo '<div class="row gy-4 align-items-center">';
						echo '<div class="col-lg-5 col-xl-5 col-xxl-6">';
							echo '<div class="download-3-left">';
								echo '<div class="map-icon-box">';
									echo '<a href="'.esc_url( $settings['img_url']['url'] ).'">';
										echo piller_img_tag( array(
											'url'   => esc_url( $settings['image']['url'] ),
										));
									echo '</a>';
								echo '</div>';
								echo '<div class="content-box">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['arrow']['url'] ),
									));
									if($settings['text']){
										echo '<h4 class="box-title">'.esc_html($settings['text']).'</h4>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
						echo '<div class="col-lg-7 col-xl-7 col-xxl-6">';
							echo '<div class="download-get-in-touch">';
								echo '<div class="ajax-contact">';
									echo '<div class="title-area text-left mb-70">';
										if($settings['subtitle']){
											echo '<span class="sub-title text-anime-style-2"><span class="double-line"></span>'.esc_html($settings['subtitle']).'</span>';
										}
										if($settings['title']){
											echo '<h2 class="sec-title title text-anime-style-3">'.esc_html($settings['title']).'</h2>';
										}
									echo '</div>';
									if( !empty($settings['piller_select_contact_form']) ){
										echo do_shortcode( '[contact-form-7  id="'.$settings['piller_select_contact_form'].'"]' ); 
									}else{
										echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'piller' ). '</p></div>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="contact-all-wrapper">';
				echo '<div class="contact-form-wrap">';
					echo '<div class="contact-form ajax-contact">';
						if($settings['title']){
							echo '<h3 class="form-title title text-anime-style-2">'.esc_html($settings['title']).'</h3>';
						}
						if( !empty($settings['piller_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$settings['piller_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'piller' ). '</p></div>';
						}
					echo '</div>';
				echo '</div>';
				if(!empty($settings['image1']['url'])){
					echo '<div class="contact-form-thumb overflow-hidden">';
						echo piller_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
					echo '</div>';
				}
			echo '</div>';
			
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="widget bg-smoke">';
				if($settings['title']){
					echo '<h3 class="widget_title title">'.esc_html($settings['title']).'</h3>';
				}
				echo '<div class="contact-form-widget">';
					echo '<div class="newsletter-form">';
						if( !empty($settings['piller_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$settings['piller_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'piller' ). '</p></div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}
		

	}

}