<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Counter Up Widget .
 *
 */
class piller_Counterup extends Widget_Base {

	public function get_name() {
		return 'pillercounterup';
	}
	public function get_title() {
		return __( 'Counter Up', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Counter Up', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two' ] ); 

		$repeater = new Repeater();

		piller_media_fields($repeater, 'choose_icon', 'Choose Icon');
		piller_general_fields($repeater, 'number', 'Number', 'TEXTAREA2', '100');
		piller_general_fields($repeater, 'after_prefix', 'After Prefix', 'TEXT2', 'k');
		piller_general_fields($repeater, 'description', 'Content', 'TEXTAREA2', 'Completed Projects'); 

		$this->add_control(
			'counter_lists',
			[
				'label' 		=> __( 'Counter List', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'number' 	=> __( '100', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
		);


		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields($this, '01', 'Number', '{{WRAPPER}} .num .counter-number' );
		piller_common_style_fields($this, '02', 'Number Prefix', '{{WRAPPER}} .num');
		piller_common_style_fields($this, '03', 'Content', '{{WRAPPER}} .desc', ['1', '2']);

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo ' <div class="property-values-1-counter-wrapper">'; 
				$delay = 0.2;
				$animations = ['fadeinleft', 'fadeinright'];
				foreach( $settings['counter_lists'] as $key => $data ){
					$animation_class = $animations[$key % count($animations)];
					$current_delay = number_format($delay * ($key + 1), 1);

					echo '<div class="property-values-1-counter wow ' . esc_attr($animation_class) . '" data-wow-delay="' . esc_attr($current_delay) . 's">';
						if(!empty($data['choose_icon']['url'])){
							echo '<div class="icon">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['choose_icon']['url'] ),
								));
							echo '</div>';
						}
						echo '<h2 class="counter num"><span class="counter-number">'.esc_html( $data['number'] ).'</span> '.esc_html( $data['after_prefix'] ).'</h2>';
						if(!empty($data['description'])){
							echo '<span class="desc">'.esc_html( $data['description'] ).'</span>';
						}
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo ' <div class="counter-card-wrap">';
				foreach( $settings['counter_lists'] as $data ){
					echo '<div class="counter-card fadeinup wow">';
						if(!empty($data['choose_icon']['url'])){
							echo '<div class="box-icon">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['choose_icon']['url'] ),
								));
							echo '</div>';
						}
						echo '<div class="media-body">';
							echo '<h2 class="box-number num"><span class="counter-number">'.esc_html( $data['number'] ).'</span>'.esc_html( $data['after_prefix'] ).'</h2>';
							if(!empty($data['description'])){
								echo '<span class="box-text desc">'.esc_html( $data['description'] ).'</span>';
							}
						echo '</div>';
					echo '</div>';
					echo '<div class="divider"></div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
		

		}

	
	}

}