<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Destination Widget .
 *
 */
class Piller_Destination extends Widget_Base {

	public function get_name() {
		return 'pillerdestination';
	}
	public function get_title() {
		return __( 'Destination', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'destination', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four' ] );

		$this->add_control(
			'th_show_load_more',
			[
				'label' 		=> __( 'Show Load More Option?', 'piller' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'piller' ),
				'label_off' 	=> __( 'Hide', 'piller' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> [
					'layout_style' => ['4'], 
				]
			]
		);
		$this->add_control(
			'th_loop_item_show',
			[
				'label' 	=> __( 'No of Loop Item show', 'piller' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => 16,
                'default'  	=> __( '8', 'piller' ),
				'condition'	=> [
					'layout_style' => ['4'],
					'th_show_load_more' => [ 'yes' ],
				]
			]
        );
		$this->add_control(
			'th_loop_item_count',
			[
				'label' 	=> __( 'No of Loop Item show by click', 'piller' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => 16,
                'default'  	=> __( '4', 'piller' ),
				'condition'	=> [
					'layout_style' => ['4'],
					'th_show_load_more' => [ 'yes' ],
				]
			]
        );
		$this->add_control(
			'th_load_more_button_text',
			[
				'label' 		=> __( 'Load More Button Text', 'piller' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 	=> __( 'Load More', 'piller' ),
				'condition'	=> [
					'layout_style' => ['4'],
					'th_show_load_more' => [ 'yes' ],
				]
			]
		);

		$this->add_responsive_control(
			'section_align',
			[
				'label' 		=> __( 'Alignment', 'piller' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'start' 	=> [
						'title' 		=> __( 'Left', 'piller' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'piller' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'end' 	=> [
						'title' 		=> __( 'Right', 'piller' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'center',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .load-more-wrap' => 'justify-content: {{VALUE}};',
                ],
				'condition'	=> [
					'layout_style' => ['4'],
					'th_show_load_more' => [ 'yes' ],
				]
			]
		);

		$repeater = new Repeater();

		piller_media_fields( $repeater, 'choose_img', 'Choose Image' );
		piller_general_fields( $repeater, 'subtitle', 'subtitle', 'TEXTAREA2', 'Subtitle' ); 
		piller_general_fields( $repeater, 'title', 'Title', 'TEXTAREA2', 'London, United Kngdom' );

		piller_url_fields( $repeater, 'button_url', 'Button URL' );

		$this->add_control(
			'feature_list',
			[
				'label' 		=> __( 'destination Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'London, United Kngdom', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2', '3', '4']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '01', 'Subtitle', '{{WRAPPER}} .box-text', ['1', '2', '3', '4'] );
		piller_common2_style_fields( $this, '02', 'Title', '{{WRAPPER}} .box-title a', ['1', '2', '3', '4'] );


	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){ 
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow gallery-1" id="gallerySlider1" data-slider-options=\'{"autoplay":true,"centeredSlides":true,"loop":true,"breakpoints":{"0":{"slidesPerView":1,"spaceBetween":20},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"2.4"},"1400":{"slidesPerView":"3.5"},"1500":{"slidesPerView":"4.5"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['feature_list'] as $key => $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="gallery-card">';
									echo '<div class="gallery-img">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['choose_img']['url'] ),
										));
										echo '<div class="gallery-content">';
											echo '<div class="gallery-content-wrapper">';
												if(!empty($data['subtitle'])){
													echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
												}
												if(!empty($data['title'])){
													echo '<h2 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h2>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<button data-slider-prev="#gallerySlider1" class="slider-arrow slider-prev style2"><i class="far fa-arrow-left"></i></button>';
					echo '<button data-slider-next="#gallerySlider1" class="slider-arrow slider-next style2"><i class="far fa-arrow-right"></i></button>';
					echo '<div class="slider-pagination-wrapper gallery-1-pagi">';
						echo '<div class="slider-pagination2"></div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="gallery-2-slider-wrap">';
				echo '<div class="slider-area">';
					echo '<div class="swiper th-slider has-shadow gallery-1" id="gallerySlider1" data-slider-options=\'{"centeredSlides":false,"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"4"}}}\'>';
						echo '<div class="swiper-wrapper">';
							foreach( $settings['feature_list'] as $key => $data ){
								echo '<div class="swiper-slide">'; 
									echo '<div class="gallery-card style-2">';
										echo '<div class="gallery-img">';
											echo piller_img_tag( array(
												'url'   => esc_url( $data['choose_img']['url'] ),
											));
											echo '<div class="gallery-content">';
												echo '<div class="gallery-content-wrapper">';
													echo '<div class="left-content">';
														if(!empty($data['subtitle'])){
															echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
														}
														if(!empty($data['title'])){
															echo '<h2 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h2>';
														}
													echo '</div>';
													echo '<div class="link">';
														echo '<a href="'.esc_url( $data['button_url']['url'] ).'"><i class="far fa-arrow-right"></i> </a>';
													echo '</div>';
												echo '</div>';
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';	
							}
						echo '</div>';
						echo '<button data-slider-prev="#gallerySlider1" class="slider-arrow slider-prev style2"><i class="far fa-arrow-left"></i></button>';
						echo '<button data-slider-next="#gallerySlider1" class="slider-arrow slider-next style2"><i class="far fa-arrow-right"></i></button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-4 justify-content-center align-items-center">';
				foreach( $settings['feature_list'] as $key => $data ){
					if($key == 0){
						echo '<div class="col-lg-6 ">';
							echo '<div class="gallery-card style-2 fadeinleft wow" data-wow-delay="0.3s">';
								echo '<div class="gallery-img">';
									echo piller_img_tag( array(
										'url'   => esc_url( $data['choose_img']['url'] ),
									));
									echo '<div class="gallery-content">';
										echo '<div class="gallery-content-wrapper">';
											echo '<div class="left-content">';
												if(!empty($data['subtitle'])){
													echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
												}
												if(!empty($data['title'])){
													echo '<h2 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h2>';
												}
											echo '</div>';
											echo '<div class="link">';
												echo '<a href="'.esc_url( $data['button_url']['url'] ).'"><i class="far fa-arrow-right"></i> </a>';
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
				}
                echo '<div class="col-lg-6 ">';
                    echo '<div class="property-values-2-item ">';
						foreach( $settings['feature_list'] as $key => $data ){
							if($key == 1){
								echo '<div class="col-lg-12">';
									echo '<div class="gallery-card style-2 fadeinup wow" data-wow-delay="0.5s">';
										echo '<div class="gallery-img">';
											echo piller_img_tag( array(
												'url'   => esc_url( $data['choose_img']['url'] ),
											));
											echo '<div class="gallery-content">';
												echo '<div class="gallery-content-wrapper">';
													echo '<div class="left-content">';
														if(!empty($data['subtitle'])){
															echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
														}
														if(!empty($data['title'])){
															echo '<h2 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h2>';
														}
													echo '</div>';
													echo '<div class="link">';
														echo '<a href="'.esc_url( $data['button_url']['url'] ).'"><i class="far fa-arrow-right"></i> </a>';
													echo '</div>';
												echo '</div>';
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							}
						}
                        echo '<div class="row gy-4">'; 
							foreach( $settings['feature_list'] as $key => $data ){
								if($key == 2 || $key == 3){ 
									if($key == 2){
										$ani = 'fadeinleft';
									}else{
										$ani = 'fadeinright';
									}
									echo '<div class="col-lg-6 ">';
										echo '<div class="gallery-card style-2 wow '.esc_attr($ani).'" data-wow-delay="0.7s">';
											echo '<div class="gallery-img">';
												echo piller_img_tag( array(
													'url'   => esc_url( $data['choose_img']['url'] ),
												));
												echo '<div class="gallery-content">';
													echo '<div class="gallery-content-wrapper">';
														echo '<div class="left-content">';
															if(!empty($data['subtitle'])){
																echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
															}
															if(!empty($data['title'])){
																echo '<h2 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h2>';
															}
														echo '</div>';
														echo '<div class="link">';
															echo '<a href="'.esc_url( $data['button_url']['url'] ).'"><i class="far fa-arrow-right"></i> </a>';
														echo '</div>';
													echo '</div>';
												echo '</div>';
											echo '</div>';
										echo '</div>';
									echo '</div>';
								}
							}
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
				foreach( $settings['feature_list'] as $key => $data ){
					if($key > 3){
						echo '<div class="col-lg-4">';
							echo '<div class="gallery-card style-2 fadeinup wow">';
								echo '<div class="gallery-img">';
									echo piller_img_tag( array(
										'url'   => esc_url( $data['choose_img']['url'] ),
									));
									echo '<div class="gallery-content">';
										echo '<div class="gallery-content-wrapper">';
											echo '<div class="left-content">';
												if(!empty($data['subtitle'])){
													echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
												}
												if(!empty($data['title'])){
													echo '<h2 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h2>';
												}
											echo '</div>';
											echo '<div class="link">';
												echo '<a href="'.esc_url( $data['button_url']['url'] ).'"><i class="far fa-arrow-right"></i> </a>';
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
				}
            echo '</div>';
 
		}elseif( $settings['layout_style'] == '4' ){
			if(!empty($settings['th_show_load_more'])){
				$destination_item_count = $settings['th_loop_item_show'] ?? '6';
				$destination_loop_item_count = $settings['th_loop_item_count'] ?? '3';
				$th_load_more_button_text = !empty($settings['th_load_more_button_text']) ? $settings['th_load_more_button_text'] : 'Load More';
			}

			echo '<div class="row gy-4 justify-content-center">';
				$x=0;
				foreach( $settings['feature_list'] as $key => $data ){
					$x++;
					echo '<div class="col-xl-3 col-lg-4 col-md-6 th-destination-loop fadeinup wow">';
						echo '<div class="gallery-card style-2 style-3">';
							echo '<div class="gallery-img">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['choose_img']['url'] ),
								));
								echo '<div class="gallery-content">';
									echo '<div class="gallery-content-wrapper">';
										echo '<div class="left-content">';
											if(!empty($data['subtitle'])){
												echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
											}
											if(!empty($data['title'])){
												echo '<h2 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h2>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';	
				}
				if(!empty($settings['th_show_load_more'])){
					if($x > $destination_item_count){
						echo '<div class="mt-5 pt-3 d-flex load-more-wrap">';
							echo '<button id="load-more-destination-btn" class="th-btn pill">'.esc_html($th_load_more_button_text).'</button>';
						echo '</div>';
					}
				}
			echo '</div>';
			?>
<script>
	jQuery(document).ready(function($) {
		// Set the number of items to show initially and load on each click
		var itemsToShow = <?php echo $destination_item_count; ?>;
		var itemsPerLoad = <?php echo $destination_loop_item_count; ?>; 
		var currentIndex = itemsToShow;
	
		// Hide items beyond the initial count
		$('.th-destination-loop').slice(itemsToShow).hide();      
	
		// Attach a click event to the "Load More" button
		$('#load-more-destination-btn').on('click', function() {
			// Show the next batch of items
			$('.th-destination-loop').slice(currentIndex, currentIndex + itemsPerLoad).fadeIn();
			
			// Update the current index
			currentIndex += itemsPerLoad;
	
			// Hide the "Load More" button if all items are displayed
			if (currentIndex >= $('.th-destination-loop').length) {
				$('#load-more-destination-btn').hide();
			}
		});
	});
</script>
		<?php

		}elseif( $settings['layout_style'] == '5' ){

		}
		
			
	}
}