<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * features Widget .
 *
 */
class Piller_Features extends Widget_Base {

	public function get_name() {
		return 'pillerfeatures';
	}
	public function get_title() {
		return __( 'Features', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Features', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two' ] );

		$repeater = new Repeater();

		piller_media_fields($repeater, 'choose_icon', 'Choose Icon');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Initial Consultation');
		piller_general_fields($repeater, 'description', 'Description', 'TEXTAREA', '');

		$this->add_control(
			'feature_list',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Initial Consultation', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$repeater = new Repeater();

		piller_media_fields($repeater, 'choose_image', 'Choose Image');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Initial Consultation');
		piller_general_fields($repeater, 'description', 'Description', 'TEXTAREA', '');
		piller_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Learn More');
		piller_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'feature_list2',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Initial Consultation', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		piller_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a', ['2'] );
		piller_common_style_fields( $this, '011', 'Title', '{{WRAPPER}} .box-title', ['1'] );
		piller_common_style_fields( $this, '02', 'Description', '{{WRAPPER}} .box-text', [ '1', '2'] );
		//------Button Style-------
		piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn', ['1'] );

	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){
			echo '<div class="row gy-40 gx-60 mb-4">';
				$x = 0;
				$base_delay = 0.1;
				foreach( $settings['feature_list'] as $key => $data ){
					$x++;
					$wow_delay = number_format($base_delay * $x * 2 - $base_delay, 1);

					echo '<div class="col-lg-6 col-md-6 fadeinup wow" data-wow-delay="'.esc_attr($wow_delay).'s">';
						echo '<div class="about-1-item">';
							if(!empty($data['choose_icon']['url'])){
								echo '<div class="icon">';
									echo piller_img_tag( array(
										'url'   => esc_url( $data['choose_icon']['url'] ),
									));
								echo '</div>';
							}
							echo '<div class="content">';
								if(!empty($data['title'])){
									echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
								}
								if(!empty($data['description'])){
									echo '<p class="box-text">'.esc_html($data['description']).'</p>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="row gy-4 justify-content-center align-items-center">';
				foreach( $settings['feature_list2'] as $key => $data ){ 
					if($key == 0){
                	echo '<div class="col-lg-4 col-md-12">';
						echo '<div class="property-values-2-item fadeinleft wow" data-wow-delay="0.2s">';
							echo ' <div class="thumb">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['choose_image']['url'] ),
								));
								echo '<div class="plus-icon"><i class="fa-solid fa-plus"></i></div>';
								echo '<div class="hover-content">';
									if(!empty($data['title'])){
										echo '<h4 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
									}
									if(!empty($data['description'])){
										echo '<p class="box-text">'.esc_html($data['description']).'</p>';
									}
									if(!empty($data['button_text'])){
										echo '<a class="th-btn pill" href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html( $data['button_text'] ).'</a>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
					}
				}
                echo '<div class="col-lg-4 col-md-12">'; 
                    echo '<div class="property-values-2-item ">';
						foreach( $settings['feature_list2'] as $key => $data ){ 
							if($key == 1 || $key == 2){
								if($key == 1){
									$ani = '0.4s';
								}else{
									$ani = '0.6s';
								}
							echo ' <div class="thumb fadeinup wow" data-wow-delay="'.esc_attr($ani).'">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['choose_image']['url'] ),
								));
								echo '<div class="plus-icon"><i class="fa-solid fa-plus"></i></div>';
								echo '<div class="hover-content">';
									if(!empty($data['title'])){
										echo '<h4 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
									}
									if(!empty($data['description'])){
										echo '<p class="box-text">'.esc_html($data['description']).'</p>';
									}
									if(!empty($data['button_text'])){
										echo '<a class="th-btn pill" href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html( $data['button_text'] ).'</a>';
									}
								echo '</div>';
							echo '</div>';
							}
						}
                    echo '</div>';
                echo '</div>';
				foreach( $settings['feature_list2'] as $key => $data ){ 
					if($key > 2){
                	echo '<div class="col-lg-4 col-md-12">';
						echo '<div class="property-values-2-item fadeinright wow" data-wow-delay="0.8s">';
							echo ' <div class="thumb">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['choose_image']['url'] ),
								));
								echo '<div class="plus-icon"><i class="fa-solid fa-plus"></i></div>';
								echo '<div class="hover-content">';
									if(!empty($data['title'])){
										echo '<h4 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
									}
									if(!empty($data['description'])){
										echo '<p class="box-text">'.esc_html($data['description']).'</p>';
									}
									if(!empty($data['button_text'])){
										echo '<a class="th-btn pill" href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html( $data['button_text'] ).'</a>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
					}
				}
               
            echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){


		}
		
			
	}
}