<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Copyright Widget .
 *
 */
class Piller_Copyright extends Widget_Base {

	public function get_name() {
		return 'pillercopyright';
	}
	public function get_title() {
		return __( 'Footer Copyright', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Footer Copyright', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', ['Style One'] );

        piller_media_fields( $this, 'shape', 'Choose Shape', ['1'] );
		piller_general_fields( $this, 'copyright_text', 'Copyright Content', 'TEXTAREA', 'Copyright Piller 2025', ['1'] );

		piller_general_fields( $this, 'social_label', 'Social Label', 'TEXT', 'Social Media:', ['1'] );
        piller_social_fields($this, 'social_icon_list', 'Social List', ['1', '2', '3']);

		
        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '01', 'Copyright Content', '{{WRAPPER}} .copyright-text', ['1'] );
		piller_common_style_fields( $this, '02', 'Social Label', '{{WRAPPER}} .label', ['1'] );

	}

	protected function render() {

	$settings = $this->get_settings_for_display();


		if( $settings['layout_style'] == '1' ){
            echo '<div class="copyright-wrap">';
                if(!empty($settings['shape']['url'])){
                    echo '<div class="footer-bottom-top-shape animation-infinite" data-bg-src="'.esc_url( $settings['shape']['url'] ).'">';

                    echo '</div>';
                }
                echo '<div class="container">';
                    echo '<div class="row gy-3 justify-content-lg-between justify-content-center align-items-center">';
                        echo '<div class="col-lg-7">';
                            if($settings['copyright_text']){
                                echo '<p class="copyright-text">';
                                    echo wp_kses_post($settings['copyright_text']);
                                echo '</p>';
                            }
                        echo '</div>';
                        echo '<div class="col-auto">';
                            echo '<div class="footer-default-copy-right">';
                                if($settings['social_label']){
                                    echo '<p class="label">';
                                        echo esc_html($settings['social_label']);
                                    echo '</p>';
                                }
                                echo '<div class="th-social">';
                                    foreach( $settings['social_icon_list'] as $social_icon ){
                                        $social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
                                        $social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
                    
                                        echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';
                    
                                        \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );
                    
                                        echo '</a> ';
                                    }
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){


		}elseif( $settings['layout_style'] == '3' ){

		}


	}

}