<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Background;
/**
 * 
 * Footer Widgets .
 *
 */
class Piller_Footer_Widgets extends Widget_Base {

	public function get_name() {
		return 'pillerfooterwidgets';
	}
	public function get_title() {
		return __( 'Footer Widgets', 'piller' ); 
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}
	
	protected function register_controls() { 

		$this->start_controls_section(
			'layout_section',
			[
				'label'     => __( 'Footer Widget Style', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two' ] );
 
        piller_media_fields( $this, 'logo', 'Choose Logo', ['1'] );
		piller_general_fields( $this, 'title', 'Title', 'TEXT', 'Title', ['2'] );
		piller_general_fields( $this, 'desc', 'Description', 'TEXTAREA', '', ['1', '2'] );

        $repeater = new Repeater();

		piller_general_fields($repeater, 'icon', 'Icon', 'TEXTAREA2', '');
		piller_general_fields($repeater, 'desc', 'Content', 'TEXTAREA', 'Content');
		
		$this->add_control(
			'contact_lists',
			[
				'label' 		=> __( 'Contact Info', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Label', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
		);

        piller_media_fields( $this, 'logo2', 'Choose Logo', ['2'] );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .widget_title', ['2'] );
		piller_common_style_fields( $this, '02', 'Description', '{{WRAPPER}} .desc', ['1', '2'] );
		piller_common_style_fields( $this, '002', 'Contact Info', '{{WRAPPER}} .info-box_link span, {{WRAPPER}} .info-box_link a', ['1', '2'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
            echo '<div class="widget footer-widget">';
                echo '<div class="th-widget-about">';
                    if(!empty($settings['logo']['url'])){
                        echo '<div class="about-logo">';
                            echo '<a href="'.esc_url( home_url('/') ).'">';
                                echo piller_img_tag( array(
                                    'url'   => esc_url( $settings['logo']['url'] ),
                                ));
                            echo '</a>';
                        echo '</div>';
                    }
                    if($settings['desc']){
                        echo '<p class="about-text desc">'.esc_html($settings['desc']).'</p>';
                    }
                    echo '<div class="footer-info-wrap">';
                        foreach( $settings['contact_lists'] as $data ){
                            echo '<div class="footer-info">';
                                if(!empty($data['icon'])){
                                    echo wp_kses_post($data['icon']);
                                }
                                if(!empty($data['desc'])){
                                    echo '<p class="info-box_link">'.wp_kses_post($data['desc']).'</p>';
                                }
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
            echo '<div class="widget footer-widget">';
                if($settings['title']){
                    echo '<h3 class="widget_title">';
                        echo esc_html($settings['title']);
                    echo '</h3>';
                }
                echo '<div class="th-widget-about">';
                    if($settings['desc']){
                        echo '<p class="about-text desc">'.esc_html($settings['desc']).'</p>';
                    }
                    echo '<div class="footer-info-wrap">';
                        foreach( $settings['contact_lists'] as $data ){
                            echo '<div class="footer-info">';
                                if(!empty($data['icon'])){
                                    echo wp_kses_post($data['icon']);
                                }
                                if(!empty($data['desc'])){
                                    echo '<p class="info-box_link">'.wp_kses_post($data['desc']).'</p>';
                                }
                            echo '</div>';
                        }
                    echo '</div>';

                    if(!empty($settings['logo2']['url'])){
                        echo '<div class="about-logo">';
                            echo '<a href="'.esc_url( home_url('/') ).'">';
                                echo piller_img_tag( array(
                                    'url'   => esc_url( $settings['logo2']['url'] ),
                                ));
                            echo '</a>';
                        echo '</div>';
                    }

                echo '</div>';
            echo '</div>';
            
		}elseif( $settings['layout_style'] == '3' ){

        }
	

	}
}
						