<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Info Box Widget .
 *
 */
class piller_Info_Box extends Widget_Base {

	public function get_name() {
		return 'pillerinfobox';
	}
	public function get_title() {
		return __( 'Info Box', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Info Box', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four' ] ); 

		piller_media_fields( $this, 'icon', 'Choose Icon', ['2'] );
		piller_media_fields( $this, 'icon44', 'Choose Icon', ['4'] );
		piller_media_fields( $this, 'icon2', 'Choose Icon', ['3'] );
		piller_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Title', ['2', '3', '4'] );
		piller_media_fields( $this, 'image', 'Choose Image', ['2', '4'] );
		piller_general_fields( $this, 'rating', 'Rating', 'TEXTAREA', '', ['2', '3', '4'] );
		piller_general_fields( $this, 'desc', 'Description', 'TEXTAREA', 'Content', ['2', '3', '4'] );

		piller_general_fields( $this, 'button_text', 'Button Text', 'TEXT', 'Contact us', ['3'] );
		piller_url_fields( $this, 'button_url', 'Button URL', ['3'] );

		piller_media_fields( $this, 'icon11', 'Choose Icon', ['3'] );
		piller_general_fields( $this, 'title11', 'Title', 'TEXTAREA2', 'Trustipilot', ['3'] );
		piller_media_fields( $this, 'image11', 'Choose Image', ['3'] );

		$repeater = new Repeater();

		piller_media_fields($repeater, 'choose_icon', 'Choose Icon');
		piller_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Subtitle');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'Content'); 
		piller_media_fields($repeater, 'choose_icon2', 'Choose Icon');

		$this->add_control(
			'feature_list',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Title', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_section2',
			[
				'label'		 	=> __( 'Content 2', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				'condition'	=> [
					'layout_style' => ['4']
				]
			]
        );

		piller_media_fields( $this, 'icon4', 'Choose Icon', ['4'] );
		piller_general_fields( $this, 'title4', 'Title', 'TEXTAREA2', 'Title', ['4'] );
		piller_media_fields( $this, 'image4', 'Choose Image', ['4'] );
		piller_general_fields( $this, 'rating4', 'Rating', 'TEXTAREA', '', ['4'] );
		piller_general_fields( $this, 'desc4', 'Description', 'TEXTAREA', 'Content', ['4'] );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start 
		//---------------------------------------


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

			if( $settings['layout_style'] == '1' ){
				echo '<div class="footer-right-bottom-wrap">';
					foreach( $settings['feature_list'] as $key => $data ){
						$class = ($key == 0) ? '':'scan';
						echo '<div class="footer-right-bottom-item '.esc_attr($class).'">';
							if(!empty($data['choose_icon']['url'])){
								echo '<div class="footer-right-bottom-item__thumb">';
									echo piller_img_tag( array(
										'url'   => esc_url( $data['choose_icon']['url'] ),
									));
								echo '</div>';
							}
							echo '<div class="footer-right-bottom-item__content">';
								if(!empty($data['subtitle'])){
									echo '<p>'.esc_html($data['subtitle']).'</p>';
								}
								if(!empty($data['title'])){
									echo '<h4 class="box-title">'.wp_kses_post($data['title']).'</h4>';
								}
							echo '</div>';
							if(!empty($data['choose_icon2']['url'])){
								echo '<div class="footer-right-bottom-item__right">';
									echo piller_img_tag( array(
										'url'   => esc_url( $data['choose_icon2']['url'] ),
									));
								echo '</div>';
							}
						echo '</div>';
					}
				echo '</div>';
				 
			}elseif( $settings['layout_style'] == '2' ){
				echo '<div class="why-right-review-wrap sec-btn fadeinup wow">';
					echo '<div class="trust-content">';
						if(!empty($settings['icon'])){
							echo '<div class="icon">';
								echo piller_img_tag( array(
									'url'   => esc_url( $settings['icon']['url'] ),
								));
							echo '</div>';
						}
						if(!empty($settings['title'])){
							echo '<h4 class="box-title">'.wp_kses_post($settings['title']).'</h4>';
						}
					echo '</div>';
					echo '<div class="client">';
						if(!empty($settings['image']['url'])){
							echo '<div class="avatar">';
								echo piller_img_tag( array(
									'url'   => esc_url( $settings['image']['url'] ),
								));
							echo '</div>';
						}
						echo '<div class="content">';
							if(!empty($settings['rating'])){
								echo '<div class="th-social">'.wp_kses_post($settings['rating']).'</div>';
							}
							if(!empty($settings['desc'])){
								echo '<h4 class="review-title">'.wp_kses_post($settings['desc']).'</h4>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';

			}elseif( $settings['layout_style'] == '3' ){
				echo '<div class="testi-3-rating me-xl-5">';
					echo '<div class="rating-count">';
						if(!empty($settings['title'])){
							echo '<h2>'.wp_kses_post($settings['title']).'</h2>';
						}
						if(!empty($settings['icon2']['url'])){
							echo '<div class="star-shape spin">';
								echo piller_img_tag( array(
									'url'   => esc_url( $settings['icon2']['url'] ),
								));
							echo '</div>';
						}
					echo '</div>';

					echo '<div class="reviews-star">';
						if(!empty($settings['rating'])){
							echo '<div class="th-social">'.wp_kses_post($settings['rating']).'</div>';
						}
						if(!empty($settings['desc'])){
							echo '<h4 class="review-title">'.wp_kses_post($settings['desc']).'</h4>';
						}
					echo '</div>';
					if(!empty($settings['button_text'])){
						echo '<a class="th-btn tab-btn style3 radius" href="'.esc_url( $settings['button_url']['url'] ).'">'.esc_attr($settings['button_text']).'</a>';
					}
					echo '<div class="testi-bottom-item">';
						echo '<div class="trust-content">';
							if(!empty($settings['icon11'])){
								echo '<div class="icon">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['icon11']['url'] ),
									));
								echo '</div>';
							}
							if(!empty($settings['title11'])){
								echo '<h4 class="box-title">'.wp_kses_post($settings['title11']).'</h4>';
							}
						echo '</div>';
						echo '<div class="bottom">';
							if(!empty($settings['image11']['url'])){
								echo '<div class="avatar">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['image11']['url'] ),
									));
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';

			}elseif( $settings['layout_style'] == '4' ){
				echo '<div class="testi-bottom-review-wrap">';
					echo '<div class="testi-bottom-item fadeinleft wow" data-wow-delay="0.3s">';
						echo '<div class="trust-content">';
							if(!empty($settings['icon44'])){
								echo '<div class="icon">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['icon44']['url'] ),
									));
								echo '</div>';
							}
							if(!empty($settings['title'])){
								echo '<h4 class="box-title">'.wp_kses_post($settings['title']).'</h4>';
							}
						echo '</div>';
						echo '<div class="bottom">';
							if(!empty($settings['image']['url'])){
								echo '<div class="avatar">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['image']['url'] ),
									));
								echo '</div>';
							}
							echo '<div class="content">';
								if(!empty($settings['rating'])){
									echo '<div class="th-social">'.wp_kses_post($settings['rating']).'</div>';
								}
								if(!empty($settings['desc'])){
									echo '<h4 class="review-title">'.wp_kses_post($settings['desc']).'</h4>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';

					echo '<div class="divider"></div>';

					echo '<div class="testi-bottom-item fadeinright wow" data-wow-delay="0.6s">';
						echo '<div class="trust-content">';
							if(!empty($settings['icon4'])){
								echo '<div class="icon">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['icon4']['url'] ),
									));
								echo '</div>';
							}
							if(!empty($settings['title4'])){
								echo '<h4 class="box-title">'.wp_kses_post($settings['title4']).'</h4>';
							}
						echo '</div>';
						echo '<div class="bottom">';
							if(!empty($settings['image4']['url'])){
								echo '<div class="avatar">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['image4']['url'] ),
									));
								echo '</div>';
							}
							echo '<div class="content">';
								if(!empty($settings['rating4'])){
									echo '<div class="th-social">'.wp_kses_post($settings['rating4']).'</div>';
								}
								if(!empty($settings['desc4'])){
									echo '<h4 class="review-title">'.wp_kses_post($settings['desc4']).'</h4>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';

			}

	}

}