<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Directorist\Directorist_Single_Listing;

/**
 *
 * Info Box Widget .
 *
 */
class Piller_Single_quick_Info extends Widget_Base {

	public function get_name() {
		return 'pillersingquickinfo';
	}
	public function get_title() {
		return __( 'Listing Single Quick Info', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Quick info', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );



        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------


	}

	protected function render() {

        $settings = $this->get_settings_for_display();	
        
    	$listing = Directorist_Single_Listing::instance();

    	echo '<div class="directorist-single-listing-quick-action">';
			$listing->quick_actions_template();
		echo '</div>';

	}
}