<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * features Widget .
 *
 */
class Piller_Listing_Features extends Widget_Base {

	public function get_name() {
		return 'pillerlisitngfeatures';
	}
	public function get_title() {
		return __( 'Piller Single Listing Features', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Features', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two' ] );

		piller_general_fields($this, 'title', 'Title', 'TEXT', 'Property Hightlights', ['1', '2'] );
		piller_general_fields($this, 'subtitle', 'Subtitle', 'TEXT', 'House for sale', ['1'] );

        $repeater = new Repeater();

		piller_media_fields($repeater, 'choose_icon', 'Choose Icon');
		piller_general_fields($repeater, 'label', 'Label', 'TEXTAREA2', 'ID NO.');
		piller_general_fields($repeater, 'value', 'Value', 'TEXTAREA2', '#1234'); 

		$this->add_control(
			'feature_lists',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'ID NO.', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$repeater = new Repeater();

		piller_general_fields($repeater, 'content', 'Content', 'TEXTAREA2', 'Airconditioning'); 

		$this->add_control(
			'feature_lists2',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'content' 	=> __( 'Airconditioning', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start 
		//---------------------------------------
		piller_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .page-title', [ '1','2' ] );
		piller_common_style_fields( $this, '02', 'Subtitle', '{{WRAPPER}} .house-sell', [ '1' ] );


	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){
            echo '<div>';
                echo '<div class="hightlighes-title-wrap mb-25">';
                    if(!empty($settings['title'])){
                        echo '<h2 class="page-title mb-2">'.wp_kses_post($settings['title']).'</h2>';
                    }
                    if(!empty($settings['subtitle'])){
                        echo '<h5 class="house-sell">'.wp_kses_post($settings['subtitle']).'</h5>';
                    }
                echo '</div>';

                echo '<ul class="property-grid-list">';
                    foreach( $settings['feature_lists'] as $data ){
                        echo '<li>';
                            if(!empty($data['choose_icon']['url'])){
                                echo '<div class="property-grid-list-icon">';
                                    echo piller_img_tag( array(
                                        'url'   => esc_url( $data['choose_icon']['url'] ),
                                    ));
                                echo '</div>';
                            }
                            echo '<div class="property-grid-list-details">';
                                if(!empty($data['label'])){
                                    echo '<h4 class="property-grid-list-title">'.esc_html($data['label']).'</h4>';
                                }
                                if(!empty($data['value'])){
                                    echo '<p class="property-grid-list-text">'.esc_html($data['value']).'</p>';
                                }
                            echo '</div>';
                        echo '</li>';
                    }
                echo '</ul>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			if(!empty($settings['title'])){
				echo '<h3 class="page-title mt-50 mb-25">'.wp_kses_post($settings['title']).'</h3>';
			}
			echo '<div class="fea-anim-checklist">';
				echo '<div class="checklist style2 list-six-column">';
					echo '<ul>';
						foreach( $settings['feature_lists2'] as $data ){
							if(!empty($data['content'])){
								echo '<li>'.esc_html($data['content']).'</li>';
							}
						}
					echo '</ul>';
				echo '</div>';
			echo '</div>';

		}	


	}
}