<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;


/**
 *
 * Listing Grid Widget .
 *
 */
class Piller_Listing_Grid extends Widget_Base {

	public function get_name() {
		return 'pillerlistinggrid';
	}
	public function get_title() {
		return __( 'Listing Grid', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Listing Grid', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );

		$repeater = new Repeater();

        piller_general_fields($repeater, 'tag', 'Badge', 'TEXT', 'For Sale');

        $repeater->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Gallery Slider', 'piller' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Charming Beach House');
		
        piller_general_fields($repeater, 'location', 'Location', 'TEXTAREA2', '39581 Rohan Estates, New York');
        piller_general_fields($repeater, 'feature', 'Feature Content 1', 'TEXT', 'Bed 4');
        piller_general_fields($repeater, 'feature2', 'Feature Content 2', 'TEXT', 'Bath 2');
        piller_general_fields($repeater, 'feature3', 'Feature Content 3', 'TEXT', '1500 sqft');

        piller_general_fields($repeater, 'price', 'price', 'TEXT', '$179,800.00');
        piller_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'View More');
		piller_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'listing_list',
			[
				'label' 		=> __( 'Listing Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Charming Beach House', 'piller' ), 
					],
				],
				'condition'		=> [ 
					'layout_style' => [ '1', '2'],
				],
			]
		);

        piller_media_fields($this, 'location_icon', 'Change Location Icon');
        piller_media_fields($this, 'feature_icon', 'Change Feature Icon 1');
        piller_media_fields($this, 'feature_icon2', 'Change Feature Icon 2');
        piller_media_fields($this, 'feature_icon3', 'Change Feature Icon 3');

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

        piller_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a' );
		piller_common_style_fields( $this, '02', 'Location', '{{WRAPPER}} .box-text' );
		piller_common_style_fields( $this, '03', 'Features', '{{WRAPPER}} .property-featured li' );
		piller_common_style_fields( $this, '04', 'Price', '{{WRAPPER}} .price' );

        piller_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th-btn', ['1'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == '1' ){
            echo '<div class="row gy-30 justify-content-center">';
                $delay = 0.2;
                foreach( $settings['listing_list'] as $key => $data ){
                    $current_delay = number_format($delay * ($key + 1), 1);
                    echo '<div class="col-xxl-3 col-xl-4 col-lg-6 col-md-6">';
                        echo '<div class="popular-list-1 wow fadeinleft" data-wow-delay="' . esc_attr($current_delay) . 's">';
                            echo '<div class="thumb-wrapper">';
                                echo '<div class="th-slider" data-slider-options=\'{"effect":"fade"}\'>';
                                    echo '<div class="swiper-wrapper">';
                                        $x=0;
                                        foreach ( $data['gallery'] as $item ){
                                            echo '<div class="swiper-slide">';
                                                echo '<a class="popular-popup-image" href="'.esc_url( $item['url'] ).'">';
                                                    echo piller_img_tag( array(
                                                        'url'   => esc_url( $item['url'] ),
                                                    ));
                                                echo '</a>';
                                            echo '</div>';
                                            $x++;
                                        }
                                        echo '</div>';
                                    if($x > 1){
                                        echo '<div class="icon-wrap">';
                                            echo '<button class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                                            echo '<button class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
                                        echo '</div>';
                                    }
                                echo '</div>';
                                if(!empty($data['tag'])){
                                    echo '<div class="popular-badge">';
                                        echo '<img src="'.PILLER_ASSETS.'img/sell_rent_icon.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                        echo '<p>'.esc_html($data['tag']).'</p>';
                                    echo '</div>';
                                }
                            echo '</div>';
                            echo '<div class="property-content">';
                                echo '<div class="media-body">';
                                    if(!empty($data['title'])){
                                        echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
                                    }
                                    echo '<div class="box-text">';
                                        echo '<div class="icon">';
                                            if(!empty($settings['location_icon']['url'])){
                                                echo piller_img_tag( array(
                                                    'url'   => esc_url( $settings['location_icon']['url'] ),
                                                ));
                                            }else{
                                                echo '<img src="'.PILLER_ASSETS.'img/popular-location.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                            }
                                        echo '</div> ';
                                        if(!empty($data['location'])){
                                            echo esc_html($data['location']);
                                        }
                                    echo '</div>';
                                echo '</div>';

                                echo '<ul class="property-featured">';
                                    if(!empty($data['feature'])){
                                        echo '<li>';
                                            echo '<div class="icon">';
                                                if(!empty($settings['feature_icon']['url'])){
                                                    echo piller_img_tag( array(
                                                        'url'   => esc_url( $settings['feature_icon']['url'] ),
                                                    ));
                                                }else{
                                                    echo '<img src="'.PILLER_ASSETS.'img/bed.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                }
                                            echo '</div> ';
                                            echo esc_html($data['feature']);
                                        echo '</li>';
                                    }
                                    if(!empty($data['feature2'])){
                                        echo '<li>';
                                            echo '<div class="icon">';
                                                if(!empty($settings['feature_icon2']['url'])){
                                                    echo piller_img_tag( array(
                                                        'url'   => esc_url( $settings['feature_icon2']['url'] ),
                                                    ));
                                                }else{
                                                    echo '<img src="'.PILLER_ASSETS.'img/bath.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                }
                                            echo '</div> ';
                                            echo esc_html($data['feature2']);
                                        echo '</li>';
                                    }
                                    if(!empty($data['feature3'])){
                                        echo '<li>';
                                            echo '<div class="icon">';
                                                if(!empty($settings['feature_icon3']['url'])){
                                                    echo piller_img_tag( array(
                                                        'url'   => esc_url( $settings['feature_icon3']['url'] ),
                                                    ));
                                                }else{
                                                    echo '<img src="'.PILLER_ASSETS.'img/sqft.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                }
                                            echo '</div> ';
                                            echo esc_html($data['feature3']);
                                        echo '</li>';
                                    }
                                echo '</ul>';

                                echo '<div class="property-bottom">';
                                    if(!empty($data['price'])){
                                        echo '<h6 class="box-title price">'.esc_html($data['price']).'</h6>';
                                    }
                                    if(!empty($data['button_text'])){
                                        echo '<a class="th-btn sm style3 pill" href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['button_text']).'</a>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
            echo '</div>';

		}else{

		
		}
        

	}
}