<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
use \Directorist\Helper;
use Directorist\Includes\Listing\Renderer;
use \Directorist\Directorist_Single_Listing;
/**
 *
 * Gallery Widget .
 *
 */



class Piller_Listing_Single extends Widget_Base {

	public function get_name() {
		return 'pillerlistingsingle';
	}
	public function get_title() {
		return __( 'Piller Listing Single', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Listing Single Content', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        ); 

		piller_select_field( $this, 'layout_style', 'Layout Style',['Style One'] );

		piller_general_fields($this, 'title', 'Change Post Title', 'TEXT', 'About This Property', ['1'] );

        piller_switcher_fields($this, 'show_share', 'Show Share?', ['1']);
        piller_switcher_fields($this, 'show_love', 'Show Favorite Icon?', ['1']);
        piller_switcher_fields($this, 'show_report', 'Show Report?', ['1']);
		
		$this->end_controls_section();

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
            $class = [];

            if (!empty($settings['show_share'])) {
                $class[] = 'share';
            }
            if (!empty($settings['show_love'])) {
                $class[] = 'love';
            }
            if (!empty($settings['show_report'])) {
                $class[] = 'report';
            }
            
            $class = implode(' ', $class);

            $listing_id = get_the_ID();

            if (is_singular('at_biz_dir')) {
                $listing = Directorist_Single_Listing::instance();

                $price = get_post_meta($listing_id, '_price', true);
                $comments_count = get_comments_number($listing_id); 

                $bed =  piller_meta('piller_bed_count') ? piller_meta('piller_bed_count') : ' --';
                $bed_label = piller_opt('piller_listing_bed_text') ? piller_opt('piller_listing_bed_text') : 'Bed ';
            
                $bath =  piller_meta('piller_bath_count') ? piller_meta('piller_bath_count') : ' --';
                $bath_label = piller_opt('piller_listing_bath_text') ? piller_opt('piller_listing_bath_text') : 'Bath ';
            
                $sqft =  piller_meta('piller_room_size') ? piller_meta('piller_room_size') : ' --';
                $sqft_label2 =  piller_opt('piller_listing_sqft_text') ? piller_opt('piller_listing_sqft_text') : '';

                echo '<div class="property-meta-wrap mb-55">';
                    echo '<div class="property-meta">';
                        echo '<a href="#"><i class="fa-solid fa-calendar-days"></i>'.get_the_date().'</a>';
                        echo '<a href="#"><i class="fa-solid fa-comments"></i>'.$comments_count . ' ' . _n('Comment', 'Comments', $comments_count).'</a>';
                    echo '</div>';
                    echo '<div class="wishlist-icon">';
                        echo '<div class="directorist-single-listing-quick-action '.esc_attr($class).'">';
                            $listing->quick_actions_template();
                        echo '</div>';
                    echo '</div>';                  
                echo '</div>'; 

                echo '<div class="page-title-wrap">';
                    if(!empty($settings['title'])){
                        echo '<h2 class="page-title mb-2">'.esc_html( $settings['title'] ).'</h2>';
                    }else{
                        echo '<h2 class="page-title mb-2">'. get_the_title().'</h2>';
                    }
                    echo '<h4 class="page-title">';
                        atbdp_display_price($price);
                    echo '</h4>';
                echo '</div>';

                echo '<div class="page-features">';
                    echo '<div class="box-text">';
                        if(!empty(piller_opt('piller_listing_location_icon', 'url' ) )){
                            echo '<div class="icon">';
                                echo '<img src="'.esc_url( piller_opt('piller_listing_location_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                            echo '</div>';
                        }

                        if (!empty(piller_meta('piller_address'))) {
                            echo esc_html(piller_meta('piller_address'));
                        } else {
                            echo '<p class="property-card-location">' .directorist_the_locations() . '</p>';
                        }
                    echo '</div>';

                    echo '<ul class="property-featured">';
                        echo '<li>';
                            if(!empty(piller_opt('piller_listing_bed_icon', 'url' ) )){
                                echo '<div class="icon">';
                                    echo '<img src="'.esc_url( piller_opt('piller_listing_bed_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                                echo '</div>';
                            }
                            echo esc_html( $bed_label.' '.$bed );
                        echo '</li>';

                        echo '<li>';
                            if(!empty(piller_opt('piller_listing_bath_icon', 'url' ) )){
                                echo '<div class="icon">';
                                    echo '<img src="'.esc_url( piller_opt('piller_listing_bath_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                                echo '</div>';
                            }
                            echo esc_html( $bath_label.' '.$bath );
                        echo '</li>';

                        echo '<li>';
                            if(!empty(piller_opt('piller_listing_sqft_icon', 'url' ) )){
                                echo '<div class="icon">';
                                    echo '<img src="'.esc_url( piller_opt('piller_listing_sqft_icon', 'url' ) ).'" alt="'.esc_attr__('image', 'piller').'">';
                                echo '</div>';
                            }
                            echo esc_html( $sqft.' '.$sqft_label2 );
                        echo '</li>'; 
                    echo '</ul>';
                echo '</div>';
            }else{
                echo esc_html__('This is not a listing single page', 'piller');
            }

		}


	}
}