<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Gallery Widget .
 *
 */



class Piller_Listing_Video extends Widget_Base {

	public function get_name() {
		return 'pillerlistingvideo';
	}
	public function get_title() {
		return __( 'Piller Listing Video', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Video', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        ); 
		piller_select_field( $this, 'layout_style', 'Layout Style',['Style One'] );

		piller_general_fields($this, 'title', 'Title', 'TEXT', 'Video', ['1'] );

		piller_media_fields( $this, 'thumb', 'Video Thumb', ['1'] );
		piller_general_fields( $this, 'icon', 'Icon', 'TEXTAREA2', '<i class="fa-sharp fa-solid fa-play"></i>' );
		piller_url_fields( $this, 'video_url', 'Video URL' );
		

		$this->end_controls_section();

		piller_common2_style_fields( $this, 'title', 'Title', '{{WRAPPER}} h3', [ '2' ] );


	}

	protected function render() {

	$settings = $this->get_settings_for_display();



		if( $settings['layout_style'] == '1' ){

			if(!empty($settings['title'])){
				echo '<h3 class="page-title mt-50 mb-30">'.esc_html( $settings['title'] ).'</h3>';
			}
			echo '<div class="listing-video">';
				if(!empty($settings['video_url']['url'])){
					echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">'.wp_kses_post($settings['icon']).'</a>';
				}
				if(!empty($settings['thumb']['url'])){
					echo '<div class="video-thumb">';
						echo piller_img_tag( array(
							'url'   => esc_url( $settings['thumb']['url'] ),
						));
					echo '</div>';
				}
			echo '</div>';

		}


	}
}