<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Service Widget .
 *
 */
class piller_Service extends Widget_Base {

	public function get_name() {
		return 'pillerservice'; 
	}
	public function get_title() {
		return __( 'Services', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Services', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );

		$this->add_control(
			'th_show_load_more',
			[
				'label' 		=> __( 'Show Load More Option?', 'piller' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'piller' ),
				'label_off' 	=> __( 'Hide', 'piller' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> [
					'layout_style' => ['1'], 
				]
			]
		);
		$this->add_control(
			'th_loop_item_show',
			[
				'label' 	=> __( 'No of Loop Item show', 'piller' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => 16,
                'default'  	=> __( '6', 'piller' ),
				'condition'	=> [
					'layout_style' => ['1'],
					'th_show_load_more' => [ 'yes' ],
				]
			]
        );
		$this->add_control(
			'th_loop_item_count',
			[
				'label' 	=> __( 'No of Loop Item show by click', 'piller' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => 16,
                'default'  	=> __( '3', 'piller' ),
				'condition'	=> [
					'layout_style' => ['1'],
					'th_show_load_more' => [ 'yes' ],
				]
			]
        );
		$this->add_control(
			'th_load_more_button_text',
			[
				'label' 		=> __( 'Load More Button Text', 'piller' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 	=> __( 'Load More', 'piller' ),
				'condition'	=> [
					'layout_style' => ['1'],
					'th_show_load_more' => [ 'yes' ],
				]
			]
		);

		$this->add_responsive_control(
			'section_align',
			[
				'label' 		=> __( 'Alignment', 'piller' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'start' 	=> [
						'title' 		=> __( 'Left', 'piller' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'piller' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'end' 	=> [
						'title' 		=> __( 'Right', 'piller' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'center',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .load-more-wrap' => 'justify-content: {{VALUE}};',
                ]
			]
		);

		piller_general_fields($this, 'col', 'Column Class', 'TEXTAREA2', 'col-xl-4 col-md-6');

		$repeater = new Repeater();

		piller_media_fields($repeater, 'choose_image', 'Choose Image');
		piller_media_fields($repeater, 'choose_icon', 'Choose Icon');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Home Renovation Consultation');
		piller_general_fields($repeater, 'description', 'Description', 'TEXTAREA', 'Expert advice and guidance on property renovation projects.'); 
		piller_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'service_list',
			[
				'label' 		=> __( 'Service Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Home Renovation Consultation', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);
		
        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common2_style_fields( $this, '02', 'Title', '{{WRAPPER}} .box-title a', ['1', '3', '4'] );
		piller_common_style_fields( $this, '04', 'Description', '{{WRAPPER}} .box-text', ['1', '3', '4']  );


	}
 
	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			if(!empty($settings['th_show_load_more'])){
				$service_item_count = $settings['th_loop_item_show'] ?? '6';
				$service_loop_item_count = $settings['th_loop_item_count'] ?? '3';
				$th_load_more_button_text = !empty($settings['th_load_more_button_text']) ? $settings['th_load_more_button_text'] : 'Load More';
			}
			if(!empty($settings['col'])){
				$col = $settings['col'];
			}else{
				$col = 'col-xl-4 col-md-6';
			}
			echo '<div class="row gy-40 justify-content-center">';
				$x=0;
				foreach( $settings['service_list'] as $key => $data ){
					$x++;
					$number = str_pad($key + 1, 2, '0', STR_PAD_LEFT);
					echo '<div class="'.esc_attr($col).' th-service-loop fadeinup wow">';
						echo '<div class="service-card">';
							if(!empty($data['choose_image']['url'])){
								echo '<div class="box-thumb">';
									echo '<a href="'.esc_url( $data['button_url']['url'] ).'">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['choose_image']['url'] ),
										));
									echo '</a>';
								echo '</div>';
							}
							echo '<div class="box-content">';
								echo '<div class="icon-wrap">';
									if(!empty($data['choose_icon']['url'])){
										echo '<div class="icon">'; 
											echo piller_img_tag( array(
												'url'   => esc_url( $data['choose_icon']['url'] ),
											));
										echo '</div>';
									}
									echo '<div class="number"><h3>' . $number . '</h3></div>';
								echo '</div>';
								if(!empty($data['title'])){
									echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
								}
								if(!empty($data['description'])){
									echo '<p class="box-text">'.esc_html($data['description']).'</p>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
				if(!empty($settings['th_show_load_more'])){
					if($x > $service_item_count){
						echo '<div class="mt-5 pt-3 d-flex load-more-wrap">';
							echo '<button id="load-more-service-btn" class="th-btn pill">'.esc_html($th_load_more_button_text).'</button>';
						echo '</div>';
					}
				}
			echo '</div>';
			?>
<script>
	jQuery(document).ready(function($) {
		// Set the number of items to show initially and load on each click
		var itemsToShow = <?php echo $service_item_count; ?>;
		var itemsPerLoad = <?php echo $service_loop_item_count; ?>; 
		var currentIndex = itemsToShow;
	
		// Hide items beyond the initial count
		$('.th-service-loop').slice(itemsToShow).hide();      
	
		// Attach a click event to the "Load More" button
		$('#load-more-service-btn').on('click', function() {
			// Show the next batch of items
			$('.th-service-loop').slice(currentIndex, currentIndex + itemsPerLoad).fadeIn();
			
			// Update the current index
			currentIndex += itemsPerLoad;
	
			// Hide the "Load More" button if all items are displayed
			if (currentIndex >= $('.th-service-loop').length) {
				$('#load-more-service-btn').hide();
			}
		});
	});
</script>

		<?php
		}elseif( $settings['layout_style'] == '2' ){
	

		}


	}

}