<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Team Widget .
 *
 */
class piller_Team extends Widget_Base {

	public function get_name() {
		return 'pillerteam';
	}
	public function get_title() {
		return __( 'Team', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'team_section',
			[
				'label'     => __( 'Team Content', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] );

		piller_media_fields($this, 'bg', 'Choose Shape/BG', ['1', '2', '3']);

		$repeater = new Repeater();

		piller_media_fields($repeater, 'team_image', 'Team Image');
		piller_general_fields($repeater, 'name', 'Name', 'TEXTAREA2', 'Mishel Marsh');
		piller_url_fields($repeater, 'profile_url', 'Profile URL');
		piller_general_fields($repeater, 'designation', 'Designation', 'TEXTAREA2', 'Founder');

		piller_url_fields($repeater, 'facebook_url', 'Facebook URL');
		piller_url_fields($repeater, 'twitter_url', 'Twitter URL');
		piller_url_fields($repeater, 'linkedin_url', 'Linkedin URL');
		piller_url_fields($repeater, 'instagram_url', 'Instagram URL');
		piller_general_fields($repeater, 'email_url', 'Email Link', 'TEXTAREA2', 'mailto:piller@gmail.com');
		
		$this->add_control(
			'team_lists',
			[
				'label' 		=> __( 'Member Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'name' 	=> __( 'Mishel Marsh', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2', '3']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//--------------------------------------- 

		piller_common2_style_fields( $this, '01', 'Name', '{{WRAPPER}} .box-title a' );
		piller_common_style_fields( $this, '02', 'Designation', '{{WRAPPER}} .team-desig' );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

			if( $settings['layout_style'] == '1' ){
				echo '<div class="row gy-30">';
					$delay = 0.2;
					$animations = ['fadeinleft', 'fadeinleft', 'fadeinright', 'fadeinright'];
					foreach( $settings['team_lists'] as $key => $data ){
						$animation_class = $animations[$key % count($animations)];
						$current_delay = number_format($delay * ($key + 1), 1);

						$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

						$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
						$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
						$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
						$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
						$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
						$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
						$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
						$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';

						echo '<div class="col-xl-3 col-md-6 wow ' . esc_attr($animation_class) . '" data-wow-delay="' . esc_attr($current_delay) . 's"> ';
							echo '<div class="team-card">';
								if(!empty($data['team_image']['url'])){
									echo '<div class="team-img" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['team_image']['url']  ),
										));
									echo '</div>';
								}
								echo '<div class="team-content">';
									if($data['name']){
										echo '<h3 class="box-title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
									}
									if($data['designation']){
										echo '<p class="team-desig">'.esc_html($data['designation']).'</p>';
									}
									echo '<div class="team-social">';
										if( ! empty( $data['facebook_url']['url'] || $data['twitter_url']['url'] || $data['linkedin_url']['url'] || $data['instagram_url']['url'] ) ){
											echo '<div class="th-social">';
												if( ! empty( $data['facebook_url']['url']) ){
													echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
												}
												if( ! empty( $data['twitter_url']['url']) ){
													echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
												}
												if( ! empty( $data['linkedin_url']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
												}
												if( ! empty( $data['instagram_url']['url']) ){
													echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
												}
												if( ! empty( $data['email_url']) ){
													echo '<a href="'.esc_attr( $data['email_url'] ).'"><i class="fa-solid fa-envelope"></i></a>';
												}
											echo '</div>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';

			}elseif( $settings['layout_style'] == '2' ){
				echo '<div class="slider-area">';
					echo '<div class="swiper th-slider has-shadow" id="teamSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"4"}}, "autoHeight": "true"}\'>';
						echo '<div class="swiper-wrapper">';
							foreach( $settings['team_lists'] as $data ){
								$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
								$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

								$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
								$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
								$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
								$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
								$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
								$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
								$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
								$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';

								echo '<div class="swiper-slide">';
									echo '<div class="team-card style-2" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
										if(!empty($data['team_image']['url'])){
											echo '<div class="team-img">';
												echo piller_img_tag( array(
													'url'   => esc_url( $data['team_image']['url'] ),
												));
											echo '</div>';
										}
										echo '<div class="team-content">';
											echo '<div class="left-contet">';
												if($data['name']){
													echo '<h3 class="box-title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
												}
												if($data['designation']){
													echo '<p class="team-desig">'.esc_html($data['designation']).'</p>';
												}
											echo '</div>';
											echo '<div class="team-social">';
												if( ! empty( $data['facebook_url']['url'] || $data['twitter_url']['url'] || $data['linkedin_url']['url'] || $data['instagram_url']['url'] ) ){
													echo '<div class="th-social">';
														if( ! empty( $data['facebook_url']['url']) ){
															echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
														}
														if( ! empty( $data['twitter_url']['url']) ){
															echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
														}
														if( ! empty( $data['linkedin_url']['url']) ){
															echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
														}
														if( ! empty( $data['instagram_url']['url']) ){
															echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
														}
														if( ! empty( $data['email_url']) ){
															echo '<a href="'.esc_attr( $data['email_url'] ).'"><i class="fa-solid fa-envelope"></i></a>';
														}
													echo '</div>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';

			}elseif( $settings['layout_style'] == '3' ){
				echo '<div class="row gy-30 justify-content-center">';
					foreach( $settings['team_lists'] as $data ){
						$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

						$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
						$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
						$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
						$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
						$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
						$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
						$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
						$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';

						echo '<div class="col-xl-3 col-lg-4 col-md-6 fadeinup wow">';
							echo '<div class="team-card style-2" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
								if(!empty($data['team_image']['url'])){
									echo '<div class="team-img">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['team_image']['url'] ),
										));
									echo '</div>';
								}
								echo '<div class="team-content">';
									echo '<div class="left-contet">';
										if($data['name']){
											echo '<h3 class="box-title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
										}
										if($data['designation']){
											echo '<p class="team-desig">'.esc_html($data['designation']).'</p>';
										}
									echo '</div>';
									echo '<div class="team-social">';
										if( ! empty( $data['facebook_url']['url'] || $data['twitter_url']['url'] || $data['linkedin_url']['url'] || $data['instagram_url']['url'] || $data['email_url'] ) ){
											echo '<div class="th-social">';
												if( ! empty( $data['facebook_url']['url']) ){
													echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
												}
												if( ! empty( $data['twitter_url']['url']) ){
													echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
												}
												if( ! empty( $data['linkedin_url']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
												}
												if( ! empty( $data['instagram_url']['url']) ){
													echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
												}
												if( ! empty( $data['email_url']) ){
													echo '<a href="'.esc_attr( $data['email_url'] ).'"><i class="fa-solid fa-envelope"></i></a>';
												}
											echo '</div>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';

			}
	
			
	}
}