<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Widget .
 *
 */
class piller_Video extends Widget_Base {

	public function get_name() {
		return 'pillervideo';
	}
	public function get_title() {
		return __( 'Video Box', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_section',
			[
				'label' 	=> __( 'video Box', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] ); 

		piller_media_fields( $this, 'image1', 'Choose Image', [ '1', '2', '3' ] );
		piller_media_fields( $this, 'image2', 'Choose Image', [ '2' ] );
		piller_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Scan to Download', ['2'] );

		piller_general_fields( $this, 'icon', 'Icon', 'TEXTAREA2', '<i class="fa-sharp fa-solid fa-play"></i>' );
		piller_url_fields( $this, 'video_url', 'Video URL' );
		piller_general_fields($this, 'circle_text', 'Video Circle Text', 'TEXT', 'PILLAR REAL ESTATE HOME * REAL ESTATE' , ['2'] );

		piller_media_fields( $this, 'arrow', 'Choose Arrow', [ '2' ] );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

	
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="property-values-1-video">';
				if(!empty($settings['video_url']['url'])){
					echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">'.wp_kses_post($settings['icon']).'</a>';
				}
				echo '<div class="video-thumb">'; 
					echo piller_img_tag( array(
						'url'   => esc_url( $settings['image1']['url'] ),
					));
				echo '</div>';
			echo '</div>'; 

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="scan-download-wrap">';
				echo '<div class="download-logo-circle hero-img-shape-2 fadeinup wow" data-wow-delay="0.2s">';
					echo '<div class="logo-icon-wrap">';
						if(!empty($settings['video_url']['url'])){
							echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="logo-icon popup-video">'.wp_kses_post($settings['icon']).'</a>';
						}
						if(!empty($settings['circle_text'])){
							echo '<div class="logo-icon-wrap__text">';
								echo '<span class="logo-animation">'.esc_html($settings['circle_text']).'</span>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
 
				echo '<div class="scan-download-card">';
					echo '<div class="scan-download-card-inner">';
						if(!empty($settings['title'])){
							echo '<h5>'.esc_html($settings['title']).'</h5>';
						}
						echo piller_img_tag( array(
							'url'   => esc_url( $settings['arrow']['url'] ),
							'class' => 'shape',
						));
						if(!empty($settings['image2']['url'])){
							echo '<div class="qr-code-box">';
								echo piller_img_tag( array(
									'url'   => esc_url( $settings['image2']['url'] ),
									'class' => 'qu-code',
								));
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				if(!empty($settings['image1']['url'])){
					echo '<div class="download-thumb fadeinup wow" data-wow-delay="0.4s">';
						echo piller_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
            echo '<div class="price-video-wrapper" data-bg-src="'.esc_url( $settings['image1']['url'] ).'">';
                echo '<div class="gallery-video-wrap">';
                    echo '<div class="video-box1">';
						if(!empty($settings['video_url']['url'])){
							echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">'.wp_kses_post($settings['icon']).'</a>';
						}
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}


	}

}