<?php

/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */

    // Block direct access

    if( ! defined( 'ABSPATH' ) ){

        exit();

    }

/**

 * Admin Custom Login Logo

 */

function piller_custom_login_logo() {

    $logo = ! empty( piller_opt( 'piller_admin_login_logo', 'url' ) ) ? piller_opt( 'piller_admin_login_logo', 'url' ) : '' ;

    if( isset( $logo ) && ! empty( $logo ) ){

        echo '<style type="text/css">body.login div#login h1 a { background-image:url('.esc_url( $logo ).'); }</style>';
    }
}

add_action( 'login_enqueue_scripts', 'piller_custom_login_logo' );

/**
* Admin Custom css
*/

add_action( 'admin_enqueue_scripts', 'piller_admin_styles' );

function piller_admin_styles() {

  if ( ! empty( $piller_admin_custom_css ) ) {
        $piller_admin_custom_css = str_replace(array("\r\n", "\r", "\n", "\t", '    '), '', $piller_admin_custom_css);
        echo '<style rel="stylesheet" id="piller-admin-custom-css" >';
            echo esc_html( $piller_admin_custom_css );
        echo '</style>';
    }
}

// share button code

 function piller_social_sharing_buttons( ) {

    // Get page URL

    $URL        = get_permalink();
    $Sitetitle  = get_bloginfo('name');
    // Get page title

    $Title  = str_replace( ' ', '%20', get_the_title());

    // Construct sharing URL without using any script

    $twitterURL     = 'https://twitter.com/share?text='.esc_html( $Title ).'&url='.esc_url( $URL );
    $facebookURL    = 'https://www.facebook.com/sharer/sharer.php?u='.esc_url( $URL );
    $pinterest   = 'http://pinterest.com/pin/create/link/?url='.esc_url( $URL ).'&media='.esc_url(get_the_post_thumbnail_url()).'&description='.wp_kses_post(get_the_title());
    $linkedin       = 'https://www.linkedin.com/shareArticle?mini=true&url='.esc_url( $URL ).'&title='.esc_html( $Title );
    // Add sharing button at the end of page/page content

    $content = '';

    $content .= '<a href="'.esc_url( $facebookURL ).'" target="_blank"><i class="fab fa-facebook-f"></i></a>';
    $content .= '<a href="'. esc_url( $twitterURL ) .'" target="_blank"><i class="fab fa-twitter"></i></a>';
    $content .= '<a href="'.esc_url( $linkedin ).'" target="_blank"><i class="fab fa-linkedin-in"></i></a>';
    $content .= '<a href="'.esc_url( $pinterest ).'" target="_blank"><i class="fa-brands fa-pinterest-p"></i></a>';


    return $content;

};


//Post Reading Time Count

function piller_estimated_reading_time() {
    global $post;
    // get the content
    $the_content = $post->post_content;
    // count the number of words
    $words = str_word_count( strip_tags( $the_content ) );
    // rounding off and deviding per 100 words per minute
    $minute = floor( $words / 100 );
    // rounding off to get the seconds
    $second = floor( $words % 100 / ( 100 / 60 ) );
    // calculate the amount of time needed to read
    $estimate = $minute . esc_html__(' Min', 'piller') . ( $minute == 1 ? '' : 's' ) . esc_html__(' Read', 'piller');
    // create output
    $output = $estimate;
    // return the estimate
    return $output;
}



//add SVG to allowed file uploads

function piller_mime_types( $mimes ) {

    $mimes['svg'] = 'image/svg+xml';
    $mimes['svgz'] = 'image/svgz+xml';
    $mimes['exe'] = 'program/exe';
    $mimes['dwg'] = 'image/vnd.dwg';
    return $mimes;
}

add_filter('upload_mimes', 'piller_mime_types');



function piller_wp_check_filetype_and_ext( $data, $file, $filename, $mimes ) {

    $wp_filetype = wp_check_filetype( $filename, $mimes );
    $ext         = $wp_filetype['ext'];
    $type        = $wp_filetype['type'];
    $proper_filename = $data['proper_filename'];

    return compact( 'ext', 'type', 'proper_filename' );

}

add_filter( 'wp_check_filetype_and_ext', 'piller_wp_check_filetype_and_ext', 10, 4 );


// Event Post Type

// add_action( 'init','piller_event', 0 );

function piller_event(){

    $labels = array(

        'name'               => esc_html__( 'Events', 'post Category general name', 'piller' ),
        'singular_name'      => esc_html__( 'Event', 'post Category singular name', 'piller' ),
        'menu_name'          => esc_html__( 'Events', 'admin menu', 'piller' ),
        'name_admin_bar'     => esc_html__( 'Event', 'add new on admin bar', 'piller' ),
        'add_new'            => esc_html__( 'Add New', 'Event', 'piller' ),
        'add_new_item'       => esc_html__( 'Add New Event', 'piller' ),
        'new_item'           => esc_html__( 'New Event', 'piller' ),
        'edit_item'          => esc_html__( 'Edit Event', 'piller' ),
        'view_item'          => esc_html__( 'View Event', 'piller' ),
        'all_items'          => esc_html__( 'All Events', 'piller' ),
        'search_items'       => esc_html__( 'Search Events', 'piller' ),
        'parent_item_colon'  => esc_html__( 'Parent Events:', 'piller' ),
        'not_found'          => esc_html__( 'No Events found.', 'piller' ),
        'not_found_in_trash' => esc_html__( 'No Events found in Trash.', 'piller' ),
    );

    $args = array(

        'labels'             => $labels,
        'description'        => esc_html__( 'Description.', 'piller' ),
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'show_in_rest'       => true,
        'menu_icon'          => 'dashicons-list-view',
        'supports'           => array( 'title', 'thumbnail', 'editor', 'elementor' ),
        'rewrite'            => array( 'slug' => 'events' ),
        'menu_position' => 10,
    );

    register_post_type( 'piller_event', $args );


    $labels = array(

        'name'                       => esc_html__( 'Categories', 'taxonomy general name', 'piller' ),
        'singular_name'              => esc_html__( 'Category', 'taxonomy singular name', 'piller' ),
        'search_items'               => esc_html__( 'Search Categorys', 'piller' ),
        'popular_items'              => esc_html__( 'Popular Categorys', 'piller' ),
        'all_items'                  => esc_html__( 'All Categorys', 'piller' ),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => esc_html__( 'Edit Category', 'piller' ),
        'update_item'                => esc_html__( 'Update Category', 'piller' ),
        'add_new_item'               => esc_html__( 'Add New Category', 'piller' ),
        'new_item_name'              => esc_html__( 'New Category Name', 'piller' ),
        'separate_items_with_commas' => esc_html__( 'Separate Categorys with commas', 'piller' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove Categorys', 'piller' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used Categorys', 'piller' ),
        'not_found'                  => esc_html__( 'No Categorys found.', 'piller' ),
        'menu_name'                  => esc_html__( 'Categories', 'piller' ),
    );



    $args = array(

        'hierarchical'          => true,
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'show_in_rest'          => true,
        'rewrite'               => array( 'slug' => 'event-category' ),
    );

    register_taxonomy( 'event_category', 'piller_event', $args );

    // Add new taxonomy, NOT hierarchical (like tags)
    $labels = array(

        'name'                       => esc_html__( 'Tags', 'taxonomy general name', 'piller' ),
        'singular_name'              => esc_html__( 'Tag', 'taxonomy singular name', 'piller' ),
        'search_items'               => esc_html__( 'Search Tags', 'piller' ),
        'popular_items'              => esc_html__( 'Popular Tags', 'piller' ),
        'all_items'                  => esc_html__( 'All Tags', 'piller' ),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => esc_html__( 'Edit Tag', 'piller' ),
        'update_item'                => esc_html__( 'Update Tag', 'piller' ),
        'add_new_item'               => esc_html__( 'Add New Tag', 'piller' ),
        'new_item_name'              => esc_html__( 'New Tag Name', 'piller' ),
        'separate_items_with_commas' => esc_html__( 'Separate Tags with commas', 'piller' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove Tags', 'piller' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used Tags', 'piller' ),
        'not_found'                  => esc_html__( 'No Tags found.', 'piller' ),
        'menu_name'                  => esc_html__( 'Tags', 'piller' ),

    );

    $args = array(

        'hierarchical'          => false,
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'show_in_rest'          => true,
        'rewrite'               => array( 'slug' => 'event-tag' ),
    );

    register_taxonomy( 'event_tag', 'piller_event', $args );
}

/**
 * Single Template
 */

// add_filter( 'single_template', 'piller_core_template_redirect' );

if( ! function_exists( 'piller_core_template_redirect' ) ){

    function piller_core_template_redirect( $single_template ){
        global $post;

        if( $post ){

            if( $post->post_type == 'piller_event' ){

                $single_template = PILLER_CORE_PLUGIN_TEMP . 'single-piller_event.php';

            }
        }

        return $single_template;
    }

}


/**
 * Archive Template
 */

// add_filter( 'archive_template', 'piller_core_template_archive' );

if( ! function_exists( 'piller_core_template_archive' ) ){

    function piller_core_template_archive( $archive_template ){

        global $post;


        if( $post ){

            if( $post->post_type == 'piller_event' ){

                $archive_template = PILLER_CORE_PLUGIN_TEMP . 'archive-piller_event.php';
            }
        }

        return $archive_template;
    }

}

//Custom pagination for blog widgets
if (!function_exists('piller_custom_query_pagination')){
    /**
     * Prints HTML with post pagination links.
     */
    function piller_custom_query_pagination($paged = '', $max_page = '')
    {
        global $wp_query;
        $big = 999999999; // need an unlikely integer
        if (!$paged)
            $paged = get_query_var('paged');
        if (!$max_page)
            $max_page = $wp_query->max_num_pages;

        // Get the pagination links as an array
        $links = paginate_links(array(
            'base'       => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format'     => '?paged=%#%',
            'current'    => max(1, $paged),
            'total'      => $max_page,
            'mid_size'   => 1,
            'prev_text'  => '<i class="fa-regular fa-angle-left"></i>',
            'next_text'  => '<i class="fa-regular fa-angle-right"></i>',
            'type'       => 'array', // This returns the links as an array, making it easier to loop through.
        ));

        if (!empty($links)) {
            echo '<div class="th-pagination mt-20">';
                echo '<ul';
                    // Loop through each link
                    foreach ($links as $link) {
                        // Check if this is the current page
                        if (strpos($link, 'current') !== false) {
                            // Modify the current page link by adding the 'active' class
                            $link = str_replace('page-numbers current', 'page-numbers active', $link);
                            $link = str_replace('<span', '<a', $link); // Replace <span> with <a> for current link
                            $link = str_replace('</span>', '</a>', $link); // Close the <a> tag
                        }
                        // Wrap the link in <li>
                        echo '<li>' . wp_kses_post($link) . '</li>';
                    }
                echo '</ul>';
            echo '</div>';
        }
    }
}


// Add Image Size
add_image_size( 'piller_80X80', 80, 80, true );
add_image_size( 'piller_524X392', 524, 392, true );

add_image_size( 'piller_795X290', 795, 290, true );
add_image_size( 'piller_383X290', 383, 290, true );

remove_filter( 'render_block', 'wp_render_layout_support_flag', 10, 2 );
remove_filter( 'render_block', 'gutenberg_render_layout_support_flag', 10, 2 );