<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.4.0
 */

use \Directorist\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;

$lt_types = $searchform->get_listing_type_data();
ksort($lt_types);
?>

<div class="<?php Helper::directorist_container_fluid(); ?>">
	<ul class="directorist-listing-type-selection">
		<?php foreach ( $lt_types as $id => $value ): ?>
			<li class="directorist-listing-type-selection__item"><a class="search_listing_types directorist-listing-type-selection__link<?php echo esc_attr($searchform->get_default_listing_type() == $id ? '--current': ''); ?>" data-listing_type="<?php echo esc_attr( $value['term']->slug );?>" data-listing_type_id="<?php echo esc_attr( $id );?>" href="#"><?php directorist_icon( $value['data']['icon'] ); ?> <?php echo esc_html( $value['name'] );?></a></li>
		<?php endforeach; ?>
	</ul>
</div>