<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Piller_Blog extends Widget_Base {

	public function get_name() {
		return 'pillerblog';
	}
	public function get_title() {
		return __( 'Blog Post', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' => __( 'Blog Post', 'piller' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] );

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'piller' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => count( get_posts( array('post_type' => 'post', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default'  	=> __( '3', 'piller' )
			]
        );

        piller_general_fields( $this, 'title_count', 'Title Length', 'TEXT2', '6');
        piller_general_fields( $this, 'excerpt_count', 'Excerpt Length', 'TEXT2', '14' );
        piller_general_fields( $this, 'title_count2', 'Big Title Length', 'TEXT2', '6', ['3']);
        piller_general_fields( $this, 'excerpt_count2', 'Big Excerpt Length', 'TEXT2', '14', ['3'] );

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'piller' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','piller'),
                    'DESC'   	=> __('DESC','piller'),
                ],
                'default'  	=> 'DESC'
			]
        );
        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'piller' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'piller' ),
                    'author'    => __( 'Author', 'piller' ),
                    'title'    	=> __( 'Title', 'piller' ),
                    'date'    	=> __( 'Date', 'piller' ),
                    'rand'    	=> __( 'Random', 'piller' ),
                ],
                'default'  	=> 'ID'
			]
        );
       
        $this->add_control(
            'post_display_type',
            [
                'label'   => __( 'Post Display Type', 'piller' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'all'      => __( 'All Posts', 'piller' ),
                    'category' => __( 'Category', 'piller' ),
                    'tags'     => __( 'Tags', 'piller' ),
                ],
                'default' => 'category',
            ]
        );        

        $this->add_control(
            'post_customization_note',
            [
                'type'    => \Elementor\Controls_Manager::RAW_HTML,
                'raw'     => __( '<strong>All posts are displayed by default.</strong><br>Use the "Include" or "Exclude" options below to customize which categories, tags, or specific posts should be shown or hidden.', 'piller' ),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                'condition'     => [
                    'post_display_type' => 'all',
                ],
            ]
        );
        $this->add_control(
            'include_exclude_option',
            [
                'label'   => __( 'Include or Exclude', 'piller' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'include' => __( 'Include', 'piller' ),
                    'exclude' => __( 'Exclude', 'piller' ),
                ],
                'default' => 'exclude',
                'condition'     => [
                    'post_display_type' => 'all',
                ],
            ]
        );
        
        $this->add_control(
            'blog_categories',
            [
                'label'         => __( 'Categories', 'piller' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
                'options'       => $this->piller_get_categories(),
                'label_block'   => true,
                'condition'     => [
                    'post_display_type' => ['category', 'all'],
                ],
            ]
        );
        $this->add_control(
            'blog_tags',
            [
                'label'         => __( 'Tags', 'piller' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
                'options'       => $this->piller_get_tags(),
                'label_block'   => true,
                'condition'     => [
                    'post_display_type' => ['tags', 'all'],
                ],
            ]
        );
        $this->add_control(
            'blog_posts',
            [
                'label'         => __( 'Posts', 'piller' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
                'options'       => $this->piller_post_id(),
                'label_block'   => true,
                'condition'     => [
                    'post_display_type' => 'all',
                ],
            ]
        );

        piller_general_fields( $this, 'button_text', 'Read More Text', 'TEXTAREA2', 'Read More' );

        // Get all registered image sizes
        $image_sizes = get_intermediate_image_sizes(); 
        $options = [];
        foreach ( $image_sizes as $size ) {
            $options[ $size ] = ucfirst( str_replace( '_', ' ', $size ) );
        }
        $this->add_control(
            'image_resolution',
            [
                'label'       => __( 'Image Resolution', 'piller' ),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'default'     => 'thumbnail',
                'options'     => $options,
            ]
        ); 

        piller_switcher_fields( $this, 'show_post_meta_icons', 'Display Post Meta Icons?' );
        piller_switcher_fields( $this, 'show_author', 'Display Post Author?' );
        piller_switcher_fields( $this, 'show_date', 'Display Post Date?' );
        piller_switcher_fields( $this, 'show_category', 'Display Post Category?' );
        piller_switcher_fields( $this, 'show_comment', 'Display Post Comment?' );
        piller_switcher_fields( $this, 'show_min_read', 'Display Read Minute?' );

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//--------------------------------------- 

		//-------Title Style-------
		piller_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a' );
		piller_common_style_fields( $this, '02', 'Content', '{{WRAPPER}} .box-text' );

		//------Button Style-------
		piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn', ['1', '2'] );


    }

    public function piller_get_categories() {
        $cats = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));

        $cat = [];

        foreach( $cats as $singlecat ) {
            $cat[$singlecat->term_id] = __($singlecat->name,'piller');
        }

        return $cat;
    }

    public function piller_get_tags() {
        $tags = get_terms(array(
            'taxonomy' => 'post_tag',
            'hide_empty' => true,
        ));

        $tag = [];

        foreach( $tags as $singletag ) {
            $tag[$singletag->term_id] = __($singletag->name,'piller');
        }

        return $tag;
    }

    // Get Specific Post
    public function piller_post_id(){
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => -1,
        );

        $piller_post = new WP_Query( $args );

        $postarray = [];

        while( $piller_post->have_posts() ){
            $piller_post->the_post();
            $postarray[get_the_Id()] = get_the_title();
        }
        wp_reset_postdata();
        return $postarray;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $post_display_type = $settings['post_display_type'];
        $include_exclude_option = isset($settings['include_exclude_option']) ? $settings['include_exclude_option'] : 'exclude';
        $blog_posts = !empty($settings['blog_posts']) ? $settings['blog_posts'] : [];
        $blog_categories = !empty($settings['blog_categories']) ? $settings['blog_categories'] : [];
        $blog_tags = !empty($settings['blog_tags']) ? $settings['blog_tags'] : [];
        
        // Default query arguments
        $args = [
            'post_type'             => 'post',
            'posts_per_page'        => !empty($settings['blog_post_count']) ? esc_attr($settings['blog_post_count']) : 3,
            'order'                 => !empty($settings['blog_post_order']) ? esc_attr($settings['blog_post_order']) : 'DESC',
            'orderby'               => !empty($settings['blog_post_order_by']) ? esc_attr($settings['blog_post_order_by']) : 'ID',
            'ignore_sticky_posts'   => true,
        ];
        
        // Modify query based on `post_display_type` and `include_exclude_option`
        if ($post_display_type === 'all') {
            if ($include_exclude_option === 'include') {
                if (!empty($blog_posts)) {
                    $args['post__in'] = $blog_posts;
                }
                if (!empty($blog_categories)) {
                    $args['category__in'] = $blog_categories;
                }
                if (!empty($blog_tags)) {
                    $args['tag__in'] = $blog_tags;
                }
            } elseif ($include_exclude_option === 'exclude') {
                if (!empty($blog_posts)) {
                    $args['post__not_in'] = $blog_posts;
                }
                if (!empty($blog_categories)) {
                    $args['category__not_in'] = $blog_categories;
                }
                if (!empty($blog_tags)) {
                    $args['tag__not_in'] = $blog_tags;
                }
            }
        } elseif ($post_display_type === 'category') {
            // Show posts only from selected categories
            $args['category__in'] = $blog_categories;

        } elseif ($post_display_type === 'tags') {
            // Show posts only from selected tags
            $args['tag__in'] = $blog_tags;
            
        }
        
        // Create the WP_Query
        $blogpost = new WP_Query($args);     
        
        // Get the dynamic image resolution setting
        $image_resolution = !empty($settings['image_resolution']) ? $settings['image_resolution'] : 'piller-shop-small-image';
        

		if( $settings['layout_style'] == '3'  ){
            echo '<div class="row gy-40 gx-30">';
            $counter = 0;
            
            while ( $blogpost->have_posts() ) {
                $counter++;
                $blogpost->the_post();
                $categories = get_the_category();
                $content = get_the_content();
                $title_count = $settings['title_count'];
                $excerpt_count = $settings['excerpt_count'];
                $title_count2 = $settings['title_count2'];
                $excerpt_count2 = $settings['excerpt_count2'];
            
                if ( $counter == 1 ) {
                    echo '<div class="col-lg-6 one">';
                        echo '<div class="blog-card style-3 fadeinup wow" data-wow-delay="0.3s">';
                            echo '<div class="blog-img">';
                                echo '<a href="'.esc_url( get_permalink() ).'">';
                                    the_post_thumbnail('piller_795X290' );
                                echo '</a>';
                            echo '</div>';
                            echo '<div class="blog-content pe-xl-5">';
                                echo '<div class="blog-meta">';
                                    if ( ! empty( $settings['show_date'] ) ) {
                                        echo '<a href="'.esc_url( piller_blog_date_permalink() ).'">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-regular fa-calendar"></i>';
                                            }
                                            echo esc_html( get_the_date() );
                                        echo '</a>';
                                    }
                                    if ( ! empty( $settings['show_category'] ) && ! empty( $categories ) ) {
                                        echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-solid fa-tag"></i>';
                                            }
                                            echo esc_html( $categories[0]->name );
                                        echo '</a>';
                                    }
                                    if ( ! empty( $settings['show_comment'] ) ) {
                                        $comment = ( get_comments_number() == 1 ) ? ' Comment ' : ' Comments ';
                                        echo '<a href="#">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-solid fa-comment"></i>';
                                            }
                                            echo get_comments_number() . esc_html__( $comment, 'piller' );
                                        echo '</a>';
                                    }
                                    if ( ! empty( $settings['show_min_read'] ) && function_exists( 'piller_get_reading_time' ) ) {
                                        echo '<a href="#">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-solid fa-clock"></i>';
                                            }
                                            echo piller_get_reading_time( get_the_ID() );
                                        echo '</a>';
                                    }
                                echo '</div>';
                                echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title(), $title_count2, '' ) ).'</a></h3>';
                                if ( ! empty( $content ) && ! empty( $excerpt_count2 ) ) {
                                    echo '<p class="box-text">'.esc_html( wp_trim_words( $content, $excerpt_count2, '' ) ).'</p>';
                                }
                                echo '<div class="blog-bottom">';
                                    if ( ! empty( $settings['show_author'] ) ) {
                                        echo '<div class="blog-auth">';
                                            echo '<div class="avater">';
                                                echo get_avatar( get_the_author_meta( 'ID' ), 40 );
                                            echo '</div>';
                                            echo '<div class="media-body">';
                                                echo '<p class="desig">'.esc_html__( 'Written by', 'piller' ).'</p>';
                                                echo '<h5 class="name"><a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'">'.esc_html( ucwords( get_the_author() ) ).'</a></h5>';
                                            echo '</div>';
                                        echo '</div>'; // blog-auth
                                    }
                                    if ( ! empty( $settings['button_text'] ) ) {
                                        echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn radius outline">'.esc_attr( $settings['button_text'] ).'</a>';
                                    }
                                echo '</div>'; // blog-bottom
                            echo '</div>'; // blog-content
                        echo '</div>'; // blog-card
                    echo '</div>'; // col-lg-6 one
            
                    // Start second+third post wrapper
                    echo '<div class="col-lg-6">';
                        echo '<div class="blog-3-right-wrap">';
            
                } elseif ( $counter == 2 || $counter == 3 ) {
                    if($counter == 2){
                        $ani = '0.5s';
                    }else{
                        $ani = '0.7s';
                    }
                    // 2nd and 3rd post inside blog-3-right-wrap
                    echo '<div class="blog-card style-3 grid-style two fadeinright wow" data-wow-delay="'.esc_attr($ani).'">';
                        echo '<div class="blog-img">';
                            echo '<a href="'.esc_url( get_permalink() ).'">';
                                the_post_thumbnail( $image_resolution );
                            echo '</a>';
                        echo '</div>';
                        echo '<div class="blog-content">';
                            echo '<div class="blog-meta">';
                                if ( ! empty( $settings['show_date'] ) ) {
                                    echo '<a href="'.esc_url( piller_blog_date_permalink() ).'">';
                                        if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                            echo '<i class="fa-regular fa-calendar"></i>';
                                        }
                                        echo esc_html( get_the_date() );
                                    echo '</a>';
                                }
                                if ( ! empty( $settings['show_category'] ) && ! empty( $categories ) ) {
                                    echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'">';
                                        if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                            echo '<i class="fa-solid fa-tag"></i>';
                                        }
                                        echo esc_html( $categories[0]->name );
                                    echo '</a>';
                                }
                                if ( ! empty( $settings['show_comment'] ) ) {
                                    $comment = ( get_comments_number() == 1 ) ? ' Comment ' : ' Comments ';
                                    echo '<a href="#">';
                                        if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                            echo '<i class="fa-solid fa-comment"></i>';
                                        }
                                        echo get_comments_number() . esc_html__( $comment, 'piller' );
                                    echo '</a>';
                                }
                                if ( ! empty( $settings['show_min_read'] ) && function_exists( 'piller_get_reading_time' ) ) {
                                    echo '<a href="#">';
                                        if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                            echo '<i class="fa-solid fa-clock"></i>';
                                        }
                                        echo piller_get_reading_time( get_the_ID() );
                                    echo '</a>';
                                }
                            echo '</div>';
                            echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title(), $title_count, '' ) ).'</a></h3>';
                            if ( ! empty( $content ) && ! empty( $excerpt_count ) ) {
                                echo '<p class="box-text">'.esc_html( wp_trim_words( $content, $excerpt_count, '' ) ).'</p>';
                            }
                            echo '<div class="blog-bottom">';
                                if ( ! empty( $settings['show_author'] ) ) {
                                    echo '<div class="blog-auth">';
                                        echo '<div class="avater">';
                                            echo get_avatar( get_the_author_meta( 'ID' ), 40 );
                                        echo '</div>';
                                        echo '<div class="media-body">';
                                            echo '<p class="desig">'.esc_html__( 'Written by', 'piller' ).'</p>';
                                            echo '<h5 class="name"><a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'">'.esc_html( ucwords( get_the_author() ) ).'</a></h5>';
                                        echo '</div>';
                                    echo '</div>'; // blog-auth
                                }
                                if ( ! empty( $settings['button_text'] ) ) {
                                    echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn radius outline">'.esc_attr( $settings['button_text'] ).'</a>';
                                }
                            echo '</div>'; // blog-bottom
                        echo '</div>'; // blog-content
                    echo '</div>'; // blog-card
            
                    if ( $counter == 3 ) {
                        echo '</div>'; // Close blog-3-right-wrap
                    echo '</div>'; // Close col-lg-6
                    }
            
                } else {
                    // From 4th post onwards
                    echo '<div class="col-lg-6 one">';
                        echo '<div class="blog-card style-3 grid-style two fadeinup wow" data-wow-delay="0.9s">';
                            echo '<div class="blog-img">';
                                echo '<a href="'.esc_url( get_permalink() ).'">';
                                    the_post_thumbnail( $image_resolution );
                                echo '</a>';
                            echo '</div>';
                            echo '<div class="blog-content">';
                                echo '<div class="blog-meta">';
                                    if ( ! empty( $settings['show_date'] ) ) {
                                        echo '<a href="'.esc_url( piller_blog_date_permalink() ).'">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-regular fa-calendar"></i>';
                                            }
                                            echo esc_html( get_the_date() );
                                        echo '</a>';
                                    }
                                    if ( ! empty( $settings['show_category'] ) && ! empty( $categories ) ) {
                                        echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-solid fa-tag"></i>';
                                            }
                                            echo esc_html( $categories[0]->name );
                                        echo '</a>';
                                    }
                                    if ( ! empty( $settings['show_comment'] ) ) {
                                        $comment = ( get_comments_number() == 1 ) ? ' Comment ' : ' Comments ';
                                        echo '<a href="#">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-solid fa-comment"></i>';
                                            }
                                            echo get_comments_number() . esc_html__( $comment, 'piller' );
                                        echo '</a>';
                                    }
                                    if ( ! empty( $settings['show_min_read'] ) && function_exists( 'piller_get_reading_time' ) ) {
                                        echo '<a href="#">';
                                            if ( ! empty( $settings['show_post_meta_icons'] ) ) {
                                                echo '<i class="fa-solid fa-clock"></i>';
                                            }
                                            echo piller_get_reading_time( get_the_ID() );
                                        echo '</a>';
                                    }
                                echo '</div>';
                                echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title(), $title_count, '' ) ).'</a></h3>';
                                if ( ! empty( $content ) && ! empty( $excerpt_count ) ) {
                                    echo '<p class="box-text">'.esc_html( wp_trim_words( $content, $excerpt_count, '' ) ).'</p>';
                                }
                                echo '<div class="blog-bottom">';
                                    if ( ! empty( $settings['show_author'] ) ) {
                                        echo '<div class="blog-auth">';
                                            echo '<div class="avater">';
                                                echo get_avatar( get_the_author_meta( 'ID' ), 40 );
                                            echo '</div>';
                                            echo '<div class="media-body">';
                                                echo '<p class="desig">'.esc_html__( 'Written by', 'piller' ).'</p>';
                                                echo '<h5 class="name"><a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'">'.esc_html( ucwords( get_the_author() ) ).'</a></h5>';
                                            echo '</div>';
                                        echo '</div>'; // blog-auth
                                    }
                                    if ( ! empty( $settings['button_text'] ) ) {
                                        echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn radius outline">'.esc_attr( $settings['button_text'] ).'</a>';
                                    }
                                echo '</div>'; // blog-bottom
                            echo '</div>'; // blog-content
                        echo '</div>'; // blog-card
                    echo '</div>'; // col-lg-6 one
                }
            }
            
            wp_reset_postdata();
            echo '</div>'; // Close row
            

		}elseif( $settings['layout_style'] == '4'  ){


        }else{
            if( $settings['layout_style'] == '2'  ){
                $style = ' ';
            }else{
                $style = 'style-2';
            }

            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="blogSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}, "autoHeight": "true"}\'>';
                    echo '<div class="swiper-wrapper">';
                        while( $blogpost->have_posts() ){
                            $blogpost->the_post(); 
                            $categories = get_the_category();
                            $content = get_the_content();
                            $title_count =  $settings['title_count'];
                            $excerpt_count =  $settings['excerpt_count'];

                            echo '<div class="swiper-slide">';
                                echo '<div class="blog-card '.esc_attr($style).'">';
                                    echo '<div class="blog-img">';
                                        echo '<a href="'.esc_url( get_permalink() ).'">';
                                            the_post_thumbnail( $image_resolution );
                                        echo '</a>';
                                        if ( ! empty( $settings['show_date'] ) ) {
                                            echo '<div class="date">';
                                                echo '<a href="' . esc_url( get_permalink() ) . '">';
                                                    echo '<span>' . get_the_date( 'd' ) . '</span> <span>' . get_the_date( 'M' ) . '</span>';
                                                echo '</a>';
                                            echo '</div>';
                                        }                                    
                                    echo '</div>';
                                    echo '<div class="blog-content">';
                                        echo '<div class="blog-meta">';
                                            if(!empty($settings['show_author'])){
                                                echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'">';
                                                    if(!empty($settings['show_post_meta_icons'])){
                                                        echo '<i class="fa-solid fa-user"></i>';
                                                    }
                                                    echo esc_html__('By ', 'piller') . esc_html( ucwords( get_the_author() ) );
                                                echo '</a>';
                                            }
                                            if(!empty($settings['show_category'])){
                                                if(!empty($categories)){
                                                    echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'">';
                                                        if(!empty($settings['show_post_meta_icons'])){
                                                            echo '<i class="fa-solid fa-tag"></i>';
                                                        }
                                                        echo esc_html( $categories[0]->name );
                                                    echo '</a>';
                                                }
                                            }
                                            if(!empty($settings['show_comment'])){
                                                $commnet = (get_comments_number() == 1) ? ' Comment ':' Comments ';
                                                echo '<a href="#">';
                                                    if(!empty($settings['show_post_meta_icons'])){
                                                        echo '<i class="fa-solid fa-comment"></i>';
                                                    }
                                                    echo get_comments_number() . esc_html__($commnet, 'piller');
                                                echo '</a>';
                                            }
                                            if(!empty($settings['show_min_read'])){
                                                echo '<a href="#">';
                                                    if (function_exists('piller_get_reading_time')) {
                                                        if(!empty($settings['show_post_meta_icons'])){
                                                            echo '<i class="fa-solid fa-clock"></i>';
                                                        }
                                                        echo piller_get_reading_time(get_the_ID());
                                                    }
                                                echo '</a>';
                                            }
                                        echo '</div>';
                                        echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ),  $title_count , '' ) ).'</a></h3>';
                                        if ( ! empty( $content && $excerpt_count ) ) {
                                            echo '<p class="box-text pb-4">' . esc_html( wp_trim_words( $content, $excerpt_count , '' ) ) . '</p>';
                                        }
                                        if(!empty($settings['button_text'])){
                                            echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn pill style3">'.esc_attr($settings['button_text']).'</a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }wp_reset_postdata(); 
                    echo '</div>';
                echo '</div>';

                echo '<button data-slider-prev="#blogSlider1" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#blogSlider1" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

        }
	
      
	}
}