<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Category Widget .
 *
 */
class Piller_Category extends Widget_Base {

	public function get_name() {
		return 'pillercategory';
	}
	public function get_title() {
		return __( 'Category', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Category', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two' ] );

		$repeater = new Repeater();

		piller_media_fields($repeater, 'choose_icon', 'Choose Icon');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Apartment');
		piller_general_fields($repeater, 'description', 'Description', 'TEXTAREA2', '12 Property'); 
		piller_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'category_list',
			[
				'label' 		=> __( 'Category Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Apartment', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common2_style_fields( $this, '02', 'Title', '{{WRAPPER}} .box-title a', ['1'] );
		piller_common_style_fields( $this, '03', 'Description', '{{WRAPPER}} .box-subtitle', ['1'] );


	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){ 
            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider" id="categorySlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"400":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"}, "1300":{"slidesPerView":"6"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['category_list'] as $key => $data ){
                            echo '<div class="swiper-slide">';
                                echo '<div class="category-card">';
                                    if(!empty($data['choose_icon']['url'])){
                                        echo '<div class="box-icon">';
                                            echo piller_img_tag( array(
                                                'url'   => esc_url( $data['choose_icon']['url'] ),
                                            ));
                                        echo '</div>';
                                    }
                                    if(!empty($data['title'])){
                                        echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
                                    }
                                    if(!empty($data['description'])){
                                        echo '<p class="box-subtitle">'.esc_html($data['description']).'</p>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider" id="categorySlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"400":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"5"}, "1300":{"slidesPerView":"6"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['category_list'] as $key => $data ){
                            echo '<div class="swiper-slide">';
                                echo '<div class="category-card style-2">';
                                    if(!empty($data['choose_icon']['url'])){
                                        echo '<div class="box-icon">';
                                            echo piller_img_tag( array(
                                                'url'   => esc_url( $data['choose_icon']['url'] ),
                                            ));
                                        echo '</div>';
                                    }
                                    if(!empty($data['title'])){
                                        echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
                                    }
                                    if(!empty($data['description'])){
                                        echo '<p class="box-subtitle">'.esc_html($data['description']).'</p>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                    echo '<div class="slider-pagination style-2"></div>';
                echo '</div>';
            echo '</div>';

		}
		
			
	}
}