
<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Info Widget .
 *
 */
class Piller_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'pillercontactinfo';
	}
	public function get_title() {
		return __( 'Contact Info', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() { 

		$this->start_controls_section(
			'title_section',
			[
				'label' 	=> __( 'Contact Info', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two' ] );

		$repeater = new Repeater();

		piller_general_fields($repeater, 'icon', 'Icon', 'TEXTAREA2', '');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Label');
		piller_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', 'Content');
		
		$this->add_control(
			'contact_lists',
			[
				'label' 		=> __( 'Contact Info', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Label', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => [ '1' ]
				]
			]
		);

		$repeater = new Repeater();

		piller_general_fields($repeater, 'icon', 'Icon', 'TEXTAREA2', '');
		piller_general_fields($repeater, 'content', 'Content', 'TEXTAREA', 'Content');
		
		$this->add_control(
			'contact_lists2',
			[
				'label' 		=> __( 'Contact Info', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'content' 	=> __( 'Label', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => [ '2' ]
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '011', 'Label', '{{WRAPPER}} .contact-feature_label', ['1'] );
		piller_common_style_fields( $this, '022', 'Content', '{{WRAPPER}} .desc, {{WRAPPER}} .desc a', ['1', '2'] );
		
	}

	protected function render() {

        $settings = $this->get_settings_for_display(); 
			
		if( $settings['layout_style'] == '1' ){
            echo '<div class="row gy-4 justify-content-center">';
				foreach( $settings['contact_lists'] as $key => $data ){
					$delay = number_format(0.1 + ($key * 0.2), 1);
					
					echo '<div class="col-xl-4 col-lg-6 contact-feature-wrap fadeinup wow" data-wow-delay="'.esc_attr($delay).'s">';
						echo '<div class="contact-feature">';
							if(!empty($data['icon'])){
								echo '<div class="contact-feature-icon">'.wp_kses_post($data['icon']).'</div>';
							}
							echo '<div class="media-body">';
								if(!empty($data['title'])){
									echo '<p class="contact-feature_label">'.esc_html($data['title']).'</p>';
								}
								if(!empty($data['desc'])){
									echo '<div class="info-box_text desc">'.wp_kses_post($data['desc']).'</div>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="widget bg-smoke faq">';
				echo '<div class="th-widget-contact">';
					foreach( $settings['contact_lists2'] as $data ){
						echo '<div class="info-box">';
							if(!empty($data['icon'])){
								echo '<div class="info-box_icon">'.wp_kses_post($data['icon']).'</div>';
							}
							if(!empty($data['content'])){
								echo '<div class="info-box_text desc">'.wp_kses_post($data['content']).'</div>';
							}
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}
       

	}

}
