<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * download Widget .
 *
 */
class Piller_Download extends Widget_Base {

	public function get_name() {
		return 'pillerdownload';
	}
	public function get_title() {
		return __( 'Download', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Downloads', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One'] );

		piller_media_fields( $this, 'image', 'Choose Image' );
		piller_media_fields( $this, 'image2', 'Choose Image', ['1'] );
		piller_media_fields( $this, 'image3', 'Choose Image', ['1'] );

		piller_general_fields($this, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Download APP');
		piller_general_fields($this, 'title', 'Title', 'TEXTAREA2', 'Scan QR for get latest Properties Over the time');
		piller_general_fields($this, 'desc', 'Description', 'TEXTAREA2', '');

		piller_media_fields( $this, 'app', 'Choose Image', ['1'] );
		piller_media_fields( $this, 'shape', 'Choose Shape', ['1'] );

		piller_media_fields( $this, 'arrow', 'Choose Arrow', ['1'] );
		piller_general_fields($this, 'arrow_text', 'Arrow Text', 'TEXTAREA2', 'Scan to Download');

		$repeater = new Repeater();

		piller_media_fields( $repeater, 'icon', 'Choose Icon' );
		piller_general_fields( $repeater, 'label', 'Label', 'TEXTAREA2', 'Label');
		piller_general_fields( $repeater, 'title', 'Title', 'TEXTAREA2', 'Title');
		piller_url_fields( $repeater, 'button_url', 'Button URL');
		piller_media_fields( $repeater, 'qr', 'Choose QR Icon' );

		$this->add_control(
			'download_lists',
			[
				'label' 		=> __( 'Download', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Label', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$repeater = new Repeater();

		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Label');
		piller_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'download',
			[
				'label' 		=> __( 'Download', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Label', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		piller_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .widget_title' );


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="row gy-4">'; 
				echo '<div class="col-xl-4 col-lg-6">';
					echo '<div class="download-2-thumbs fadeinup wow" data-wow-duration="1.5s" data-wow-delay="0.3s">';
						if(!empty($settings['image']['url'])){
							echo '<div class="top">';
								echo piller_img_tag( array(
									'url'   => esc_url( $settings['image']['url'] ),
								));
							echo '</div>';
						}
						echo '<div class="bottom">';
							if(!empty($settings['image2']['url'])){
								echo '<div class="left">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['image2']['url'] ),
									));
								echo '</div>';
							}
							if(!empty($settings['image3']['url'])){
								echo '<div class="right">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['image3']['url'] ),
									));
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				echo '<div class="col-xl-5 col-lg-6">';
					echo '<div class="title-area download-2 text-center">';
						if($settings['subtitle']){
							echo '<p class="sub-title text-anime-style-1"><span class="double-line"></span>'.wp_kses_post($settings['subtitle']).'</p>';
						}
						if($settings['title']){
							echo '<h2 class="sec-title text-anime-style-2 mb-4">'.wp_kses_post($settings['title']).'</h2>';
						}
						if($settings['desc']){
							echo '<p class="box-text text-anime-style-3">'.wp_kses_post($settings['desc']).'</p>';
						}
					echo '</div>';

					echo '<div class="scan-download-2-wrap">';
						echo '<div class="scan-download-item-wrap">';
							echo '<div class="scan-download-card-wrap">';
								echo '<div class="scan-download-card">';
									if($settings['arrow_text']){
										echo '<h5 class="download-text">'.wp_kses_post($settings['arrow_text']).'</h5>';
									}
									if(!empty($settings['arrow']['url'])){
										echo '<div class="scan-2-arrow">';
											echo piller_img_tag( array(
												'url'   => esc_url( $settings['arrow']['url'] ),
											));
										echo '</div>';
									}
								echo '</div>';
							echo '</div>';
							foreach( $settings['download_lists'] as $data ){
								echo '<div class="scan-download-item scan">';
									if(!empty($data['icon']['url'])){
										echo '<div class="scan-download-item__thumb">';
											echo piller_img_tag( array(
												'url'   => esc_url( $data['icon']['url'] ),
											));
										echo '</div>';
									}
									echo '<div class="scan-download-item__content">';
										if(!empty($data['label'])){
											echo '<p>'.esc_html($data['label']).'</p>';
										}
										if ( ! empty( $data['title'] ) ) {
											$attrs = '';
										
											if ( ! empty( $data['button_url']['is_external'] ) ) {
												$attrs .= ' target="_blank"';
											}
											if ( ! empty( $data['button_url']['nofollow'] ) ) {
												$attrs .= ' rel="nofollow"';
											}
										
											echo '<h4 class="box-title"><a href="' . esc_url( $data['button_url']['url'] ) . '"' . $attrs . '>' . esc_html( $data['title'] ) . '</a></h4>';
										}

									echo '</div>'; 
									if(!empty($data['qr']['url'])){
										echo '<div class="scan-download-item__right">';
											echo piller_img_tag( array(
												'url'   => esc_url( $data['qr']['url'] ),
											));
										echo '</div>';
									}
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				echo '<div class="col-xl-3 col-lg-6">';
					if(!empty($settings['app']['url'])){
						echo '<div class="download-thumb style-2 fadeinup wow" data-wow-delay="0.5s">';
							echo piller_img_tag( array(
								'url'   => esc_url( $settings['app']['url'] ),
							));
							if(!empty($settings['shape']['url'])){
								echo '<div class="download-2-round-bg">';
									echo piller_img_tag( array(
										'url'   => esc_url( $settings['shape']['url'] ),
									));
								echo '</div>';
							}
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="widget widget_download  ">';
				if($settings['title']){
					echo '<h4 class="widget_title style2">'.wp_kses_post($settings['title']).'</h4>';
				}
				echo '<div class="download-media-wrap">';
					foreach( $settings['download_list'] as $data ){
						// Get the file URL
						$file_url = esc_url( $data['button_url']['url'] );
						// Parse the URL to extract the file extension
						$file_extension = pathinfo( parse_url( $file_url, PHP_URL_PATH ), PATHINFO_EXTENSION );
						// Define allowed file extensions for download
						$allowed_extensions = ['pdf', 'zip', 'jpg', 'jpeg', 'png', 'docx', 'xlsx'];

						// Check if the file extension is in the allowed list
						$download_attr = in_array( strtolower( $file_extension ), $allowed_extensions ) ? ' download' : '';

						echo '<div class="download-media">';
							echo '<div class="download-media_info">';
								echo '<h5 class="download-media_title">'.esc_html( $data['title'] ).'</h5>';
							echo '</div>';
							echo '<a href="'.esc_url( $file_url ).'" class="download-media_btn"'. $download_attr .'><i class="far fa-arrow-right"></i></a>';
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}
	

	}

}