<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Gallery Widget .
 *
 */
class Piller_Gallery extends Widget_Base {

	public function get_name() {
		return 'pillergallery';
	}
	public function get_title() {
		return __( 'Gallery', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'gallery_section',
			[
				'label' 	=> __( 'Gallery', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        ); 

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four' ] );

		piller_general_fields($this, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Instagram', ['2']);
		piller_general_fields($this, 'title', 'Title', 'TEXTAREA2', 'Nice Gallery', ['2']);

		piller_switcher_fields($this, 'show_all', 'Show All Tab?', ['4'] );
		piller_general_fields($this, 'all_title', 'All Tab Text', 'TEXT', 'View All', ['4'] );

		$repeater = new Repeater();

		piller_media_fields($repeater, 'image', 'Choose Image');
		
		$this->add_control(
			'gallery_lists',
			[
				'label' 		=> __( 'Gallery Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$repeater = new Repeater();

		piller_media_fields($repeater, 'image', 'Choose Image');
		piller_general_fields($repeater, 'icon', 'Icon', 'TEXTAREA2', '<i class="fab fa-instagram"></i>');

		$this->add_control(
			'gallery_lists2',
			[
				'label' 		=> __( 'Gallery Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['2', '3']
				]
			]
		);

		$repeater = new Repeater();

		piller_general_fields($repeater, 'tab_title', 'Tab Title', 'TEXT', 'Apartment');
		piller_general_fields($repeater, 'tab_id', 'Filter Tab ID', 'TEXT', 'cat1');

		$this->add_control(
			'gallery_tab',
			[
				'label' 		=> __( 'Gallery Tab', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'tab_title' 		=> __( 'Apartment', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['4']
				]
			]
		);

		$repeater = new Repeater();

		piller_general_fields($repeater, 'tab_id2', 'Filter Content ID', 'TEXT', 'cat1');
		piller_media_fields($repeater, 'image', 'Choose Image');
		piller_general_fields($repeater, 'icon', 'Icon', 'TEXTAREA2', '<i class="fab fa-instagram"></i>');

		$this->add_control(
			'gallery_lists4',
			[
				'label' 		=> __( 'Gallery Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['4']
				]
			]
		);

		piller_general_fields($this, 'title2', 'Title', 'TEXTAREA2', 'Charming Beach House', ['1']);
        piller_general_fields($this, 'price', 'price', 'TEXT', '$179,800.00', ['1']);
        piller_general_fields($this, 'content', 'Content', 'TEXTAREA', 'We Help you find the best places and offer near you.', ['1']);
	
		$repeater = new Repeater();

		piller_media_fields($repeater, 'icon', 'Choose Icon');
		piller_general_fields($repeater, 'content', 'Icon', 'TEXTAREA2', 'Conntent');

		$this->add_control(
			'features',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

        piller_general_fields($this, 'button_text', 'Button Text', 'TEXT', 'View More', ['1']);
		piller_url_fields($this, 'button_url', 'Button URL', ['1']);

		$this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

        piller_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a', ['1'] );
		piller_common_style_fields( $this, '02', 'Price', '{{WRAPPER}} .price', ['1'] );
		piller_common_style_fields( $this, '03', 'Content', '{{WRAPPER}} .box-text', ['1'] );
		piller_common_style_fields( $this, '04', 'Features', '{{WRAPPER}} .property-featured li', ['1'] );

        piller_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th-btn', ['1'] );

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="explore-single-item">';
				echo '<div class="main-container">';
					echo '<div class="swiper th-slider panoramaSlide1" id="panoramaSlide1" data-slider-options=\'{"effect":"fade", "autoplay": false, "loop": true, "speed": 1000, "allowTouchMove": false, "simulateTouch": false}\'>';
						echo '<div class="swiper-wrapper">';
							foreach ( $settings['gallery_lists'] as $data ){
								echo '<div class="swiper-slide">';
									echo '<div class="explore-single-slide" id="panorama1">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										));
									echo '</div>';
								echo '</div>';
							} 
						echo '</div>';
						echo '<button data-slider-prev="#panoramaSlide1" class="slider-arrow slider-prev style3"><i class="far fa-arrow-left"></i></button>';
						echo '<button data-slider-next="#panoramaSlide1" class="slider-arrow slider-next style3"><i class="far fa-arrow-right"></i></button>';
					echo '</div>';
				echo '</div>';

				echo '<div class="icon-wrap add-explore-city-icon">';
					echo '<div class="animation">';
						echo '<i class="fa-solid fa-plus"></i>';
					echo '</div>';
				echo '</div>';

				echo '<div class="popular-list-1 explore-card"> ';
					echo '<div class="property-content">';
						echo '<div class="media-body">';
							if(!empty($settings['title2'])){
								echo '<h3 class="box-title"><a href="'.esc_url( $settings['button_url']['url'] ).'">'.esc_html($settings['title2']).'</a></h3>';
							}
							if(!empty($settings['price'])){
								echo '<h5 class="price">'.wp_kses_post($settings['price']).'</h5>';
							}
							if(!empty($settings['content'])){
								echo '<p class="box-text">'.wp_kses_post($settings['content']).'</p>';
							}
						echo '</div>';

						echo '<div class="bottom-wrap">';
							echo '<ul class="property-featured">';
								foreach( $settings['features'] as $data ){
									echo '<li>';
										if(!empty($data['icon']['url'])){
											echo '<div class="icon">';
												echo piller_img_tag( array(
													'url'   => esc_url( $data['icon']['url'] ),
												));
											echo '</div>';
										}
										echo esc_html($data['content']);
									echo '</li>';
								}
							echo '</ul>';
							if(!empty($settings['button_text'])){
								echo '<div class="property-bottom">';
									echo '<a class="th-btn sm style3 pill" href="'.esc_url( $settings['button_url']['url'] ).'">'.esc_html($settings['button_text']).'</a>';
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';

			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="footer-bottom-community">';
				echo '<div class="content">';
					if($settings['subtitle']){
						echo '<p>'.esc_html($settings['subtitle']).'</p>';
					}
					if($settings['title']){
						echo '<h4 class="box-title">'.esc_html($settings['title']).'</h4>';
					}
				echo '</div>';
				echo '<div class="footer-gallery-wrapper">';
					foreach ( $settings['gallery_lists2'] as $data ){
						echo '<div class="simple-gallery-card">';
							echo '<div class="gallery-img">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								));
								if(!empty($data['icon'])){
									echo '<a href="'.esc_url( $data['image']['url'] ).'" class="icon-btn popup-image">'.wp_kses_post($data['icon']).'</a>';
								}
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-4">'; 
				$class = ['col-xl-7', 'col-xl-5', 'col-xl-5', 'col-xl-7'];
				foreach ( $settings['gallery_lists2'] as $key => $data ){
					$current_class = $class[$key % count($class)];
					echo '<div class="'.esc_attr($current_class).'">';
						echo '<div class="property-gallery-card">';
							echo '<div class="property-gallery-card-img">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
									'class' => 'w-100',
								));
							echo '</div>';
							echo '<a class="icon-btn popup-image" href="'.esc_url( $data['image']['url'] ).'">'.wp_kses_post($data['icon']).'</a>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '4' ){
            echo '<div class="row justify-content-center">';
                echo '<div class="col-xl-7"> ';
                    echo '<div class="title-area text-center mb-2">';
                        echo '<div class="filter-menu style-2 indicator-active filter-menu-active mt-2 justify-content-center fadeinup wow" data-wow-duration="1.5s" data-wow-delay="0.5s">';
							if(!empty($settings['show_all'])){
								$active = '';
								if(!empty($settings['all_title'])){
									$title = $settings['all_title'];
								}else{
									$title = 'All';
								}
								echo '<button data-filter="*" class="th-btn tab-btn active" type="button">'.esc_html($title).'</button>';
							}else{
								$active = 'active';
							}
							foreach( $settings['gallery_tab'] as $key => $data ){
								$id = strtolower($data['tab_id']);
								$active_class = ($key == 0) ? $active : '';
								echo '<button data-filter=".'.esc_attr($id).'" class="th-btn tab-btn '.esc_attr($active_class).'" type="button">'.esc_html($data['tab_title']).'</button>';
							}
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

			echo '<div class="row gy-4 justify-content-center filter-active">';
				foreach ( $settings['gallery_lists4'] as $data ){
					$id = strtolower($data['tab_id2']);
					echo '<div class="col-lg-4 col-xl-4 col-md-6 col-xxl-auto filter-item '.esc_attr($id).'">';
						echo '<div class="gallery-card2">';
							echo '<div class="gallery-img">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								));
								if(!empty($data['icon'])){
									echo '<a href="'.esc_url( $data['image']['url'] ).'" class="popular-popup-image">'.wp_kses_post($data['icon']).'</a>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}

		
	}

}