<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Piller_Image extends Widget_Base {

	public function get_name() {
		return 'pillerimage';
	}
	public function get_title() {
		return __( 'Image', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );

		piller_media_fields( $this, 'image', 'Choose Image' );
		piller_media_fields( $this, 'image2', 'Choose Image', ['1'] );
		piller_media_fields( $this, 'image3', 'Choose Image', ['1'] );
		piller_media_fields( $this, 'image4', 'Choose Image', ['1'] );
		piller_media_fields( $this, 'image5', 'Choose Image', ['1'] );

		piller_media_fields( $this, 'logo_icon', 'Choose Icon', ['1'] );
		piller_general_fields($this, 'circle_text', 'Video Circle Text', 'TEXT', 'PILLAR REAL ESTATE HOME * REAL ESTATE' , ['1'] );

       $this->end_controls_section();

      	//---------------------------------------
			//Style Section Start
		//---------------------------------------	
		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
       
		if( $settings['layout_style'] == '1' ){
			echo '<div class="img-box1 about-1 fadeinup wow" data-wow-duration="1.5s" data-wow-delay="0.3s">';
				echo '<div class="about-logo-wrap-2">';
					echo '<div class="logo-icon-wrap">';
						if(!empty($settings['logo_icon']['url'])){
							echo '<div class="logo-icon">';
								echo piller_img_tag( array(
									'url'   => esc_url( $settings['logo_icon']['url'] ),
								));
							echo '</div>';
						}
						if(!empty($settings['circle_text'])){
							echo '<div class="logo-icon-wrap__text">';
								echo '<span class="logo-animation">'.esc_html($settings['circle_text']).'</span>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<div class="about-left">';
					if(!empty($settings['image4']['url'])){
						echo '<div class="img-box">';
							echo piller_img_tag( array(
								'url'   => esc_url( $settings['image4']['url'] ),
							));
						echo '</div>';
					}
					if(!empty($settings['image5']['url'])){
						echo '<div class="img-box">';
							echo piller_img_tag( array(
								'url'   => esc_url( $settings['image5']['url'] ),
							));
						echo '</div>';
					}
				echo '</div>';
				if(!empty($settings['image']['url'])){
					echo '<div class="about-middle">';
						echo piller_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
							'class' => 'tilt-active'
						));
					echo '</div>';
				}
				echo '<div class="about-right">';
					if(!empty($settings['image2']['url'])){
						echo '<div class="img-box">';
							echo piller_img_tag( array(
								'url'   => esc_url( $settings['image2']['url'] ),
							));
						echo '</div>';
					}
					if(!empty($settings['image3']['url'])){
						echo '<div class="img-box">';
							echo piller_img_tag( array(
								'url'   => esc_url( $settings['image3']['url'] ),
							));
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){


		}elseif( $settings['layout_style'] == '3' ){


		}


	}

}