<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * features Widget .
 *
 */
class Piller_Listing_FloorPlan extends Widget_Base {

	public function get_name() {
		return 'pillerlisitngfloorplan';
	}
	public function get_title() {
		return __( 'Piller Listing Floor Tab', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Floor Tab', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One' ] );

		piller_general_fields($this, 'title', 'Title', 'TEXT', 'Floor Plan', ['1'] );

        $repeater = new Repeater();

		piller_general_fields($repeater, 'label', 'Tab Name', 'TEXTAREA2', 'Tab Name');

		piller_media_fields($repeater, 'choose_image', 'Choose Image');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'First Floor'); 
		piller_general_fields($repeater, 'content', 'Content', 'TEXTAREA', 'Content here'); 

		$this->add_control(
			'feature_lists',
			[
				'label' 		=> __( 'Features Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'label' 	=> __( 'Tab Name', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start 
		//---------------------------------------
		piller_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .page-title', [ '1' ] );

	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){
            echo '<div class="row gy-30 align-items-center justify-content-between mt-10 mb-30">';
                if( !empty( $settings['title'] ) ){
                    echo '<div class="col-lg-auto">';
                        echo '<h3 class="page-title mb-0">'.esc_html( $settings['title'] ).'</h3>';
                    echo '</div>';
                }
                echo '<div class="col-lg-auto">';
                    echo '<ul class="nav nav-tabs property-tab mt-0" role="tablist">';
                        $i = 0;
                        foreach( $settings['feature_lists'] as $data ){
                            $i++;

                            $active_class = $i == 1 ? ' active' : '';
                            $aria_selected = $i == 1 ? ' true' : 'false';

                            if( !empty( $data['label'] ) ){
                                echo '<li class="nav-item" role="presentation">';
                                    echo '<button class="nav-link '.esc_attr( $active_class ).'" id="floor-tab'.esc_attr( $i ).'" data-bs-toggle="tab" data-bs-target="#floor-tab'.esc_attr( $i ).'-pane" type="button" role="tab" aria-controls="floor-tab'.esc_attr( $i ).'-pane" aria-selected="'.esc_attr( $aria_selected ).'">'.esc_html( $data['label'] ).'</button>';
                                echo '</li>';
                            }
                        }
                    echo '</ul>';
                echo '</div>';
            echo '</div>';

            echo '<div class="tab-content">';
                $i = 0;
                foreach( $settings['feature_lists'] as $data ){
                    $i++;
                    $active_class = $i == 1 ? ' show active' : '';
                    echo '<div class="tab-pane fade '.esc_attr( $active_class ).'" id="floor-tab'.esc_attr( $i ).'-pane" role="tabpanel" aria-labelledby="floor-tab'.esc_attr( $i ).'" tabindex="0">';
                        echo '<div class="property-grid-plan">';
                            if(!empty($data['choose_image']['url'])){
                                echo '<div class="property-grid-thumb">';
                                    echo piller_img_tag( array(
                                        'url'   => esc_url( $data['choose_image']['url'] ),
                                    ));
                                echo '</div>';
                            }
                            echo '<div class="property-grid-details">';
                                if( !empty( $data['title'] ) ){
                                    echo '<h4 class="property-grid-title">'.esc_html( $data['title'] ).'</h4>';
                                }
                                if( !empty( $data['content'] ) ){
                                    echo '<p class="property-grid-text">'.wp_kses_post( $data['content'] ).'</p>';
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
            echo '</div>';

		}		
	}
}