<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Gallery Widget .
 *
 */



class Piller_Listing_Gallery extends Widget_Base {

	public function get_name() {
		return 'pillerlistinggallery';
	}
	public function get_title() {
		return __( 'Piller Listing Gallery', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Gallery', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        ); 
		piller_select_field( $this, 'layout_style', 'Layout Style',['Style One','Style Two'] );

		piller_general_fields($this, 'title', 'Title', 'TEXT', 'From Amazing Gallery', ['2'] );
		
		$this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Gallery Slider', 'piller' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$repeater = new Repeater();

		piller_media_fields($repeater, 'image', 'Choose Image');
		piller_general_fields($repeater, 'icon', 'Icon', 'TEXTAREA2', '<i class="fa-solid fa-eye"></i>');

		$this->add_control(
			'gallery2',
			[
				'label' 		=> __( 'Gallery Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		$this->end_controls_section();


		piller_common2_style_fields( $this, 'title', 'Title', '{{WRAPPER}} h3', [ '2' ] );
		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		

	}

	protected function render() {

	$settings = $this->get_settings_for_display();



		if( $settings['layout_style'] == '1' ){
            echo '<div class="slider-area property-slider1">';
                echo '<div class="swiper th-slider panoramaSlide2 mb-4" id="panoramaSlide2" data-slider-options=\'{"effect":"fade","loop":true, "simulateTouch": false,"thumbs":{"swiper":".property-thumb-slider"},"autoplayDisableOnInteraction":"true"}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach ( $settings['gallery'] as $data ){
                            echo '<div class="swiper-slide">';
                                echo '<div class="property-slider-img propery-single-slide" id="panorama1">';
                                    echo piller_img_tag( array(
                                        'url'   => esc_url( $data['url'] ),
                                    ));
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
                echo '<div class="swiper th-slider property-thumb-slider slider-tab" data-slider-options=\'{"effect":"slide","loop":true, "simulateTouch": true,"breakpoints":{"0":{"slidesPerView":2},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}},"autoplayDisableOnInteraction":"true"}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach ( $settings['gallery'] as $data ){
                            echo '<div class="swiper-slide" data-bg-src="">';
                                echo '<div class="tab-btn property-slider-img">';
                                    echo piller_img_tag( array(
                                        'url'   => esc_url( $data['url'] ),
                                    ));
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';

                echo '<button data-slider-prev="#panoramaSlide2" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#panoramaSlide2" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			if(!empty($settings['title'])){
				echo '<h3 class="page-title mt-50 mb-30">'.esc_html( $settings['title'] ).'</h3>';
			}
			
			$flip = true;

			echo '<div class="row gy-4">';
			
			foreach ( array_chunk( $settings['gallery2'], 2 ) as $pair ) {
				if ( $flip ) {
					$cols = ['col-xl-7', 'col-xl-5'];
				} else {
					$cols = ['col-xl-5', 'col-xl-7'];
				}
			
				foreach ( $pair as $index => $data ) {
					echo '<div class="'.esc_attr( $cols[$index] ).'">';
						echo '<div class="property-gallery-card">';
							echo '<div class="property-gallery-card-img">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
									'class' => 'w-100',
								));
							echo '</div>';
							echo '<a class="icon-btn popup-image" href="'.esc_url( $data['image']['url'] ).'">'.wp_kses_post($data['icon']).'</a>';
						echo '</div>';
					echo '</div>';
				}
			
				$flip = !$flip; // alternate layout
			}
			
			echo '</div>'; // Close row once
			

		}


	}
}