<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;


/**
 *
 * Listing Search Widget .
 *
 */
class Piller_Listing_Search extends Widget_Base {

	public function get_name() {
		return 'pillerlistingsearch';
	}
	public function get_title() {
		return __( 'Listing Search', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Listing Search', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );


        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == '1' ){
            echo '<div class="search-area hero-style-1">';
                echo '<div class="container">';
                    echo '<div class="row justify-content-center">';
                        echo '<div class="col-xxl-10">';
                            echo '<div class="search-wrap">';
                                echo do_shortcode( '[directorist_search_listing]' );
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}else{

		
		}
        

	}
}