<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;


/**
 *
 * Listing Slider Widget .
 *
 */
class Piller_Listing_Slider extends Widget_Base {

	public function get_name() {
		return 'pillerlistingslider';
	}
	public function get_title() {
		return __( 'Listing Slider', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller_listing' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Listing Slider', 'piller' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two' ] );

        piller_general_fields( $this, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Popular Properties', ['2'] );
		piller_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Featured Properties', ['2'] );

        piller_url_fields( $this, 'video_url', 'Video URL', ['2'] );

		$repeater = new Repeater();

        piller_general_fields($repeater, 'tag', 'Badge', 'TEXT', 'For Sale');
        piller_media_fields($repeater, 'image', 'Change Image');
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Charming Beach House');
		
        piller_general_fields($repeater, 'location', 'Location', 'TEXTAREA2', '39581 Rohan Estates, New York');
        piller_general_fields($repeater, 'feature', 'Feature Content 1', 'TEXT', 'Bed 4');
        piller_general_fields($repeater, 'feature2', 'Feature Content 2', 'TEXT', 'Bath 2');
        piller_general_fields($repeater, 'feature3', 'Feature Content 3', 'TEXT', '1500 sqft');

        piller_general_fields($repeater, 'price', 'price', 'TEXT', '$179,800.00');
        piller_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'View More');
		piller_url_fields($repeater, 'button_url', 'Button URL');

        piller_media_fields($repeater, 'author', 'Change Author Image');
        piller_general_fields($repeater, 'name', 'Name', 'TEXTAREA2', 'Roberto Ankunding');
		piller_general_fields($repeater, 'designation', 'Designation', 'TEXTAREA2', 'Sale Agent');

		$this->add_control(
			'listing_list',
			[
				'label' 		=> __( 'Listing Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Charming Beach House', 'piller' ), 
					],
				],
				'condition'		=> [ 
					'layout_style' => [ '1', '2'],
				],
			]
		);

        piller_media_fields($this, 'location_icon', 'Change Location Icon');
        piller_media_fields($this, 'feature_icon', 'Change Feature Icon 1');
        piller_media_fields($this, 'feature_icon2', 'Change Feature Icon 2');
        piller_media_fields($this, 'feature_icon3', 'Change Feature Icon 3');

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start 
		//---------------------------------------
		piller_common_style_fields( $this, '011', 'Section Subtitle', '{{WRAPPER}} .sub-title', ['2'] );
		piller_common_style_fields( $this, '012', 'Section Title', '{{WRAPPER}} .sec-title', ['2'] );

        piller_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a' );
		piller_common_style_fields( $this, '02', 'Location', '{{WRAPPER}} .box-text' );
		piller_common_style_fields( $this, '03', 'Features', '{{WRAPPER}} .property-featured li' );
		piller_common_style_fields( $this, '04', 'Price', '{{WRAPPER}} .price' );

        piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn');

        piller_common2_style_fields( $this, '11', 'Name', '{{WRAPPER}} .box-title' );
		piller_common_style_fields( $this, '122', 'Designation', '{{WRAPPER}} .box-text' );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == '1' ){
            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="featuresSlider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"2"},"1400":{"slidesPerView":"2"}}, "autoHeight": "true"}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['listing_list'] as $data ){
                            echo '<div class="swiper-slide">';
                                echo '<div class="popular-list-1 style-2">';
                                    echo '<div class="thumb-wrapper">';
                                        echo piller_img_tag( array(
                                            'url'   => esc_url( $data['image']['url'] ),
                                        ));
                                        if(!empty($data['tag'])){
                                            echo '<div class="popular-badge">';
                                                echo '<img src="'.PILLER_ASSETS.'img/sell_rent_icon.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                echo '<p>'.esc_html($data['tag']).'</p>';
                                            echo '</div>';
                                        }
                                    echo '</div>';
                                    echo '<div class="property-content">';
                                        echo '<div class="media-body">';
                                            if(!empty($data['title'])){
                                                echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
                                            }
                                            echo '<div class="box-text">';
                                                echo '<div class="icon">';
                                                    if(!empty($settings['location_icon']['url'])){
                                                        echo piller_img_tag( array(
                                                            'url'   => esc_url( $settings['location_icon']['url'] ),
                                                        ));
                                                    }else{
                                                        echo '<img src="'.PILLER_ASSETS.'img/popular-location.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                    }
                                                echo '</div> ';
                                                if(!empty($data['location'])){
                                                    echo esc_html($data['location']);
                                                }
                                            echo '</div>';
                                        echo '</div>';
                                        echo '<ul class="property-featured">';
                                            if(!empty($data['feature'])){
                                                echo '<li>';
                                                    echo '<div class="icon">';
                                                        if(!empty($settings['feature_icon']['url'])){
                                                            echo piller_img_tag( array(
                                                                'url'   => esc_url( $settings['feature_icon']['url'] ),
                                                            ));
                                                        }else{
                                                            echo '<img src="'.PILLER_ASSETS.'img/bed.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                        }
                                                    echo '</div> ';
                                                    echo esc_html($data['feature']);
                                                echo '</li>';
                                            }
                                            if(!empty($data['feature2'])){
                                                echo '<li>';
                                                    echo '<div class="icon">';
                                                        if(!empty($settings['feature_icon2']['url'])){
                                                            echo piller_img_tag( array(
                                                                'url'   => esc_url( $settings['feature_icon2']['url'] ),
                                                            ));
                                                        }else{
                                                            echo '<img src="'.PILLER_ASSETS.'img/bath.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                        }
                                                    echo '</div> ';
                                                    echo esc_html($data['feature2']);
                                                echo '</li>';
                                            }
                                            if(!empty($data['feature3'])){
                                                echo '<li>';
                                                    echo '<div class="icon">';
                                                        if(!empty($settings['feature_icon3']['url'])){
                                                            echo piller_img_tag( array(
                                                                'url'   => esc_url( $settings['feature_icon3']['url'] ),
                                                            ));
                                                        }else{
                                                            echo '<img src="'.PILLER_ASSETS.'img/sqft.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                        }
                                                    echo '</div> ';
                                                    echo esc_html($data['feature3']);
                                                echo '</li>';
                                            }
                                        echo '</ul>';
                                        echo '<div class="property-bottom">';
                                            if(!empty($data['price'])){
                                                echo '<h6 class="box-title price">'.esc_html($data['price']).'</h6>';
                                            }
                                            if(!empty($data['button_text'])){
                                                echo '<a class="th-btn style3 pill" href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['button_text']).'</a>';
                                            }
                                        echo '</div>';
                                        echo '<div class="agent-wrap">';
                                            if(!empty($data['author']['url'])){
                                                echo '<div class="agent-thumb">';
                                                    echo piller_img_tag( array(
                                                        'url'   => esc_url( $data['author']['url']  ),
                                                    ));
                                                echo '</div>';
                                            }
                                            echo '<div class="agent-content">';
                                                if($data['name']){
                                                    echo '<h4 class="box-title">'.esc_html($data['name']).'</h4>';
                                                }
                                                if($data['designation']){
                                                    echo '<p class="box-text">'.esc_html($data['designation']).'</p>';
                                                }
                                            echo '</div>';
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';

                echo '<button data-slider-prev="#featuresSlider" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#featuresSlider" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
            echo '<div class="gallery-sec-4" id="gallery">';
                if(!empty($settings['video_url']['url'])){
                    echo '<div class="gallery-video-wrap">';
                        echo '<div class="video-box1">';
                            echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
                        echo '</div>';
                    echo '</div>';
                }
        
                echo '<div class="swiper th-slider gallery-slider4" id="gallerySlider4" data-slider-options=\'{"effect":"fade", "loop":true, "autoHeight": "true"}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['listing_list'] as $data ){
                            echo '<div class="swiper-slide">';
                                echo '<div class="gallery-4-inner" data-bg-src="'.esc_url( $data['image']['url'] ).'">';
                                    echo '<div class="container">';
                                        echo '<div class="row gy-4 align-items-center">';
                                            echo '<div class="col-md-9 col-lg-7 col-xl-6 col-xxl-5">';
                                                echo '<div class="gallery-4-wrap pe-xl-5 me-xl-2" data-ani="slideinup" data-ani-delay="0.2s">';
                                                    echo '<div class="popular-list-1 style-3">';
                                                        echo '<div class="property-content">';
                                                            echo '<div class="title-area text-left mb-50">';
                                                                if($settings['subtitle']){ 
                                                                    echo '<p class="sub-title"><span class="double-line"></span>'.esc_html($settings['subtitle']).'</p>';
                                                                }
                                                                if($settings['title']){
                                                                    echo '<h2 class="sec-title">'.esc_html($settings['title']).'</h2>';
                                                                }
                                                            echo '</div>';

                                                            echo '<div class="media-body">';
                                                                if(!empty($data['title'])){
                                                                    echo '<h3 class="box-title"><a href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
                                                                }
                                                                echo '<div class="box-text">';
                                                                    echo '<div class="icon">';
                                                                        if(!empty($settings['location_icon']['url'])){
                                                                            echo piller_img_tag( array(
                                                                                'url'   => esc_url( $settings['location_icon']['url'] ),
                                                                            ));
                                                                        }else{
                                                                            echo '<img src="'.PILLER_ASSETS.'img/popular-location.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                                        }
                                                                    echo '</div> ';
                                                                    if(!empty($data['location'])){
                                                                        echo esc_html($data['location']);
                                                                    }
                                                                echo '</div>';
                                                            echo '</div>';
            
                                                            echo '<ul class="property-featured">';
                                                                if(!empty($data['feature'])){
                                                                    echo '<li>';
                                                                        echo '<div class="icon">';
                                                                            if(!empty($settings['feature_icon']['url'])){
                                                                                echo piller_img_tag( array(
                                                                                    'url'   => esc_url( $settings['feature_icon']['url'] ),
                                                                                ));
                                                                            }else{
                                                                                echo '<img src="'.PILLER_ASSETS.'img/bed.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                                            }
                                                                        echo '</div> ';
                                                                        echo esc_html($data['feature']);
                                                                    echo '</li>';
                                                                }
                                                                if(!empty($data['feature2'])){
                                                                    echo '<li>';
                                                                        echo '<div class="icon">';
                                                                            if(!empty($settings['feature_icon2']['url'])){
                                                                                echo piller_img_tag( array(
                                                                                    'url'   => esc_url( $settings['feature_icon2']['url'] ),
                                                                                ));
                                                                            }else{
                                                                                echo '<img src="'.PILLER_ASSETS.'img/bath.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                                            }
                                                                        echo '</div> ';
                                                                        echo esc_html($data['feature2']);
                                                                    echo '</li>';
                                                                }
                                                                if(!empty($data['feature3'])){
                                                                    echo '<li>';
                                                                        echo '<div class="icon">';
                                                                            if(!empty($settings['feature_icon3']['url'])){
                                                                                echo piller_img_tag( array(
                                                                                    'url'   => esc_url( $settings['feature_icon3']['url'] ),
                                                                                ));
                                                                            }else{
                                                                                echo '<img src="'.PILLER_ASSETS.'img/sqft.svg" alt="'.esc_attr('Icon', 'piller').'">';
                                                                            }
                                                                        echo '</div> ';
                                                                        echo esc_html($data['feature3']);
                                                                    echo '</li>';
                                                                }
                                                            echo '</ul>';
                                                            echo '<div class="property-bottom">';
                                                                if(!empty($data['price'])){
                                                                    echo '<h6 class="box-title price">'.esc_html($data['price']).'</h6>';
                                                                }
                                                                if(!empty($data['button_text'])){
                                                                    echo '<a class="th-btn sm style3 radius bg-theme" href="'.esc_url( $data['button_url']['url'] ).'">'.esc_html($data['button_text']).'</a>';
                                                                }
                                                            echo '</div>';
                                                            echo '<div class="agent-wrap">';
                                                                if(!empty($data['author']['url'])){
                                                                    echo '<div class="thumb">';
                                                                        echo piller_img_tag( array(
                                                                            'url'   => esc_url( $data['author']['url']  ),
                                                                        ));
                                                                    echo '</div>';
                                                                }
                                                                echo '<div class="content">';
                                                                    if($data['name']){
                                                                        echo '<h4 class="box-title">'.esc_html($data['name']).'</h4>';
                                                                    }
                                                                    if($data['designation']){
                                                                        echo '<p class="box-text">'.esc_html($data['designation']).'</p>';
                                                                    }
                                                                echo '</div>';
                                                            echo '</div>';
                                                        echo '</div>';
                                                    echo '</div>';
                                                echo '</div>';
                                            echo '</div>';
                                        echo '</div>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                    echo '<div class="slider-pagination-wrapper">';
                        echo '<button data-slider-prev="#gallerySlider4" class="slider-arrow default slider-prev style-2">prev</button>';
                        echo '<div class="slider-pagination2"></div>';
                        echo '<div class="line"></div>';
                        echo '<button data-slider-next="#gallerySlider4" class="slider-arrow default style-2"> Next </button>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		
		}
        

	}
}