<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Marquee Widget .
 *
 */
class Piller_Marquee extends Widget_Base {

	public function get_name() {
		return 'pillermarquee';
	}
	public function get_title() {
		return __( 'Marquee', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}
 
	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Marquee', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );

        $repeater = new Repeater();

		piller_media_fields($repeater, 'icon', 'Choose Icon');
		piller_general_fields($repeater, 'title', 'title', 'TEXT', 'Smart Energy');
		
		$this->add_control(
			'marquee_lists',
			[
				'label' 		=> __( 'Marquee Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'button_text' 	=> __( 'Smart Energy', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .text', ['1', '2'] );

	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){
            echo '<div class="marquee-wrapper">';
				echo '<div class="marquee">';
					echo '<div class="marquee-group">';
						foreach( $settings['marquee_lists'] as $data ){
							echo '<div class="text">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['icon']['url'] ),
								));
								if(!empty($data['title'])){
									echo '<span>'.esc_html($data['title']).'</span>';
								}
							echo '</div>';
						}
					echo '</div>';
					echo '<div class="marquee-group">';
						foreach( $settings['marquee_lists'] as $data ){
							echo '<div class="text">';
								echo piller_img_tag( array(
									'url'   => esc_url( $data['icon']['url'] ),
								));
								if(!empty($data['title'])){
									echo '<span>'.esc_html($data['title']).'</span>';
								}
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){


		}
		
			
	}
}