<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Background;
/**
 * 
 * Newsletter Widget .
 *
 */
class Piller_Newsletter extends Widget_Base {

	public function get_name() {
		return 'pillernewsletter';
	}
	public function get_title() {
		return __( 'Newsletter', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label'     => __( 'Newsletter Style', 'piller' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );
		
		piller_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'Newsletter', ['1'] );
		piller_general_fields( $this, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Sign up to receive the latest articles', ['1'] );
		piller_general_fields( $this, 'newsletter_placeholder', 'Placeholder', 'TEXT', 'Enter your Email' );
		piller_general_fields( $this, 'newsletter_button', 'Subscribe Button', 'TEXT', 'Subscribe' );
		piller_general_fields( $this, 'notice', 'Notice', 'TEXTAREA2', 'I have read and agree to the terms & conditions', ['1'] );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields($this, '01', 'Subtitle', '{{WRAPPER}} .subscribe-box_text');
		piller_common_style_fields($this, '02', 'Title', '{{WRAPPER}} .subscribe-box_title');
		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="widget newsletter-widget footer-widget">';
				if($settings['title']){
					echo '<h3 class="widget_title">'.wp_kses_post($settings['title']).'</h3>';
				}
				if($settings['subtitle']){
					echo '<p class="footer-text">'.wp_kses_post($settings['subtitle']).'</p>';
				}
				echo '<form class="newsletter-form">';
					echo '<input class="form-control" type="email" placeholder="'.esc_attr( $settings['newsletter_placeholder'] ).'" required="">';
					echo '<button type="submit" class="th-btn bg-theme radius w-100 mb-3">'.wp_kses_post( $settings['newsletter_button'] ).'</button>';
					if($settings['notice']){
					echo '<div class="form-group">';
						echo '<input id="reviewcheck" name="reviewcheck" type="checkbox">';
						echo '<label for="reviewcheck">'.wp_kses_post($settings['notice']).'<span class="checkmark"></span></label>';
					echo '</div>';
					}
				echo '</form>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){

		}
	

	}
}
						