<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Price Widget .
 *
 */
class Piller_Price extends Widget_Base {

	public function get_name() {
		return 'pillerprice';
	}
	public function get_title() {
		return __( 'Price Box', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'price_section',
			[
				'label' 	=> __( 'Price Box', 'piller' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );

		$repeater = new Repeater();

		piller_general_fields($repeater, 'tag', 'Tag', 'TEXTAREA2', 'Popular'); 
		piller_media_fields( $repeater, 'icon', 'Choose Icon' );
		piller_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Basic Plan');
		piller_general_fields($repeater, 'price', 'Price', 'TEXTAREA', '$99.00'); 
		piller_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', 'Consultation with a lawyer for your person al solution with basic plan.');
		piller_code_fields($repeater, 'features', 'Features', ''); 
		piller_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Get Started');
		piller_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'price_lists',
			[
				'label' 		=> __( 'Price Lists', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Basic Plan', 'piller' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
		);

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		piller_common_style_fields( $this, '01', 'Tag', '{{WRAPPER}} .tag' );
		piller_common_style_fields( $this, '02', 'Title', '{{WRAPPER}} .price-card_title' );
		piller_common_style_fields( $this, '03', 'Price', '{{WRAPPER}} .price-card_price' );
		piller_common_style_fields( $this, '04', 'Description', '{{WRAPPER}} .box-text' );
		piller_common_style_fields( $this, '05', 'Features', '{{WRAPPER}} .checklist li' );

		//------Button Style-------
		piller_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn' );

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' || $settings['layout_style'] == '2' ){
			if($settings['layout_style'] == '2'){
				$class = 'style2';
			}else{
				$class = '';
			}

			echo '<div class="row gy-4 justify-content-center">';
				$animations = ['fadeinleft', 'fadeinup', 'fadeinright'];
				foreach( $settings['price_lists'] as $key => $data ){
					$active = ($key == 1) ? 'active' : '';
					$animation_class = $animations[$key % count($animations)];
					$delay = number_format(0.1 + ($key * 0.2), 1); 

					echo '<div class="col-xl-4 col-md-6 wow '.esc_attr($animation_class).'" data-wow-delay="'.esc_attr($delay).'s">';
						echo '<div class="price-card '.esc_attr($class .' '.$active).'">';
							if(!empty($data['tag'])){
								echo '<span class="tag">'.esc_html($data['tag']).'</span>';
							}
							echo '<div class="price-card_top">';
								if(!empty($data['icon']['url'])){
									echo '<div class="icon">';
										echo piller_img_tag( array(
											'url'   => esc_url( $data['icon']['url'] ),
										));
									echo '</div>';
								}
								if(!empty($data['title'])){
									echo '<h3 class="price-card_title">'.esc_html($data['title']).'</h3>';
								}
							echo '</div>';

							echo '<div class="price-card_price-wrap">';
								if(!empty($data['price'])){
									echo '<h4 class="price-card_price">'.wp_kses_post($data['price']).'</h4>';
								}
								if(!empty($data['desc'])){
									echo '<p class="box-text">'.esc_html($data['desc']).'</p>';
								}
							echo '</div>';
							echo '<div class="price-card_content">';
								if(!empty($data['features'])){
									echo '<div class="checklist style7">'.wp_kses_post($data['features']).'</div>';
								}
								if(!empty($data['button_text'])){
									echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="w-100 th-btn style3 radius">'.esc_attr($data['button_text']).'</a>';
								}
							echo '</div>';
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){


		}


	}

}