<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class piller_Testimonial extends Widget_Base{

	public function get_name() {
		return 'pillertestimonialslider';
	}
	public function get_title() {
		return __( 'Testimonials', 'piller' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'piller' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'piller' ), 
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		piller_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] );

		piller_media_fields( $this, 'quote', 'Quote Icon', ['1', '2', '3'] );

		$repeater = new Repeater();

		piller_media_fields( $repeater, 'client_image', 'Client Image' );
		piller_media_fields( $repeater, 'client_logo', 'Client Logo' );
		piller_general_fields( $repeater, 'client_name', 'Client Name', 'TEXT', 'Alex Michel' );
		piller_general_fields( $repeater, 'client_desig', 'Client Designation', 'TEXT', 'Ui/Ux Designer' );
		piller_general_fields( $repeater, 'client_feedback', 'Client Feedback', 'TEXTAREA', 'Our knowledgeable technicians are happy to provide tips' );
		piller_general_fields( $repeater, 'client_review', 'Client Review', 'TEXT', '' );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_image'	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
				'condition'		=> [ 
					'layout_style' => [ '1' ],
				],
			]
		);

		$repeater = new Repeater();

		piller_media_fields( $repeater, 'client_image', 'Client Image' );
		piller_general_fields( $repeater, 'client_name', 'Client Name', 'TEXT', 'Alex Michel' );
		piller_general_fields( $repeater, 'client_desig', 'Client Designation', 'TEXT', 'Ui/Ux Designer' );
		piller_general_fields( $repeater, 'client_feedback', 'Client Feedback', 'TEXTAREA', 'Our knowledgeable technicians are happy to provide tips' );

		piller_select_field( $repeater, 'client_rating', 'Client Rating', [ 'One Star', 'Two Star', 'Three Star', 'Four Star', 'Five Star' ] );

		$this->add_control(
			'slides2',
			[
				'label' 		=> __( 'Slides', 'piller' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_image'	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
				'condition'		=> [ 
					'layout_style' => [ '2', '3' ],
				],
			]
		);


		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		piller_common_style_fields( $this, '01', 'Name', '{{WRAPPER}} .box-title', ['1', '2', '3'] );
		piller_common_style_fields( $this, '02', 'Designation', '{{WRAPPER}} .box-desig', ['1'] );
		piller_common_style_fields( $this, '022', 'Designation', '{{WRAPPER}} .desig', ['2', '3'] );
		piller_common_style_fields( $this, '03', 'Feedback', '{{WRAPPER}} .text', ['1'] );
		piller_common_style_fields( $this, '033', 'Feedback', '{{WRAPPER}} .box-text', ['2', '3'] );
		
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
            echo '<div class="testi-card-slide">';
                echo '<div class="swiper has-shadow th-slider" id="testiSlide1" data-slider-options=\'{"centeredSlides":true,"paginationType": "progressbar","loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3.2"}}}\'>';
                    echo '<div class="swiper-wrapper">';
						foreach( $settings['slides'] as $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="testi-block" dir="ltr">';
									echo '<div class="top-wrap">';
										if(!empty($settings['quote']['url'])){
											echo '<div class="quote">';
												echo piller_img_tag( array(
													'url'	=> esc_url( $settings['quote']['url'] ),
												) );
											echo '</div>';
										}
										if(!empty($data['client_logo']['url'])){
											echo '<div class="logo">';
												echo piller_img_tag( array(
													'url'	=> esc_url( $data['client_logo']['url'] ),
												) );
											echo '</div>';
										}
									echo '</div>';
									if(!empty($data['client_feedback'])){
										echo '<div class="testi-content">';
											echo '<p class="box-text">'.esc_html( $data['client_feedback'] ).'</p>';
										echo '</div>';
									}
									echo '<div class="bottom-wrap">';
										echo '<div class="content">';
											if(!empty($data['client_name'])){
												echo '<h3 class="box-title">'.esc_html( $data['client_name'] ).'</h3>';
											}
											if(!empty($data['client_desig'])){
												echo '<p class="text">'.esc_html( $data['client_desig'] ).'</p>';
											}
										echo '</div>';
										echo '<div class="team-img">';
											echo piller_img_tag( array(
												'url'	=> esc_url( $data['client_image']['url'] ),
											) );
											if(!empty($data['client_review'])){
												echo '<div class="box-review">';
													echo '<i class="fa-sharp fa-solid fa-star"></i>';
													echo '<div class="rating">';
														echo '<span>'.esc_html( $data['client_review'] ).'</span>';
													echo '</div>';
												echo '</div>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
                    echo '</div>';
                    echo '<div class="slider-controller container-width">';
                        echo '<button data-slider-prev="#testiSlide1" class="slider-arrow default  slider-prev"><i class="far fa-arrow-left"></i></button>';
                        echo '<div class="slider-pagination" data-slider-id="#testiSlider1"></div>';
                        echo '<button data-slider-next="#testiSlide1" class="slider-arrow default  slider-next"><i class="far fa-arrow-right"></i></button>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="testi-card-slide">';
				echo '<div class="swiper has-shadow th-slider" id="testiSlide1" data-slider-options=\'{"centeredSlides":true,"paginationType": "progressbar","loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['slides2'] as $data ){
							echo '<div class="swiper-slide">';
								echo '<div class="testi-block style-2" dir="ltr">';
									if(!empty($settings['quote']['url'])){
										echo '<div class="top-wrap">';
											echo '<div class="quote">';
												echo piller_img_tag( array(
													'url'	=> esc_url( $settings['quote']['url'] ),
												) );
											echo '</div>';
										echo '</div>';
									}
									if(!empty($data['client_feedback'])){
										echo '<div class="testi-content pe-xl-5 px-xl-5">';
											echo '<p class="box-text">'.esc_html( $data['client_feedback'] ).'</p>';
										echo '</div>';
									}
									echo '<div class="bottom-wrap">';
										echo '<div class="box-review">';
											if( $data['client_rating'] == '1' ){
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
											}elseif( $data['client_rating'] == '2' ){
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
											}elseif( $data['client_rating'] == '3' ){
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
												echo '<span class=""><i class="fa-sharp fa-solid fa-star"></i></span>';
											}elseif( $data['client_rating'] == '4' ){
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-regular fa-solid fa-star"></i>';
											}else{
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
												echo '<i class="fa-sharp fa-solid fa-star"></i>';
											}
										echo '</div>';
										if(!empty($data['client_image']['url'])){
											echo '<div class="team-img">';
												echo piller_img_tag( array(
													'url'	=> esc_url( $data['client_image']['url'] ),
												) );
											echo '</div>';
										}
										echo '<div class="content">';
											if(!empty($data['client_name'])){
												echo '<h3 class="box-title">'.esc_html( $data['client_name'] ).'</h3>';
											}
											if(!empty($data['client_desig'])){
												echo '<p class="text desig">'.esc_html( $data['client_desig'] ).'</p>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<div class="slider-controller container-width">';
						echo '<button data-slider-prev="#testiSlide1" class="slider-arrow default  slider-prev"><i class="far fa-arrow-left"></i></button>';
						echo '<div class="slider-pagination style-2" data-slider-id="#testiSlider1"></div>';
						echo '<button data-slider-next="#testiSlide1" class="slider-arrow default  slider-next"><i class="far fa-arrow-right"></i></button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="testi-card-slide pe-xl-5 ps-xl-5">';
				echo '<div class="swiper has-shadow th-slider" id="testiSlide3" data-slider-options=\'{"centeredSlides":true,"paginationType": "progressbar","loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}\'>';
					echo '<div class="swiper-wrapper">';
					foreach( $settings['slides2'] as $data ){
						echo '<div class="swiper-slide">';
							echo '<div class="testi-block style-2 style-3" dir="ltr">';
								if(!empty($settings['quote']['url'])){
									echo '<div class="top-wrap">';
										echo '<div class="quote">';
											echo piller_img_tag( array(
												'url'	=> esc_url( $settings['quote']['url'] ),
											) );
										echo '</div>';
									echo '</div>';
								}
								echo '<div class="testi-content">';
									if(!empty($data['client_feedback'])){
										echo '<p class="box-text">'.wp_kses_post( $data['client_feedback'] ).'</p>';
									}
								echo '</div>';
								echo '<div class="bottom-wrap">';
									if(!empty($data['client_image']['url'])){
										echo '<div class="team-img">';
											echo piller_img_tag( array(
												'url'	=> esc_url( $data['client_image']['url'] ),
											) );
										echo '</div>';
									}
									echo '<div class="content">';
										if(!empty($data['client_name'])){
											echo '<h3 class="box-title">'.esc_html( $data['client_name'] ).'</h3>';
										}
										if(!empty($data['client_desig'])){
											echo '<p class="text desig">'.esc_html( $data['client_desig'] ).'</p>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
					echo '</div>';
					echo '<button data-slider-prev="#testiSlide3" class="slider-arrow  testi-3 slider-prev"><i class="far fa-arrow-left"></i></button>';
					echo '<button data-slider-next="#testiSlide1" class="slider-arrow  testi-3 slider-next"><i class="far fa-arrow-right"></i></button>';
				echo '</div>';
			echo '</div>';

		}


	}

}