<?php
    /**
     * Class For Builder
     */
    class PillerBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'piller_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'piller-core',PILLER_PLUGDIRURI.'assets/js/piller-core.js',array( 'jquery' ),'1.0',true );
		}


        public function piller_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'piller_header_option',
                [
                    'label'     => __( 'Header Option', 'piller' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'piller_header_style',
                [
                    'label'     => __( 'Header Option', 'piller' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'piller' ),
    					'header_builder'       => __( 'Header Builder', 'piller' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'piller_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'piller' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->piller_header_choose_option(),
                    'condition' => [ 'piller_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'piller_footer_option',
                [
                    'label'     => __( 'Footer Option', 'piller' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'piller_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'piller' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'piller' ),
    				'label_off'     => __( 'No', 'piller' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'piller_footer_style',
                [
                    'label'     => __( 'Footer Style', 'piller' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'piller' ),
    					'footer_builder'       => __( 'Footer Builder', 'piller' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'piller_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'piller_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'piller' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->piller_footer_build_choose_option(),
                    'condition' => [ 'piller_footer_style' => 'footer_builder','piller_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Piller Builder', 'piller' ),
            	esc_html__( 'Piller Builder', 'piller' ),
				'manage_options',
				'piller',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('piller', esc_html__('Footer Builder', 'piller'), esc_html__('Footer Builder', 'piller'), 'manage_options', 'edit.php?post_type=piller_footerbuild');
			add_submenu_page('piller', esc_html__('Header Builder', 'piller'), esc_html__('Header Builder', 'piller'), 'manage_options', 'edit.php?post_type=piller_header');
			add_submenu_page('piller', esc_html__('Tab Builder', 'piller'), esc_html__('Tab Builder', 'piller'), 'manage_options', 'edit.php?post_type=piller_tab_builder');
			add_submenu_page('piller', esc_html__('Megamenu', 'piller'), esc_html__('Megamenu', 'piller'), 'manage_options', 'edit.php?post_type=piller_megamenu');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header, Footer and Megamenu Builder Of This Theme','piller' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'piller' ),
				'singular_name'      => __( 'Footer', 'piller' ),
				'menu_name'          => __( 'Piller Footer Builder', 'piller' ),
				'name_admin_bar'     => __( 'Footer', 'piller' ),
				'add_new'            => __( 'Add New', 'piller' ),
				'add_new_item'       => __( 'Add New Footer', 'piller' ),
				'new_item'           => __( 'New Footer', 'piller' ),
				'edit_item'          => __( 'Edit Footer', 'piller' ),
				'view_item'          => __( 'View Footer', 'piller' ),
				'all_items'          => __( 'All Footer', 'piller' ),
				'search_items'       => __( 'Search Footer', 'piller' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'piller' ),
				'not_found'          => __( 'No Footer found.', 'piller' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'piller' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'piller_footerbuild', $args );

			$labels = array(
				'name'               => __( 'Header', 'piller' ),
				'singular_name'      => __( 'Header', 'piller' ),
				'menu_name'          => __( 'Piller Header Builder', 'piller' ),
				'name_admin_bar'     => __( 'Header', 'piller' ),
				'add_new'            => __( 'Add New', 'piller' ),
				'add_new_item'       => __( 'Add New Header', 'piller' ),
				'new_item'           => __( 'New Header', 'piller' ),
				'edit_item'          => __( 'Edit Header', 'piller' ),
				'view_item'          => __( 'View Header', 'piller' ),
				'all_items'          => __( 'All Header', 'piller' ),
				'search_items'       => __( 'Search Header', 'piller' ),
				'parent_item_colon'  => __( 'Parent Header:', 'piller' ),
				'not_found'          => __( 'No Header found.', 'piller' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'piller' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'piller_header', $args );

			$labels = array(
				'name'               => __( 'Tab Builder', 'piller' ),
				'singular_name'      => __( 'Tab Builder', 'piller' ),
				'menu_name'          => __( 'Gesund Tab Builder', 'piller' ),
				'name_admin_bar'     => __( 'Tab Builder', 'piller' ),
				'add_new'            => __( 'Add New', 'piller' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'piller' ),
				'new_item'           => __( 'New Tab Builder', 'piller' ),
				'edit_item'          => __( 'Edit Tab Builder', 'piller' ),
				'view_item'          => __( 'View Tab Builder', 'piller' ),
				'all_items'          => __( 'All Tab Builder', 'piller' ),
				'search_items'       => __( 'Search Tab Builder', 'piller' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'piller' ),
				'not_found'          => __( 'No Tab Builder found.', 'piller' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'piller' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'piller_tab_builder', $args );

			$labels = array(
				'name'               => __( 'Megamenu', 'piller' ),
				'singular_name'      => __( 'Megamenu', 'piller' ),
				'menu_name'          => __( 'piller Megamenu', 'piller' ),
				'name_admin_bar'     => __( 'Megamenu', 'piller' ),
				'add_new'            => __( 'Add New', 'piller' ),
				'add_new_item'       => __( 'Add New Megamenu', 'piller' ),
				'new_item'           => __( 'New Megamenu', 'piller' ),
				'edit_item'          => __( 'Edit Megamenu', 'piller' ),
				'view_item'          => __( 'View Megamenu', 'piller' ),
				'all_items'          => __( 'All Megamenu', 'piller' ),
				'search_items'       => __( 'Search Megamenu', 'piller' ),
				'parent_item_colon'  => __( 'Parent Megamenu:', 'piller' ),
				'not_found'          => __( 'No Megamenu found.', 'piller' ),
				'not_found_in_trash' => __( 'No Megamenu found in Trash.', 'piller' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'piller_megamenu', $args );
			
		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'piller_footerbuild' == $post->post_type || 'piller_header' == $post->post_type || 'piller_tab_build' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function piller_footer_build_choose_option(){

			$piller_post_query = new WP_Query( array(
				'post_type'			=> 'piller_footerbuild',
				'posts_per_page'	    => -1,
			) );

			$piller_builder_post_title = array();
			$piller_builder_post_title[''] = __('Select a Footer','piller');

			while( $piller_post_query->have_posts() ) {
				$piller_post_query->the_post();
				$piller_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $piller_builder_post_title;

		}

		public function piller_header_choose_option(){

			$piller_post_query = new WP_Query( array(
				'post_type'			=> 'piller_header',
				'posts_per_page'	    => -1,
			) );

			$piller_builder_post_title = array();
			$piller_builder_post_title[''] = __('Select a Header','piller');

			while( $piller_post_query->have_posts() ) {
				$piller_post_query->the_post();
				$piller_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $piller_builder_post_title;

        }

    }

    $builder_execute = new PillerBuilder();