<?php
/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function piller_core_essential_scripts( ) {
    wp_enqueue_script('piller-ajax',PILLER_PLUGDIRURI.'assets/js/piller.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'piller-ajax',
    'pillerajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'piller-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','piller_core_essential_scripts');


// piller Section subscribe ajax callback function
add_action( 'wp_ajax_piller_subscribe_ajax', 'piller_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_piller_subscribe_ajax', 'piller_subscribe_ajax' );

function piller_subscribe_ajax( ){
  $apiKey = piller_opt('piller_subscribe_apikey');
  $listid = piller_opt('piller_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'piller-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'piller').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);

           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'piller').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'piller').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'piller').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'piller').'</div>';
        }
   }

   wp_die();

}

add_action('wp_ajax_piller_addtocart_notification','piller_addtocart_notification');
add_action('wp_ajax_nopriv_piller_addtocart_notification','piller_addtocart_notification');
function piller_addtocart_notification(){

    $_product = wc_get_product($_POST['prodid']);
    $response = [
        'img_url'   => esc_url( wp_get_attachment_image_src( $_product->get_image_id(),array('60','60'))[0] ),
        'title'     => wp_kses_post( $_product->get_title() )
    ];
    echo json_encode($response);

    wp_die();
}