<?php
/**
* 
* @version  1.0
* @package  piller
* @author   Themehour ( themehour@gmail.com )
*
**/

/**************************************
* Creating Contact Form Widget
***************************************/

class piller_contact_form_widget extends WP_Widget {

        function __construct() {

            parent::__construct(

                // Base ID of your widget
                'piller_contact_form_widget',

                // Widget name will appear in UI
                esc_html__( 'Piller :: Contact Form', 'piller' ),

                // Widget description
                array(
                    'classname'                     => 'sidebar-contact-form',
                    'customize_selective_refresh'   => true,
                    'description'                   => esc_html__( 'Add Contact Form Widget', 'piller' ),
                )
            );
        }

        // This is where the action happens
        public function widget( $args, $instance ) {

            $title  = apply_filters( 'widget_title', $instance['title'] );

            //form_shortcode
            if ( isset( $instance[ 'form_shortcode' ] ) ) {
                $form_shortcode = $instance[ 'form_shortcode' ];
            }else {
                $form_shortcode = '';
            }

            //before and after widget arguments are defined by themes
            echo $args['before_widget'];

                if( !empty( $title  ) ){
                    echo '<h3 class="widget_title">'.esc_html( $title ).'</h3>';
                }
                echo '<div class="contact-form-widget">';
                    echo '<div class="newsletter-form">';
                        echo do_shortcode( $form_shortcode );
                    echo '</div>';
                echo '</div>';

            echo $args['after_widget'];
        }

        public function form( $instance ) {
            // Title
            $title = isset( $instance['title'] ) ? $instance['title'] : 'Contact Us';
            $form_shortcode = isset( $instance['form_shortcode'] ) ? $instance['form_shortcode'] : '';
        
            // Get all Contact Form 7 forms
            $forms = get_posts( array(
                'post_type'      => 'wpcf7_contact_form',
                'posts_per_page' => -1,
            ) );
            ?>
            <p>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ,'piller'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
                       name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"
                       value="<?php echo esc_attr( $title ); ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id( 'form_shortcode' ); ?>"><?php _e( 'Select Form:' ,'piller'); ?></label>
                <select class="widefat" id="<?php echo $this->get_field_id( 'form_shortcode' ); ?>"
                        name="<?php echo $this->get_field_name( 'form_shortcode' ); ?>">
                    <option value=""><?php _e( '-- Select a Form --', 'piller' ); ?></option>
                    <?php
                    if ( $forms ) {
                        foreach ( $forms as $form ) {
                            $shortcode = '[contact-form-7 id="' . $form->ID . '" title="' . esc_attr( $form->post_title ) . '"]';
                            $selected = ( $form_shortcode == $shortcode ) ? 'selected="selected"' : '';
                            echo '<option value="' . esc_attr( $shortcode ) . '" ' . $selected . '>' . esc_html( $form->post_title ) . '</option>';
                        }
                    } else {
                        echo '<option value="">' . __( 'No Contact Forms Found', 'piller' ) . '</option>';
                    }
                    ?>
                </select>
            </p>
            <?php
        }
        


        // Updating widget replacing old instances with new

        public function update( $new_instance, $old_instance ) {

            $instance = array();
            $instance['title']          = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
            $instance['form_shortcode']          = ( ! empty( $new_instance['form_shortcode'] ) ) ? strip_tags( $new_instance['form_shortcode'] ) : '';

            return $instance;
        }
    } // Class piller_contact_form_widget ends here


    // Register and load the widget
    function piller_contact_form_load_widget() {
        register_widget( 'piller_contact_form_widget' );
    }
    add_action( 'widgets_init', 'piller_contact_form_load_widget' );