<?php
/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */
 
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}

    if( class_exists( 'ReduxFramework' ) ) {
        $piller404title     = piller_opt( 'piller_error_title' ); 
        $piller404description  = piller_opt( 'piller_error_description' );
        $piller404btntext      = piller_opt( 'piller_error_btn_text' );
    } else {
        $piller404title     = __( 'Error 404', 'piller' );
        $piller404description  = __( 'Oops! The page you’re looking for doesn’t exist', 'piller' );
        $piller404btntext      = __( 'Back To Home', 'piller');

    }

    // get header //
    get_header(); 

    if(!empty(piller_opt('piller_error_bg_shape', 'url' ) )){
        $bg_url = piller_opt('piller_error_bg_shape', 'url' );
    }else{
        $bg_url = '';
    }
    if(!empty(piller_opt('piller_error_img', 'url' ) )){
        $bg_url = piller_opt('piller_error_img', 'url' );
    }else{
        $bg_url = '';
    }
    if(!empty(piller_opt('piller_error_shape', 'url' ) )){
        $bg_url = piller_opt('piller_error_shape', 'url' );
    }else{
        $bg_url = '';
    }

    echo '<section class="bg-smoke space shape-mockup-wrap" data-bg-src="'.esc_url( piller_opt('piller_error_bg_shape', 'url' ) ).'">'; 
        if(!empty(piller_opt('piller_error_shape', 'url' ) )){
            echo '<div class="shape-mockup d-none d-xxl-block" data-bottom="0%" data-right="0%">';
                echo '<img src="'.esc_url( piller_opt('piller_error_shape', 'url' ) ).'" alt="'.esc_attr__('Shape', 'piller').'">';
            echo '</div>';
        }
        echo '<div class="error-bg-img" data-mask-src="'.get_template_directory_uri().'/assets/img/error-bg-shape.png">';
            if(!empty(piller_opt('piller_error_img', 'url' ) )){
                echo '<img src="'.esc_url( piller_opt('piller_error_img', 'url' ) ).'" alt="'.esc_attr__('404 image', 'piller').'">';
            }else{
                echo '<img src="'.get_template_directory_uri().'/assets/img/error-bg.png" alt="'.esc_attr__('404 image', 'piller').'">';
            }
        echo '</div>';
        echo '<div class="container">';
            echo '<div class="row justify-content-center">';
                echo '<div class="col-lg-6">';
                    echo '<div class="error-content">';
                        if(!empty($piller404title)){
                            echo '<h2 class="error-title">'.wp_kses_post( $piller404title ).'</h2>';
                        }
                        if(!empty($piller404description)){
                            echo '<p class="error-text">'.esc_html( $piller404description ).'</p>';
                        }
                        echo '<a href="'.esc_url( home_url('/') ).'" class="th-btn radius error-btn">'.esc_html( $piller404btntext ).'</a>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</section>';

    //footer
    get_footer();