<?php
/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Include File
 *
 */

// Constants
require_once get_parent_theme_file_path() . '/inc/piller-constants.php';

//theme setup
require_once PILLER_DIR_PATH_INC . 'theme-setup.php';

//essential scripts
require_once PILLER_DIR_PATH_INC . 'essential-scripts.php';

// Woo Hooks
require_once PILLER_DIR_PATH_INC . 'woo-hooks/piller-woo-hooks.php';

// Woo Hooks Functions
require_once PILLER_DIR_PATH_INC . 'woo-hooks/piller-woo-hooks-functions.php';

// plugin activation
require_once PILLER_DIR_PATH_FRAM . 'plugins-activation/piller-active-plugins.php';

// theme dynamic css
require_once PILLER_DIR_PATH_INC . 'piller-commoncss.php';

// meta options
require_once PILLER_DIR_PATH_FRAM . 'piller-meta/piller-config.php';

// page breadcrumbs
require_once PILLER_DIR_PATH_INC . 'piller-breadcrumbs.php';

// sidebar register
require_once PILLER_DIR_PATH_INC . 'piller-widgets-reg.php';

//essential functions
require_once PILLER_DIR_PATH_INC . 'piller-functions.php';

// helper function
require_once PILLER_DIR_PATH_INC . 'wp-html-helper.php';

// Demo Data
require_once PILLER_DEMO_DIR_PATH . 'demo-import.php';

// pagination
require_once PILLER_DIR_PATH_INC . 'wp_bootstrap_pagination.php';

// piller options
require_once PILLER_DIR_PATH_FRAM . 'piller-options/piller-options.php';

// hooks
require_once PILLER_DIR_PATH_HOOKS . 'hooks.php';

// hooks funtion
require_once PILLER_DIR_PATH_HOOKS . 'hooks-functions.php'; 

// Image main size
add_filter( 'big_image_size_threshold', '__return_false' );

add_action('wp_ajax_update_cart_count', 'update_cart_count');
add_action('wp_ajax_nopriv_update_cart_count', 'update_cart_count');

function update_cart_count() {
    if (class_exists('woocommerce')) {
        global $woocommerce;
        $product_id = intval($_POST['product_id']);
        $woocommerce->cart->add_to_cart($product_id); // Add the product to the cart

        $cart_count = $woocommerce->cart->cart_contents_count;
        echo esc_html($cart_count);
    }
    wp_die();
}

// directorist container replace by theme container
function piller_custom_directorist_container() {
    return 'container';
}
add_filter('directorist_container_fluid', 'piller_custom_directorist_container');
