<?php
/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }


    // preloader hook function
    if( ! function_exists( 'piller_preloader_wrap_cb' ) ) {
        function piller_preloader_wrap_cb() {
            $preloader_display              =  piller_opt('piller_display_preloader');
            $piller_display_preloader_btn     =  piller_opt('piller_display_preloader_btn');
            $piller_preloader_btn_text        =  piller_opt('piller_preloader_btn_text');

            if( class_exists('ReduxFramework') ){
                if( $preloader_display ){
                    $str = piller_opt( 'piller_preloader_text' );
                    $chars = str_split($str);
                    
                    echo '<div id="preloader" class="preloader">';
                        if( $piller_display_preloader_btn ){
                            if( !empty( $piller_preloader_btn_text ) ){
                                echo '<button class="th-btn preloaderCls">'.esc_html( $piller_preloader_btn_text ).'</button>';
                            }
                        }
                        echo '<div class="preloader-inner">';
                            echo '<div class="txt-loading">';
                                foreach ($chars as $char) {
                                    echo '<span data-text-preloader="'.esc_attr($char).'" class="letters-loading">'.esc_html($char).'</span>';
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
            }else{
                echo '<div class="preloader">';
                    echo '<button class="th-btn preloaderCls">'.esc_html__( 'Cancel Preloader', 'piller' ).'</button>';
                    echo '<div class="preloader-inner">
                        <div class="loader"></div>
                    </div>';
                echo '</div>';
            }

        }
    }

    // Header Hook function
    if( !function_exists('piller_header_cb') ) { 
        function piller_header_cb( ) {
            get_template_part('templates/header');
        }
    }

    // Header Hook function
    if( !function_exists('piller_breadcrumb_cb') ) { 
        function piller_breadcrumb_cb( ) {
            get_template_part('templates/header-menu-bottom');
        }
    }

    // back top top hook function
    if( ! function_exists( 'piller_back_to_top_cb' ) ) {
        function piller_back_to_top_cb( ) {
            $backtotop_trigger = piller_opt('piller_display_bcktotop');
            if( class_exists( 'ReduxFramework' ) ) {
                if( $backtotop_trigger ) {
            	?>
                    <div class="scroll-top">
                        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
                            </path>
                        </svg>
                    </div>
                <?php 
                }
            }

        }
    }

    // Blog Start Wrapper Function
    if( !function_exists('piller_blog_start_wrap_cb') ) {
        function piller_blog_start_wrap_cb() { ?>
            <section class="th-blog-wrapper space-top space-extra-bottom">
                <div class="container">
                    <div class="row">
        <?php }
    }

    // Blog End Wrapper Function
    if( !function_exists('piller_blog_end_wrap_cb') ) {
        function piller_blog_end_wrap_cb() {?>
                    </div>
                </div>
            </section>
        <?php }
    }

    // Blog Column Start Wrapper Function
    if( !function_exists('piller_blog_col_start_wrap_cb') ) {
        function piller_blog_col_start_wrap_cb() {
           
                //Redux option work
                if( class_exists('ReduxFramework') ) {
                    $piller_blog_sidebar = piller_opt('piller_blog_sidebar');
                }else{
                    $piller_blog_sidebar = '1';
                }

                if( class_exists('ReduxFramework') ) {
                    // $piller_blog_sidebar = piller_opt('piller_blog_sidebar');
                    if( $piller_blog_sidebar == '2' && is_active_sidebar('piller-blog-sidebar') ) {
                        echo '<div class="col-xxl-8 col-lg-7  order-lg-last">';
                    } elseif( $piller_blog_sidebar == '3' && is_active_sidebar('piller-blog-sidebar') ) {
                        echo '<div class="col-xxl-8 col-lg-7">';
                    } else {
                        echo '<div class="col-lg-12">';
                    }

                } else {
                    if( is_active_sidebar('piller-blog-sidebar') ) {
                        echo '<div class="col-xxl-8 col-lg-7">';
                    } else {
                        echo '<div class="col-lg-12">';
                    }
                }
                

        }
    }
    // Blog Column End Wrapper Function
    if( !function_exists('piller_blog_col_end_wrap_cb') ) {
        function piller_blog_col_end_wrap_cb() {
            echo '</div>';
        }
    }

    // Blog Sidebar
    if( !function_exists('piller_blog_sidebar_cb') ) {
        function piller_blog_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $piller_blog_sidebar = piller_opt('piller_blog_sidebar');
            } else {
                $piller_blog_sidebar = 2;
                
            }
            if( $piller_blog_sidebar != 1 && is_active_sidebar('piller-blog-sidebar') ) {
                // Sidebar
                get_sidebar();
            }
        }
    }


    if( !function_exists('piller_blog_details_sidebar_cb') ) {
        function piller_blog_details_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $piller_blog_single_sidebar = piller_opt('piller_blog_single_sidebar');
            } else {
                $piller_blog_single_sidebar = 4;
            }
            if( $piller_blog_single_sidebar != 1 ) {
                // Sidebar
                get_sidebar();
            }

        }
    }

    // Blog Pagination Function
    if( !function_exists('piller_blog_pagination_cb') ) {
        function piller_blog_pagination_cb( ) {
            get_template_part('templates/pagination');
        }
    }

    // Blog Content Function
    if( !function_exists('piller_blog_content_cb') ) {
        function piller_blog_content_cb( ) {

            //Redux option work
            if( class_exists('ReduxFramework') ) {
                $piller_blog_grid = piller_opt('piller_blog_grid');  
            }else{
                $piller_blog_grid = '1';
            }

            if( $piller_blog_grid == '1' ) {
                $piller_blog_grid_class = 'col-lg-12';
            } elseif( $piller_blog_grid == '2' ) {
                $piller_blog_grid_class = 'col-sm-6';
            } else {
                $piller_blog_grid_class = 'col-lg-4 col-sm-6';
            }

            echo '<div class="row">';
                if( have_posts() ) {
                    while( have_posts() ) {
                        the_post();
                        echo '<div class="'.esc_attr($piller_blog_grid_class).'">';
                            get_template_part('templates/content',get_post_format());
                        echo '</div>';
                    }
                    wp_reset_postdata();
                } else{
                    get_template_part('templates/content','none');
                }
            echo '</div>';
        }
    }

    // footer content Function
    if( !function_exists('piller_footer_content_cb') ) {
        function piller_footer_content_cb( ) {

            if( class_exists('ReduxFramework') && did_action( 'elementor/loaded' )  ){
                if( is_page() || is_page_template('template-builder.php') ) {
                    $post_id = get_the_ID();

                    // Get the page settings manager
                    $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

                    // Get the settings model for current post
                    $page_settings_model = $page_settings_manager->get_model( $post_id );

                    // Retrieve the Footer Style
                    $footer_settings = $page_settings_model->get_settings( 'piller_footer_style' );

                    // Footer Local
                    $footer_local = $page_settings_model->get_settings( 'piller_footer_builder_option' );

                    // Footer Enable Disable
                    $footer_enable_disable = $page_settings_model->get_settings( 'piller_footer_choice' );

                    if( $footer_enable_disable == 'yes' ){
                        if( $footer_settings == 'footer_builder' ) {
                            // local options
                            $piller_local_footer = get_post( $footer_local );
                            echo '<footer>';
                            echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $piller_local_footer->ID );
                            echo '</footer>';
                        } else {
                            // global options
                            $piller_footer_builder_trigger = piller_opt('piller_footer_builder_trigger');
                            if( $piller_footer_builder_trigger == 'footer_builder' ) {
                                echo '<footer>';
                                $piller_global_footer_select = get_post( piller_opt( 'piller_footer_builder_select' ) );
                                $footer_post = get_post( $piller_global_footer_select );
                                echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                                echo '</footer>';
                            } else {
                                // wordpress widgets
                                piller_footer_global_option();
                            }
                        }
                    }
                } else {
                    // global options
                    $piller_footer_builder_trigger = piller_opt('piller_footer_builder_trigger');
                    if( $piller_footer_builder_trigger == 'footer_builder' ) {
                        echo '<footer>';
                        $piller_global_footer_select = get_post( piller_opt( 'piller_footer_builder_select' ) );
                        $footer_post = get_post( $piller_global_footer_select );
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                        echo '</footer>';
                    } else {
                        // wordpress widgets
                        piller_footer_global_option();
                    }
                }
            } else { ?>
                <div class="footer-layout1 footer-sitcky">
                    <div class="copyright-wrap bg-theme2">
                        <div class="container">
                            <p class="copyright-text text-center"><?php echo sprintf( 'Copyright <i class="fal fa-copyright"></i> %s <a href="%s"> %s </a> All Rights Reserved.', date('Y'), esc_url('#'), esc_html__( 'Piller.','piller') ); ?></p> 
                        </div>
                    </div>
                </div>
            <?php }

        }
    }

    // blog details wrapper start hook function
    if( !function_exists('piller_blog_details_wrapper_start_cb') ) {
        function piller_blog_details_wrapper_start_cb( ) {
            echo '<section class="th-blog-wrapper blog-details space-top space-extra-bottom">';
                echo '<div class="container">';
                    if( is_active_sidebar( 'piller-blog-sidebar' ) ){
                        $piller_gutter_class = 'gx-60';
                    }else{
                        $piller_gutter_class = '';
                    }
                    // echo '<div class="row './/esc_attr( $piller_gutter_class ).'">';
                    echo '<div class="row">';
        }
    }

    // blog details column wrapper start hook function
    if( !function_exists('piller_blog_details_col_start_cb') ) {
        function piller_blog_details_col_start_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $piller_blog_single_sidebar = piller_opt('piller_blog_single_sidebar');
                if( $piller_blog_single_sidebar == '2' && is_active_sidebar('piller-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7 order-lg-last">';
                } elseif( $piller_blog_single_sidebar == '3' && is_active_sidebar('piller-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('piller-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }

    // blog details post meta hook function
    if( !function_exists('piller_blog_post_meta_cb') ) { 
        function piller_blog_post_meta_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $piller_display_post_author      =  piller_opt('piller_display_post_author');
                $piller_display_post_date      =  piller_opt('piller_display_post_date');
                $piller_display_post_cate   =  piller_opt('piller_display_post_cate');
                $piller_display_post_comments      =  piller_opt('piller_display_post_comments');
                $piller_display_post_min      =  piller_opt('piller_display_post_min');
                $piller_post_read_min_text      =  piller_opt('piller_post_read_min_text');
                $piller_post_read_min_count      =  piller_opt('piller_post_read_min_count');
            } else {
                $piller_display_post_author      = '1';
                $piller_display_post_date      = '1';
                $piller_display_post_cate   = '0';
                $piller_display_post_comments      = '0'; 
                $piller_display_post_min      = '1'; 
                $piller_post_read_min_text      = 'min read'; 
                $piller_post_read_min_count      = '150'; 
            }

                echo '<div class="blog-meta">';
                    if( $piller_display_post_author ){
                        echo '<a class="author" href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fa-solid fa-user"></i>'. esc_html__('By ', 'piller') .esc_html( ucwords( get_the_author() ) ).'</a>';
                    }
                    if( $piller_display_post_date ){
                        echo ' <a href="'.esc_url( piller_blog_date_permalink() ).'"><i class="fa-solid fa-calendar"></i>'.esc_html( get_the_date() ).'</a>';
                    }
                    if( $piller_display_post_cate ){
                        $categories = get_the_category(); 
                        if(!empty($categories)){
                        echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'"><i class="fa-solid fa-tag"></i>'.esc_html( $categories[0]->name ).'</a>';
                        }
                    }
                    if( $piller_display_post_comments ){
                        ?>
                        <a href="#"><i class="fa-solid fa-comments"></i>
                            <?php 
                                echo get_comments_number(); 
                                if(get_comments_number() == 1){
                                    echo esc_html__(' Comment', 'piller'); 
                                }else{
                                    echo esc_html__(' Comments', 'piller'); 
                                }
                                ?></a>
                        <?php
                    } 
                    if( $piller_display_post_min ){
                        if (function_exists('piller_get_reading_time')) {
                            echo '<a href="#">';
                                echo '<i class="fa-solid fa-clock"></i>';
                                echo piller_get_reading_time(get_the_ID());
                            echo '</a>';
                        }   
                    }
                echo '</div>';
        }
    }

    // Blog post reading time count
    function piller_get_reading_time($post_id) {
        if (class_exists('ReduxFramework')) {
            $piller_post_read_min_text = !empty(piller_opt('piller_post_read_min_text')) 
                                        ? sanitize_text_field(piller_opt('piller_post_read_min_text')) 
                                        : esc_html__('min read', 'piller');
            $words_per_minute = !empty(piller_opt('piller_post_read_min_count')) 
                                ? (int) piller_opt('piller_post_read_min_count') 
                                : 150;
        } else {
            $piller_post_read_min_text = esc_html__('min read', 'piller');
            $words_per_minute = 150;
        }
        
        // Get the content of the post
        $content = get_post_field('post_content', $post_id);
        
        // Count the number of words
        $word_count = str_word_count(strip_tags($content));
        
        // Calculate the reading time
        $reading_time = ceil($word_count / $words_per_minute);
        
        // Return the estimated reading time without the anchor tag
        return esc_html($reading_time . ' ' . $piller_post_read_min_text);
    }

    // blog details share options hook function
    if( !function_exists('piller_blog_details_share_options_cb') ) {
        function piller_blog_details_share_options_cb( ) {

            if( class_exists('ReduxFramework') ) {
                $piller_post_details_share = piller_opt('piller_post_details_share_options');
            } else {
                $piller_post_details_share = "0";
            } 

            if( function_exists( 'piller_social_sharing_buttons' ) ){ 
                if( $piller_post_details_share ){
                    echo '<div class="col-sm-auto text-xl-end">'; 
                        echo '<span class="share-links-title">'.esc_html__('Share this article:', 'piller').'</span>';
                       echo '<div class="th-social">';
                            echo piller_social_sharing_buttons();
                        echo '</div>';
                    echo '</div>';
                }
            }
            
    
        }
    }
    
    
    // blog details author bio hook function
    if( !function_exists('piller_blog_details_author_bio_cb') ) {
        function piller_blog_details_author_bio_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $postauthorbox =  piller_opt( 'piller_post_details_author_box' );
            } else {
                $postauthorbox = '0';
            }
            if(  $postauthorbox == '1' ) {
                echo '<div class="widget widget-author">';
                    echo '<div class="author-widget-wrap">';
                        echo '<div class="avater">';
                            echo '<img src="'.esc_url( get_avatar_url( get_the_author_meta('ID') ) ).'" alt="'.esc_attr__('Author Image', 'piller').'">';
                        echo '</div>';
                        echo '<div class="author-info">';
                            echo '<h4 class="box-title"><a class="text-inherit" href="blog.html">'.esc_html( ucwords( get_the_author() )).'</a></h4>';
                            echo '<span class="desig">'.get_user_meta( get_the_author_meta('ID'), '_piller_author_desig',true ).'</span>';
                            echo '<p class="author-bio">'.get_the_author_meta( 'user_description', get_the_author_meta('ID') ).'</p>';
                            echo '<div class="social-links">';
                                $piller_social_icons = get_user_meta( get_the_author_meta('ID'), '_piller_social_profile_group',true );
                                if(!empty($piller_social_icons)){
                                    foreach( $piller_social_icons as $singleicon ) {
                                        if( ! empty( $singleicon['_piller_social_profile_icon'] ) ) {
                                            echo '<a href="'.esc_url( $singleicon['_piller_lawyer_social_profile_link'] ).'"><i class="'.esc_attr( $singleicon['_piller_social_profile_icon'] ).'"></i></a>';
                                        }
                                    }
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';

               
            }

        }
    }

     // Blog Details Post Navigation hook function
     if( !function_exists( 'piller_blog_details_post_navigation_cb' ) ) {
        function piller_blog_details_post_navigation_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $piller_post_navigation = piller_opt('piller_post_details_post_navigation');
            } else {
                $piller_post_navigation = 0;
            }

            $prevpost = get_previous_post();
            $nextpost = get_next_post();

            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            ); 

            if( ($piller_post_navigation == '1') && (!empty($prevpost) || !empty($nextpost)) ) {
                echo '<div class="blog-navigation">'; 
                    if( ! empty( $prevpost ) ) {
                        echo '<a href="'.esc_url( get_permalink( $prevpost->ID ) ).'" class="nav-btn prev">';
                            echo '<i class="fa-solid fa-angle-left"></i>';
                            echo ' <span class="nav-text">'.esc_attr__('Previous', 'piller').'</span>';
                        echo '</a>';
                    }

                    if( ! empty( $nextpost ) ) {
                        echo '<a href="'.esc_url( get_permalink( $nextpost->ID ) ).'" class="nav-btn next">';
                            echo '<i class="fa-solid fa-angle-right"></i>';
                            echo ' <span class="nav-text">'.esc_attr__('Next', 'piller').'</span>';
                        echo '</a>';
                    }
                echo '</div>';
            }

        }
    }

    // Blog Details Comments hook function
    if( !function_exists('piller_blog_details_comments_cb') ) {
        function piller_blog_details_comments_cb( ) {
            if ( ! comments_open() ) {
                echo '<div class="blog-comment-area">';
                    echo piller_heading_tag( array(
                        "tag"   => "h3",
                        "text"  => esc_html__( 'Comments are closed', 'piller' ),
                        "class" => "inner-title"
                    ) );
                echo '</div>';
            }

            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }
        }
    }

    // Blog Details Column end hook function
    if( !function_exists('piller_blog_details_col_end_cb') ) {
        function piller_blog_details_col_end_cb( ) {
            echo '</div>';
        }
    }

    // Blog Details Wrapper end hook function
    if( !function_exists('piller_blog_details_wrapper_end_cb') ) {
        function piller_blog_details_wrapper_end_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page start wrapper hook function
    if( !function_exists('piller_page_start_wrap_cb') ) {
        function piller_page_start_wrap_cb( ) {
            
            if( is_page( 'cart' ) ){
                $section_class = "th-cart-wrapper space-top space-extra-bottom";
            }elseif( is_page( 'checkout' ) ){
                $section_class = "th-checkout-wrapper space-top space-extra-bottom";
            }elseif( is_page('wishlist') ){
                $section_class = "wishlist-area space-top space-extra-bottom";
            }else{
                $section_class = "space-top space-extra-bottom";  
            }
            echo '<section class="'.esc_attr( $section_class ).'">';
                echo '<div class="container">';
                    echo '<div class="row">';
        }
    }

    // page wrapper end hook function
    if( !function_exists('piller_page_end_wrap_cb') ) {
        function piller_page_end_wrap_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page column wrapper start hook function
    if( !function_exists('piller_page_col_start_wrap_cb') ) {
        function piller_page_col_start_wrap_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $piller_page_sidebar = piller_opt('piller_page_sidebar');
            }else {
                $piller_page_sidebar = '1';
            }
            
            if( $piller_page_sidebar == '2' && is_active_sidebar('piller-page-sidebar') ) {
                echo '<div class="col-lg-8 order-last">';
            } elseif( $piller_page_sidebar == '3' && is_active_sidebar('piller-page-sidebar') ) {
                echo '<div class="col-lg-8">';
            } else {
                echo '<div class="col-lg-12">';
            }

        }
    }

    // page column wrapper end hook function
    if( !function_exists('piller_page_col_end_wrap_cb') ) {
        function piller_page_col_end_wrap_cb( ) {
            echo '</div>';
        }
    }

    // page sidebar hook function
    if( !function_exists('piller_page_sidebar_cb') ) {
        function piller_page_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $piller_page_sidebar = piller_opt('piller_page_sidebar');
            }else {
                $piller_page_sidebar = '1';
            }

            if( class_exists('ReduxFramework') ) {
                $piller_page_layoutopt = piller_opt('piller_page_layoutopt');
            }else {
                $piller_page_layoutopt = '3';
            }

            if( $piller_page_layoutopt == '1' && $piller_page_sidebar != 1 ) {
                get_sidebar('page');
            } elseif( $piller_page_layoutopt == '2' && $piller_page_sidebar != 1 ) {
                get_sidebar();
            }
        }
    }

    // page content hook function
    if( !function_exists('piller_page_content_cb') ) {
        function piller_page_content_cb( ) {
            if(  class_exists('woocommerce') && ( is_woocommerce() || is_cart() || is_checkout() || is_page('wishlist') || is_account_page() )  ) {
                echo '<div class="woocommerce--content">';
            } else {
                echo '<div class="page--content clearfix">';
            }

                the_content();

                // Link Pages
                piller_link_pages();

            echo '</div>';
            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }

        }
    }

    if( !function_exists('piller_blog_post_thumb_cb') ) {
        function piller_blog_post_thumb_cb( ) {
            if( get_post_format() ) {
                $format = get_post_format();
            }else{
                $format = 'standard';
            }

            $piller_post_slider_thumbnail = piller_meta( 'post_format_slider' );

            if( $format == 'gallery' ){
                    if( !empty( $piller_post_slider_thumbnail ) ){
                    echo '<div class="blog-img th-slider" data-slider-options=\'{"effect":"fade"}\'>';
                        echo '<div class="swiper-wrapper">';
                            foreach( $piller_post_slider_thumbnail as $single_image ){
                                echo '<div class="swiper-slide">';
                                    echo piller_img_tag( array(
                                        'url'   => esc_url( $single_image )
                                    ) );
                                echo '</div>';
                            }
                        echo '</div>';
                        echo '<button class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                        echo '<button class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
                    echo '</div>';
                }else{
                    echo '<div class="blog-img global-img">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">'; 
                        }

                        the_post_thumbnail();

                        if( ! is_single() ){
                            echo '</a>';
                        }
                    echo '</div>';
                }

            }elseif( has_post_thumbnail() && $format == 'standard' ) {
                echo '<!-- Post Thumbnail -->';
                echo '<div class="blog-img global-img">';
                    if( ! is_single() ){
                        echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">'; 
                    }

                    the_post_thumbnail();

                    if( ! is_single() ){
                        echo '</a>';
                    }
                echo '</div>';
                echo '<!-- End Post Thumbnail -->';
            }elseif( $format == 'video' ){
                if( has_post_thumbnail() && ! empty ( piller_meta( 'post_format_video' ) ) ){
                    echo '<div class="blog-img blog-video">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            the_post_thumbnail();

                        if( ! is_single() ){
                            echo '</a>';
                        }
                        echo '<a href="'.esc_url( piller_meta( 'post_format_video' ) ).'" class="play-btn popup-video">';
                            echo '<i class="fas fa-play"></i>';
                        echo '</a>';
                    echo '</div>';
                }elseif( ! has_post_thumbnail() && ! is_single() ){
                    echo '<div class="blog-video">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            echo piller_embedded_media( array( 'video', 'iframe' ) );
                        if( ! is_single() ){
                            echo '</a>';
                        }
                    echo '</div>';
                }
            }elseif( $format == 'audio' ){
                $piller_audio = piller_meta( 'post_format_audio' );
                if( ! empty( $piller_audio ) ){
                    echo '<div class="blog-audio">';
                        echo wp_oembed_get( $piller_audio );
                    echo '</div>';
                }elseif( ! is_single() ){
                    echo '<div class="blog-audio">';
                        echo wp_oembed_get( $piller_audio );
                    echo '</div>';
                }
            }

        }
    }

    if( !function_exists('piller_blog_post_content_cb') ) {
        function piller_blog_post_content_cb( ) {
            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );
            if( class_exists( 'ReduxFramework' ) ) {
                $piller_excerpt_length          = piller_opt( 'piller_blog_postExcerpt' );
                $piller_display_post_category   = piller_opt( 'piller_display_post_category' );
            } else {
                $piller_excerpt_length          = '35';
                $piller_display_post_category   = '1';
            }

            if( class_exists( 'ReduxFramework' ) ) {
                $piller_blog_admin = piller_opt( 'piller_blog_post_author' );
                $piller_blog_readmore_setting_val = piller_opt('piller_blog_readmore_setting');
                if( $piller_blog_readmore_setting_val == 'custom' ) {
                    $piller_blog_readmore_setting = piller_opt('piller_blog_custom_readmore');
                } else {
                    $piller_blog_readmore_setting = __( 'Read More', 'piller' );
                }
            } else {
                $piller_blog_readmore_setting = __( 'Read More', 'piller' );
                $piller_blog_admin = true;
            }
            echo '<!-- blog-content -->';

                do_action( 'piller_blog_post_thumb' );
                
                echo '<div class="blog-content">';

                    // Blog Post Meta
                    do_action( 'piller_blog_post_meta' ); 

                    echo '<h3 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.wp_kses( get_the_title( ), $allowhtml ).'</a></h3>';

                    echo '<!-- Post Summary -->';
                    echo piller_paragraph_tag( array(
                        "text"  => wp_kses( wp_trim_words( get_the_excerpt(), $piller_excerpt_length, '' ), $allowhtml ),
                        "class" => 'blog-text',
                    ) );
  
                    if( !empty( $piller_blog_readmore_setting ) ){
                        echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn pill style3">'.esc_html( $piller_blog_readmore_setting ).'</a>';
                    }

                echo '</div>';
            echo '<!-- End Post Content -->';
        }
    }
