<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */

// enqueue css
function piller_common_custom_css(){
	wp_enqueue_style( 'piller-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = piller_opt( 'piller_css_editor' );
	if( $CustomCssOpt ){
		$CustomCssOpt = $CustomCssOpt;
	}else{
		$CustomCssOpt = '';
	}

    $customcss = "";
    
    if( get_header_image() ){
        $piller_header_bg =  get_header_image();
    }else{
        if( piller_meta( 'page_breadcrumb_settings' ) == 'page' ){
            if( ! empty( piller_meta( 'breadcumb_image' ) ) ){
                $piller_header_bg = piller_meta( 'breadcumb_image' );
            }
        }
    }
    
    if( !empty( $piller_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$piller_header_bg}')!important;
        }";
    }
    
	// Theme color
	$pillerthemecolor = piller_opt('piller_theme_color'); 
    if( !empty( $pillerthemecolor ) ){
        list($r, $g, $b) = sscanf( $pillerthemecolor, "#%02x%02x%02x");

        $piller_real_color = $r.','.$g.','.$b;
        if( !empty( $pillerthemecolor ) ) {
            $customcss .= ":root {
            --theme-color: rgb({$piller_real_color});
            }";
        }
    }

    // Heading  color
	$pillerheadingcolor = piller_opt('piller_heading_color');
    if( !empty( $pillerheadingcolor ) ){
        list($r, $g, $b) = sscanf( $pillerheadingcolor, "#%02x%02x%02x");

        $piller_real_color = $r.','.$g.','.$b;
        if( !empty( $pillerheadingcolor ) ) {
            $customcss .= ":root {
                --title-color: rgb({$piller_real_color});
            }";
        }
    }
    // Body color
	$pillerbodycolor = piller_opt('piller_body_color');
    if( !empty( $pillerbodycolor ) ){
        list($r, $g, $b) = sscanf( $pillerbodycolor, "#%02x%02x%02x");

        $piller_real_color = $r.','.$g.','.$b;
        if( !empty( $pillerbodycolor ) ) {
            $customcss .= ":root {
                --body-color: rgb({$piller_real_color});
            }";
        }
    }

     // Body font
     $pillerbodyfont = piller_opt('piller_theme_body_font', 'font-family');
     if( !empty( $pillerbodyfont ) ) {
         $customcss .= ":root {
             --body-font: $pillerbodyfont ;
         }";
     }
 
     // Heading font
     $pillerheadingfont = piller_opt('piller_theme_heading_font', 'font-family');
     if( !empty( $pillerheadingfont ) ) {
         $customcss .= ":root {
             --title-font: $pillerheadingfont ;
         }";
     }


    if(piller_opt('piller_menu_icon_class')){
        $menu_icon_class = piller_opt( 'piller_menu_icon_class' );
    }else{
        $menu_icon_class = 'e00f';
    }

    if( !empty( $menu_icon_class ) ) {
        $customcss .= ".main-menu ul.sub-menu li a:before {
                content: \"\\$menu_icon_class\" !important;
            }";
    }

	if( !empty( $CustomCssOpt ) ){
		$customcss .= $CustomCssOpt;
	}

    wp_add_inline_style( 'piller-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'piller_common_custom_css', 100 );