<?php

/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

 /**
 * Only return default value if we don't have a post ID (in the 'post' query variable)
 *
 * @param  bool  $default On/Off (true/false)
 * @return mixed          Returns true or '', the blank default
 */
function piller_set_checkbox_default_for_new_post( $default ) {
	return isset( $_GET['post'] ) ? '' : ( $default ? (string) $default : '' );
}

add_action( 'cmb2_admin_init', 'piller_register_metabox' );

/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */

function piller_register_metabox() {

	$prefix = '_piller_';

	$prefixpage = '_pillerpage_';
	
	$piller_post_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'blog_post_control',
		'title'         => esc_html__( 'Post Thumb Controller', 'piller' ),
		'object_types'  => array( 'post' ), // Post type
		'closed'        => true
	) );

    $piller_post_meta->add_field( array(
        'name' => esc_html__( 'Post Format Video', 'piller' ),
        'desc' => esc_html__( 'Use This Field When Post Format Video', 'piller' ),
        'id'   => $prefix . 'post_format_video',
        'type' => 'text_url',
    ) );

	$piller_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Audio', 'piller' ),
		'desc' => esc_html__( 'Use This Field When Post Format Audio', 'piller' ),
		'id'   => $prefix . 'post_format_audio',
        'type' => 'oembed',
    ) );
	$piller_post_meta->add_field( array(
		'name' => esc_html__( 'Post Thumbnail For Slider', 'piller' ),
		'desc' => esc_html__( 'Use This Field When You Want A Slider In Post Thumbnail', 'piller' ),
		'id'   => $prefix . 'post_format_slider',
        'type' => 'file_list',
    ) );
	
	$piller_page_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_meta_section',
		'title'         => esc_html__( 'Page Meta', 'piller' ),
		'object_types'  => array( 'page', 'piller_event' ), // Post type
        'closed'        => true
    ) );

    $piller_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Area', 'piller' ),
		'desc' => esc_html__( 'check to display page breadcrumb area.', 'piller' ),
		'id'   => $prefix . 'page_breadcrumb_area',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','piller'),
            '2'     => esc_html__('Hide','piller'),
        )
    ) );


    $piller_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Settings', 'piller' ),
		'id'   => $prefix . 'page_breadcrumb_settings',
        'type' => 'select',
        'default'   => 'global',
        'options'   => array(
            'global'   => esc_html__('Global Settings','piller'),
            'page'     => esc_html__('Page Settings','piller'),
        )
	) );

    $piller_page_meta->add_field( array(
        'name'    => esc_html__( 'Breadcumb Image', 'piller' ),
        'desc'    => esc_html__( 'Upload an image or enter an URL.', 'piller' ),
        'id'      => $prefix . 'breadcumb_image',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => false, // Hide the text input for the url
        ),
        'text'    => array(
            'add_upload_file_text' => __( 'Add File', 'piller' ) // Change upload button text. Default: "Add or Upload File"
        ),
        'preview_size' => 'large', // Image size to use when previewing in the admin.
    ) );

    $piller_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title', 'piller' ),
		'desc' => esc_html__( 'check to display Page Title.', 'piller' ),
		'id'   => $prefix . 'page_title',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','piller'),
            '2'     => esc_html__('Hide','piller'),
        )
	) );

    $piller_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title Settings', 'piller' ),
		'id'   => $prefix . 'page_title_settings',
        'type' => 'select',
        'options'   => array(
            'default'  => esc_html__('Default Title','piller'),
            'custom'  => esc_html__('Custom Title','piller'),
        ),
        'default'   => 'default'
    ) );

    $piller_page_meta->add_field( array(
		'name' => esc_html__( 'Custom Page Title', 'piller' ),
		'id'   => $prefix . 'custom_page_title',
        'type' => 'text'
    ) );

    $piller_page_meta->add_field( array(
		'name' => esc_html__( 'Breadcrumb', 'piller' ),
		'desc' => esc_html__( 'Select Show to display breadcrumb area', 'piller' ),
		'id'   => $prefix . 'page_breadcrumb_trigger',
        'type' => 'switch_btn',
        'default' => piller_set_checkbox_default_for_new_post( true ),
    ) );

    $piller_layout_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_layout_section',
		'title'         => esc_html__( 'Page Layout', 'piller' ),
        'context' 		=> 'side',
        'priority' 		=> 'high',
        'object_types'  => array( 'page' ), // Post type
        'closed'        => true
	) );

	$piller_layout_meta->add_field( array(
		'desc'       => esc_html__( 'Set page layout container,container fluid,fullwidth or both. It\'s work only in template builder page.', 'piller' ),
		'id'         => $prefix . 'custom_page_layout',
		'type'       => 'radio',
        'options' => array(
            '1' => esc_html__( 'Container', 'piller' ),
            '2' => esc_html__( 'Container Fluid', 'piller' ),
            '3' => esc_html__( 'Fullwidth', 'piller' ),
        ),
	) );

	// code for body class//

    $piller_layout_meta->add_field( array(
	'name' => esc_html__( 'Insert Your Body Class', 'piller' ),
	'id'   => $prefix . 'custom_body_class',
	'type' => 'text'
    ) );

    $piller_extra_listing_meta = new_cmb2_box( array(
        'id'            => $prefixpage . 'listingmeta_section',
        'title'         => esc_html__( 'Additional Informations', 'piller' ),
        'object_types'  => array( 'at_biz_dir' ), // Post type
        'closed'        => true,
        'context'       => 'side',
        'priority'      => 'default'
    ) );
 
    $piller_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Address', 'piller' ),
        'id'   => $prefix . 'piller_address',
        'type' => 'text'
    ) );
    $piller_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Bad Room', 'piller' ),
        'id'   => $prefix . 'piller_bed_count',
        'type' => 'text'
    ) );
    $piller_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Bath Room', 'piller' ),
        'id'   => $prefix . 'piller_bath_count',
        'type' => 'text'
    ) );
    $piller_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Room Size', 'piller' ),
        'id'   => $prefix . 'piller_room_size',
        'type' => 'text'
    ) );

}

add_action( 'cmb2_admin_init', 'piller_register_taxonomy_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function piller_register_taxonomy_metabox() {

    $prefix = '_piller_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$piller_term_meta = new_cmb2_box( array(
		'id'               => $prefix.'term_edit',
		'title'            => esc_html__( 'Category Metabox', 'piller' ),
		'object_types'     => array( 'term' ),
		'taxonomies'       => array( 'category'),
	) );
	$piller_term_meta->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'piller' ),
		'id'       => $prefix.'term_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );
	$piller_term_meta->add_field( array(
		'name' => esc_html__( 'Category Icon', 'piller' ),
		'desc' => esc_html__( 'Set Category Icon', 'piller' ),
		'id'   => $prefix.'term_avatar',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Icon','piller') // Change upload button text. Default: "Add or Upload File"
		),
	) );


	/**
	 * Metabox for the user profile screen
	 */
	$piller_user = new_cmb2_box( array(
		'id'               => $prefix.'user_edit',
		'title'            => esc_html__( 'User Profile Metabox', 'piller' ), // Doesn't output for user boxes
		'object_types'     => array( 'user' ), // Tells CMB2 to use user_meta as post_meta
		'show_names'       => true,
		'new_user_section' => 'add-new-user', // where form will show on new user page. 'add-existing-user' is only other valid option.
	) );
    $piller_user->add_field( array(
		'name' => esc_html__( 'Author Designation', 'piller' ),
		'desc' => esc_html__( 'Use This Field When Author Designation', 'piller' ),
		'id'   => $prefix . 'author_desig',
        'type' => 'text',
    ) );
	$piller_user->add_field( array(
		'name'     => esc_html__( 'Social Profile', 'piller' ),
		'id'       => $prefix.'user_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );

	$group_field_id = $piller_user->add_field( array(
        'id'          => $prefix .'social_profile_group',
        'type'        => 'group',
        'description' => __( 'Social Profile', 'piller' ),
        'options'     => array(
            'group_title'       => __( 'Social Profile {#}', 'piller' ), // since version 1.1.4, {#} gets replaced by row number
            'add_button'        => __( 'Add Another Social Profile', 'piller' ),
            'remove_button'     => __( 'Remove Social Profile', 'piller' ),
            'closed'         => true
        ),
    ) );

    $piller_user->add_group_field( $group_field_id, array(
        'name'        => __( 'Icon Class', 'piller' ),
        'id'          => $prefix .'social_profile_icon',
        'type'        => 'text', // This field type
    ) );

    $piller_user->add_group_field( $group_field_id, array(
        'desc'       => esc_html__( 'Set social profile link.', 'piller' ),
        'id'         => $prefix . 'lawyer_social_profile_link',
        'name'       => esc_html__( 'Social Profile link', 'piller' ),
        'type'       => 'text'
    ) );
}
