<?php
/**
 * @Packge     : Piller
 * @Version    : 1.0
 * @Author     : Themehour
 * @Author URI : https://themeforest.net/user/themehour
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $piller_post_id = get_the_ID();

            // Get the page settings manager
            $piller_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $piller_page_settings_model = $piller_page_settings_manager->get_model( $piller_post_id );

            // Retrieve the color we added before
            $piller_header_style = $piller_page_settings_model->get_settings( 'piller_header_style' );
            $piller_header_builder_option = $piller_page_settings_model->get_settings( 'piller_header_builder_option' );

            if( $piller_header_style == 'header_builder'  ) {

                if( !empty( $piller_header_builder_option ) ) {
                    $pillerheader = get_post( $piller_header_builder_option );
                    echo '<header class="header">';
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $pillerheader->ID );
                    echo '</header>';
                }
            } else {
                // global options
                $piller_header_builder_trigger = piller_opt('piller_header_options');
                if( $piller_header_builder_trigger == '2' ) {
                    echo '<header>';
                    $piller_global_header_select = get_post( piller_opt( 'piller_header_select_options' ) );
                    $header_post = get_post( $piller_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                    echo '</header>';
                } else {
                    // wordpress Header
                    piller_global_header_option();
                }
            }
        } else {
            $piller_header_options = piller_opt('piller_header_options');
            if( $piller_header_options == '1' ) {
                piller_global_header_option();
            } else {
                $piller_header_select_options = piller_opt('piller_header_select_options');
                $pillerheader = get_post( $piller_header_select_options );
                echo '<header class="header">';
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $pillerheader->ID );
                echo '</header>';
            }
        }
    } else {
        piller_global_header_option();
    }